/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.yaml;

import com.alibaba.fastjson.JSONObject;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.apiext.yaml.StrictMapAppenderConstructor;
import net.wicp.tams.common.constant.PathType;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.reader.UnicodeReader;

public abstract class YamlAssist {
    public static Result isOk(FileInputStream fileInputStream) {
        Yaml yaml = new Yaml((BaseConstructor)new StrictMapAppenderConstructor());
        Result retobj = null;
        try {
            UnicodeReader reader = new UnicodeReader((InputStream)fileInputStream);
            for (Object t : yaml.loadAll((Reader)reader)) {
            }
            retobj = Result.getSuc();
        }
        catch (Exception e) {
            retobj = Result.getError(e.getMessage());
        }
        return retobj;
    }

    public static Result isOk(String fileName) {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            return Result.getError("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        return YamlAssist.isOk(inputstream);
    }

    public static JSONObject readYaml(FileInputStream fileInputStream) {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load((InputStream)fileInputStream);
        JSONObject json = JSONObject.parseObject((String)JSONUtil.getJsonForMap(map));
        return json;
    }

    public static JSONObject readYamlByPathType(String pathTypepath) {
        return YamlAssist.readYaml(PathType.getPath(pathTypepath));
    }

    public static JSONObject readYamlStr(String yamlstr) {
        Yaml yaml = new Yaml();
        Map map = (Map)yaml.load(yamlstr);
        JSONObject json = JSONObject.parseObject((String)JSONUtil.getJsonForMap(map));
        return json;
    }

    public static JSONObject readYaml(String filePath) {
        FileInputStream inputstream = null;
        try {
            JSONObject retjson;
            inputstream = new FileInputStream(filePath);
            JSONObject jSONObject = retjson = YamlAssist.readYaml(inputstream);
            return jSONObject;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("file not exit");
        }
        finally {
            try {
                inputstream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Map<String, Object> yamlToFlattenedMap(String yamlContent) {
        Yaml yaml = YamlAssist.createYaml();
        Map<String, Object> map = new HashMap<String, Object>();
        for (Object object : yaml.loadAll(yamlContent)) {
            if (object == null) continue;
            map = CollectionUtil.asMap(object);
            map = CollectionUtil.getFlattenedMap(map);
        }
        return map;
    }

    public static Map<String, Object> yamlToMultilayerMap(String yamlContent) {
        Yaml yaml = YamlAssist.createYaml();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Object object : yaml.loadAll(yamlContent)) {
            if (object == null) continue;
            result.putAll(CollectionUtil.asMap(object));
        }
        return result;
    }

    public static String multilayerMapToYaml(Map<String, Object> map) {
        Yaml yaml = YamlAssist.createYaml();
        return yaml.dumpAsMap(map);
    }

    public static String flattenedMapToYaml(Map<String, Object> map) {
        Yaml yaml = YamlAssist.createYaml();
        return yaml.dumpAsMap(CollectionUtil.flattenedMapToMultilayerMap(map));
    }

    private static Yaml createYaml() {
        return new Yaml((BaseConstructor)new Constructor());
    }
}

