/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcConnection {
    private static final Logger log = LoggerFactory.getLogger(JdbcConnection.class);

    public static Connection getConnection(String driverName, String dburl, String userName, String pwd) {
        Connection conn = null;
        try {
            Class.forName(driverName);
            conn = StringUtil.isNull(userName) || StringUtil.isNull(pwd) ? DriverManager.getConnection(dburl) : DriverManager.getConnection(dburl, userName, pwd);
            return conn;
        }
        catch (Exception e) {
            log.error(String.format("\u8fde\u63a5\u9519\u8bef\uff0c\u5730\u5740[%s]", dburl), (Throwable)e);
            return null;
        }
    }

    public static Connection getConnection(String driverName, String dburl) {
        return JdbcConnection.getConnection(driverName, dburl, null, null);
    }

    public static Connection getConnectionMyql(String dburl) {
        return JdbcConnection.getConnection("com.mysql.jdbc.Driver", dburl);
    }

    public static Connection getConnectionMyql(String dburl, String userName, String pwd) {
        return JdbcConnection.getConnection("com.mysql.jdbc.Driver", dburl, userName, pwd);
    }

    public static Connection getConnectionMyql(String host, int port, String user, String pwd, YesOrNo isSsh) {
        String url;
        if (isSsh != null && isSsh == YesOrNo.yes) {
            SshAssist.ssh(Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")), host, port);
            url = DbType.mysql.geturl("localhost", Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")));
        } else {
            url = DbType.mysql.geturl(host, port);
        }
        Connection conn = JdbcConnection.getConnectionMyql(url, user, pwd);
        return conn;
    }

    public static Connection getConnection(DbType dbType, String host, int port, String user, String pwd) {
        String connurl = dbType.geturl(host, port);
        return JdbcConnection.getConnection(dbType.getJdbcDriver(), connurl, user, pwd);
    }

    public static Connection getConnection(DbType dbType, String host, String user, String pwd) {
        return JdbcConnection.getConnection(dbType, host, dbType.getDefaultPort(), user, pwd);
    }

    public static Connection getConnectionByInstanceId(String dbInstanceId) {
        Properties props = Conf.getPreToProp("common.jdbc.datasource.default", true);
        if (!"default".equals(dbInstanceId)) {
            Map<String, String> map = Conf.getPre("common.jdbc.datasource." + dbInstanceId, true);
            for (String key : map.keySet()) {
                props.put(key, map.get(key));
            }
        }
        String url = DbType.mysql.geturl(JdbcConnection.get(props, "host"), Integer.parseInt(JdbcConnection.get(props, "port")));
        return JdbcConnection.getConnection("com.mysql.jdbc.Driver", url, JdbcConnection.get(props, "username"), JdbcConnection.get(props, "password"));
    }

    private static String get(Properties props, String key) {
        return props.get(key) == null ? null : String.valueOf(props.get(key));
    }

    public static void close(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

