/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarUtil {
    private static final Logger log = LoggerFactory.getLogger(TarUtil.class);
    private static final String TAG = TarUtil.class.getName();
    private static final int BUFFER = 1024;
    private static String mCompressSrcParentPath = "";

    public static String decompress(String tarFilePath, String directory, boolean needLastDir) {
        String retDir = directory;
        File tarFile = new File(tarFilePath);
        if (!tarFile.exists()) {
            throw new RuntimeException("tar file is not exists.");
        }
        if (!tarFile.isFile()) {
            throw new RuntimeException("compress file is not a file.");
        }
        try {
            FileInputStream ins = new FileInputStream(tarFile);
            TarUtil.decompress(ins, directory);
            Object[] list = new File(directory).list();
            if (needLastDir && ArrayUtils.isNotEmpty((Object[])list) && list.length == 1) {
                retDir = IOUtil.mergeFolderAndFilePath(directory, new String[]{list[0]});
            }
            return retDir;
        }
        catch (FileNotFoundException e) {
            log.error("\u6ca1\u6709\u8fd9\u4e2a\u6587\u4ef6:{}", (Object)tarFilePath);
            throw new RuntimeException("tar file is not exists.", e);
        }
    }

    public static String decompress(String tarFilePath, String directory) {
        return TarUtil.decompress(tarFilePath, directory, true);
    }

    public static String decompress(String tarFilePath, boolean needLastDir) {
        tarFilePath = tarFilePath.replace("\\", "/");
        int index = tarFilePath.lastIndexOf("/");
        String retpath = TarUtil.decompress(tarFilePath, tarFilePath.substring(0, index), needLastDir);
        return retpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompress(InputStream is, String directory) {
        TarArchiveInputStream in = null;
        try {
            in = new TarArchiveInputStream(is, "utf-8");
            TarArchiveEntry entry = in.getNextTarEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    entry = in.getNextTarEntry();
                    continue;
                }
                File curfile = new File(directory, entry.getName());
                File parent = curfile.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                try (OutputStream out = null;){
                    out = new FileOutputStream(curfile);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    entry = in.getNextTarEntry();
                }
            }
            in.close();
        }
        catch (Exception e) {
            log.error("compress tar error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error("compress tar error.", (Throwable)e);
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("compress tar error.", (Throwable)e);
                }
            }
        }
    }

    public static void decompress(byte[] bytes, String directory) {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        TarUtil.decompress(bais, directory);
    }

    public static String deCompressTGZFile(String filePath) {
        return TarUtil.deCompressTGZFile(new File(filePath), true);
    }

    public static String deCompressTGZFile(File file) {
        return TarUtil.deCompressTGZFile(file, true);
    }

    public static String deCompressTGZFile(File file, boolean needLastDir) {
        File tgzToTar = TarUtil.tgzToTar(file);
        String tempdir = tgzToTar.getPath().replace(".tar", "");
        String retpath = TarUtil.decompress(tgzToTar.getPath(), tempdir, needLastDir);
        try {
            FileUtils.forceDelete((File)tgzToTar);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File tgzToTar(File file) {
        if (file.isDirectory() || !file.getName().endsWith(".tgz")) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "\u89e3\u538b\u7684\u6587\u4ef6\u9700\u8981\u4ee5.tgz\u7ed3\u5c3e\uff0c\u5374\u4f20\u6765\u6587\u4ef6:" + file.getPath());
        }
        FileOutputStream out = null;
        GzipCompressorInputStream gzIn = null;
        int buffersize = 2048;
        try {
            FileInputStream fin = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(fin);
            String tarname = file.getName().replace(".tgz", ".tar");
            File outFile = new File(file.getParent() + File.separator + tarname);
            out = new FileOutputStream(outFile);
            gzIn = new GzipCompressorInputStream((InputStream)in);
            byte[] buffer = new byte[buffersize];
            int n = 0;
            while (-1 != (n = gzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
            File file2 = outFile;
            return file2;
        }
        catch (Exception e) {
            e.printStackTrace();
            File file3 = null;
            return file3;
        }
        finally {
            try {
                out.close();
                gzIn.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void compress(String srcAbsolutePath, String destAbsolutePath) {
        TarUtil.compress(new File(srcAbsolutePath), destAbsolutePath);
    }

    public static String compressCurDir(String srcAbsolutePath, String targetFileName) {
        File curDir = new File(srcAbsolutePath);
        String targetFileNameTrue = StringUtil.hasNull(targetFileName, curDir.getName());
        targetFileNameTrue = targetFileNameTrue.endsWith(".tar") ? targetFileNameTrue : targetFileNameTrue + ".tar";
        String mergeFolderAndFilePath = IOUtil.mergeFolderAndFilePath(curDir.getParent(), new String[]{targetFileNameTrue});
        TarUtil.compress(curDir, mergeFolderAndFilePath);
        return mergeFolderAndFilePath;
    }

    public static String compressCurDir(String srcAbsolutePath) {
        return TarUtil.compressCurDir(srcAbsolutePath, null);
    }

    public static void compress(File srcFile, String destAbsolutePath) {
        File destFile = new File(destAbsolutePath);
        try {
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            TarArchiveOutputStream taos = new TarArchiveOutputStream((OutputStream)new FileOutputStream(destFile));
            mCompressSrcParentPath = srcFile.getParent() + File.separator;
            TarUtil.compress(srcFile, taos);
            taos.flush();
            taos.close();
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void compress(File file, TarArchiveOutputStream taos) {
        if (file.isDirectory()) {
            TarUtil.compressDir(file, taos);
        } else {
            TarUtil.compressFile(file, taos);
        }
    }

    private static void compressDir(File dir, TarArchiveOutputStream taos) {
        File[] files = dir.listFiles();
        if (files != null) {
            if (files.length == 0) {
                try {
                    taos.putArchiveEntry((ArchiveEntry)TarUtil.createTarArchiveEntry(dir));
                    taos.closeArchiveEntry();
                }
                catch (IOException e) {
                    log.info(TAG, (Object)e.toString());
                }
            } else {
                for (File file : files) {
                    TarUtil.compress(file, taos);
                }
            }
        }
    }

    private static TarArchiveEntry createTarArchiveEntry(File file) {
        return new TarArchiveEntry(file, file.getPath().replace(mCompressSrcParentPath, ""));
    }

    private static void compressFile(File file, TarArchiveOutputStream taos) {
        try {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            taos.putArchiveEntry((ArchiveEntry)TarUtil.createTarArchiveEntry(file));
            byte[] data = new byte[1024];
            while ((count = bis.read(data, 0, 1024)) != -1) {
                taos.write(data, 0, count);
            }
            bis.close();
            taos.closeArchiveEntry();
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    public static void extract(String srcPath, String destPath) {
        File srcFile = new File(srcPath);
        if (srcFile.isFile()) {
            TarUtil.extract(srcFile, destPath);
        }
    }

    public static void extract(File srcFile, String destPath) {
        TarUtil.extract(srcFile, new File(destPath));
    }

    public static void extract(File srcFile, File destFile) {
        try {
            TarArchiveInputStream tais = new TarArchiveInputStream((InputStream)new FileInputStream(srcFile));
            TarUtil.extract(destFile, tais);
            tais.close();
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void extract(File destFile, TarArchiveInputStream tais) {
        TarArchiveEntry entry = null;
        try {
            while ((entry = tais.getNextTarEntry()) != null) {
                String dirPath = destFile.getPath() + File.separator + entry.getName();
                File dirFile = new File(dirPath);
                TarUtil.createParentDirRecursively(dirFile);
                if (entry.isDirectory()) {
                    dirFile.mkdirs();
                    continue;
                }
                TarUtil.extractFile(dirFile, tais);
            }
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void extractFile(File destFile, TarArchiveInputStream tais) {
        try {
            int count;
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
            byte[] data = new byte[1024];
            while ((count = tais.read(data, 0, 1024)) != -1) {
                bos.write(data, 0, count);
            }
            bos.close();
        }
        catch (FileNotFoundException e) {
            log.info(TAG, (Object)e.toString());
        }
        catch (IOException e) {
            log.info(TAG, (Object)e.toString());
        }
    }

    private static void createParentDirRecursively(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            TarUtil.createParentDirRecursively(parentFile);
            parentFile.mkdir();
        }
    }
}

