/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import cn.hutool.crypto.digest.BCrypt;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.DES;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PwdUtil {
    private static final Logger log = LoggerFactory.getLogger(PwdUtil.class);
    private static Cipher cipher;

    public static final String hashpw(String pwd) {
        String gensalt = BCrypt.gensalt();
        String saltPassword = BCrypt.hashpw((String)pwd, (String)gensalt);
        return saltPassword;
    }

    public static final String StringToBase64(String key) {
        return new String(Base64.encodeBase64((byte[])StringUtil.hexStringToBytes(key)));
    }

    public static final String base64FromBin(byte[] src) {
        Base64 base64 = new Base64();
        try {
            return new String(base64.encode(src), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static final String Base64ToString(String key) {
        return StringUtil.bytesToHexString(Base64.decodeBase64((byte[])key.getBytes()));
    }

    public static final String MD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] strTemp = s.getBytes();
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; ++i) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
            }
            return new String(str);
        }
        catch (Exception e) {
            log.error("MD5\u52a0\u5bc6\u5931\u8d25");
            return null;
        }
    }

    private static byte[] GetKeyBytes(String strKey) throws Exception {
        int i;
        if (null == strKey || strKey.length() < 1) {
            throw new Exception("key is null or empty!");
        }
        MessageDigest alg = MessageDigest.getInstance("MD5");
        alg.update(strKey.getBytes(Conf.get("common.apiext.encode")));
        byte[] bkey = alg.digest();
        int start = bkey.length;
        byte[] bkey24 = new byte[24];
        for (i = 0; i < start; ++i) {
            bkey24[i] = bkey[i];
        }
        for (i = start; i < 24; ++i) {
            bkey24[i] = bkey[i - start];
        }
        return bkey24;
    }

    private static byte[] encryptMode(byte[] keybyte, byte[] src, DES des) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, des.name());
            Cipher c1 = Cipher.getInstance(des.name());
            c1.init(1, deskey);
            return c1.doFinal(src);
        }
        catch (Exception e1) {
            log.error("\u52a0\u5bc6\u6570\u636e\u5931\u8d25", (Throwable)e1);
            return null;
        }
    }

    private static byte[] decryptMode(byte[] keybyte, byte[] src, DES des) {
        try {
            SecretKeySpec deskey = new SecretKeySpec(keybyte, des.name());
            Cipher c1 = Cipher.getInstance(des.name());
            c1.init(2, deskey);
            return c1.doFinal(src);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u6570\u636e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String Encrypt3DES(String origValue, String key) {
        String str = null;
        try {
            str = Base64.encodeBase64String((byte[])PwdUtil.encryptMode(PwdUtil.GetKeyBytes(key), origValue.getBytes(Conf.get("common.apiext.encode")), DES.DESede));
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
        }
        return str;
    }

    public static String Encrypt3DES(String origValue) {
        return PwdUtil.Encrypt3DES(origValue, Conf.get("common.apiext.threedes.key"));
    }

    public static String Decrypt3DES(String value, String key) {
        try {
            byte[] b = PwdUtil.decryptMode(PwdUtil.GetKeyBytes(key), new Base64().decode(value), DES.DESede);
            return new String(b);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static String Decrypt3DES(String value) {
        return PwdUtil.Decrypt3DES(value, Conf.get("common.apiext.threedes.key"));
    }

    public static byte[] fromBase64(String base64str) {
        return Base64.decodeBase64((String)base64str);
    }

    public static String toBase64(byte[] bPic) {
        return Base64.encodeBase64String((byte[])bPic);
    }

    public static byte[] md5(byte[] data) {
        return PwdUtil.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream is) throws IOException {
        return PwdUtil.digest(PwdUtil.getMd5Digest(), is);
    }

    public static byte[] sha(byte[] data) {
        return PwdUtil.getShaDigest().digest(data);
    }

    public static byte[] sha(InputStream is) throws IOException {
        return PwdUtil.digest(PwdUtil.getShaDigest(), is);
    }

    public static String[] encryptByAes(String data) {
        String[] result = new String[2];
        SecretKeySpec sKeySpec = null;
        try {
            sKeySpec = new SecretKeySpec(Base64.decodeBase64((byte[])Conf.get("common.apiext.aes.key").getBytes("UTF-8")), "AES");
            cipher.init(1, sKeySpec);
            result[1] = Base64.encodeBase64String((byte[])cipher.getIV());
            result[0] = Base64.encodeBase64String((byte[])cipher.doFinal(data.getBytes("UTF-8")));
        }
        catch (IllegalBlockSizeException e) {
            log.error("IllegalBlockSize", (Throwable)e);
        }
        catch (BadPaddingException e) {
            log.error("BadPadding", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncoding", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            log.error("InvalidKey", (Throwable)e);
        }
        return result;
    }

    public static String decryptByAes(String data, String iv) {
        String result = "";
        SecretKeySpec sKeySpec = null;
        try {
            sKeySpec = new SecretKeySpec(Base64.decodeBase64((byte[])Conf.get("common.apiext.aes.key").getBytes("UTF-8")), "AES");
            cipher.init(2, (Key)sKeySpec, new IvParameterSpec(Base64.decodeBase64((byte[])iv.getBytes("UTF-8"))));
            result = new String(cipher.doFinal(Base64.decodeBase64((byte[])data.getBytes("UTF-8"))));
        }
        catch (InvalidKeyException e) {
            log.error("InvalidKey", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error("InvalidAlgorithmParameter", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            log.error("IllegalBlockSize", (Throwable)e);
        }
        catch (BadPaddingException e) {
            log.error("BadPadding", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            log.error("UnsupportedEncoding", (Throwable)e);
        }
        return result;
    }

    private static MessageDigest getMd5Digest() {
        return PwdUtil.getDigest("MD5");
    }

    private static MessageDigest getShaDigest() {
        return PwdUtil.getDigest("SHA");
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] digest(MessageDigest md, InputStream is) throws IOException {
        byte[] buffer = new byte[4096];
        int count = is.read(buffer);
        while (count > 0) {
            md.update(buffer, 0, count);
            count = is.read(buffer);
        }
        return md.digest();
    }

    static {
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            log.error("No Such Algorithm", (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            log.error("No Such Padding", (Throwable)e);
        }
    }
}

