/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.thread.threadlocal;

/**
 * 
 * @author 偏锋书生
 *
 */
public interface PerThreadValue<T> {
	/**
	 * Is a value stored (even null)?
	 */
	boolean exists();

	/**
	 * Reads the current per-thread value, or returns null if no value has been
	 * stored.
	 */
	T get();

	/**
	 * Gets the current per-thread value if it exists (even if null), or the
	 * defaultValue if no value has been stored.
	 */
	T get(T defaultValue);

	/**
	 * Sets the current per-thread value, then returns that value.
	 */
	T set(T newValue);
}
