/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.ods;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 添加列的操作类型
 * 
 * @author andy.zhou
 * 
 */
public enum AddColNameType implements IEnumCombobox {

	no("不增加列"),

	selective("只添加配置的列"),

	selective_ori("只添加配置列（列名为默认值）"),

	all("添加全部的列"),

	all_ori("添加全部的列（列名为默认值）");

	private final String desc;

	/***
	 * 得到配置的列名
	 * 
	 * @param confmap      指定的附加字段列名
	 * @param fieldFormart
	 * @return
	 */
	private List<MySqlColBean> createColList(Map<AddColName, String> confmap, FieldFormart fieldFormart) {
		List<MySqlColBean> retlist = new ArrayList<MySqlColBean>();
		for (AddColName addColName : AddColName.values()) {
			MySqlColBean retobj = new MySqlColBean();
			String colName = null;
			switch (this) {
			case no:
				break;
			case selective:
				if (MapUtils.isNotEmpty(confmap) && confmap.containsKey(addColName)) {
					colName = confmap.get(addColName);
				}
				break;
			case selective_ori:
				if (MapUtils.isNotEmpty(confmap) && confmap.containsKey(addColName)) {
					colName = addColName.getColNameTrue(fieldFormart);
				}
				break;
			case all:
				colName = addColName.getColNameTrue(fieldFormart);
				break;
			case all_ori:
				colName = addColName.getColNameTrue(fieldFormart);
				break;
			default:
				break;
			}
			if (StringUtil.isNotNull(colName)) {
				retobj.setColumnName(colName);
				retobj.setDataType(addColName.getMysqlType());
				retlist.add(retobj);
			}
		}
		return retlist;
	}

	public List<MySqlColBean> createColList(List<MySqlColBean> oriList, Map<AddColName, String> confmap,
			FieldFormart fieldFormart) {
		List<MySqlColBean> addColList = createColList(confmap, fieldFormart);
		if (CollectionUtils.isEmpty(addColList)) {
			return oriList;
		}
		if (CollectionUtils.isEmpty(oriList)) {
			return addColList;
		}
		List<String> addColNames = new ArrayList<String>();
		for (MySqlColBean addCol : addColList) {
			addColNames.add(addCol.getColumnNameStandard(fieldFormart));
		}
		// 去除已存在的字段，以addCol为主
		CollectionUtils.filter(oriList, new Predicate() {
			@Override
			public boolean evaluate(Object object) {
				MySqlColBean oriColBean = (MySqlColBean) object;
				return !addColNames.contains(oriColBean.getColumnNameStandard(fieldFormart));
			}
		});
		oriList.addAll(addColList);
		return oriList;

	}

	private AddColNameType(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

}
