/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic.intf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.ArrayUtils;

import com.alibaba.fastjson.JSONArray;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEnum;

/***
 * 枚举类需要下拉列表必须要实现的接口
 * 
 * @author andy.zhou
 *
 */
public interface IEnumCombobox {
	/****
	 * 得到枚举对象的name值
	 * 
	 * @return 枚举对象的name值
	 */
	public String getName();

	/****
	 * 得到枚举对象的解释，如果没有任何的local或 不支持的local，时会调此方法解释
	 * 
	 * @return 解释值
	 */
	public String getDesc();

	/****
	 * 得到英文的解释值
	 * 
	 * @return 解释值
	 */
	public String getDesc_en();

	/****
	 * 得到中文的解释值
	 * 
	 * @return 解释值
	 */
	public String getDesc_zh();

	/***
	 * 枚举值的组，所属的组，允许的过滤组，如果开启过滤有用
	 * 
	 * @return
	 */
	public default String[] getGroups() {
		return new String[] { "all" };
	}

	/***
	 * 得到真正的名称，有些字符不能做为name（如含有中划线等），需要定义一个使用的name，参考：MiddlewareOption
	 * 
	 * @return
	 */
	public default String getNameUse() {
		return getName();
	}

	/***
	 * 得到子组，用于Propertygrid等使用
	 * 
	 * @return
	 */
	public default String getGroupSub() {
		return "default";
	}

	/***
	 * 通过组（逗号分隔）拿到对应的枚举
	 * 
	 * @param <T>
	 * @param groups
	 * @param calssz
	 * @return
	 */
	public static <T extends IEnumCombobox> List<T> getByGroups(String groups, Class<T> calssz) {
		List<T> retset = new ArrayList<T>();
		T[] enumConstants = calssz.getEnumConstants();
		String[] groupAry = StringUtil.isNull(groups) ? new String[0] : groups.split(",");
		for (T t : enumConstants) {
			boolean isSel = false;
			if (ArrayUtils.isNotEmpty(groupAry)) {
				for (String group : groupAry) {
					if (ArrayUtils.contains(t.getGroups(), group)) {
						isSel = true;
						break;
						// retset.add(t);
					}
				}
			} else {
				isSel = true;
			}
			if (isSel) {
				retset.add(t);
			}
		}
		return retset;
	}

	/***
	 * 得到下拉列表的json
	 * 
	 * @param <T>
	 * @param groups
	 * @param calssz
	 * @return
	 */
	public static <T extends IEnumCombobox> JSONArray getListJson(String groups, Class<T> calssz, String lan) {
		List<T> byGroups = getByGroups(groups, calssz);
		List<Map<String, String>> templist = new ArrayList<Map<String, String>>();
		ConvertValueEnum conver = new ConvertValueEnum(byGroups.toArray(new IEnumCombobox[byGroups.size()]), lan);
		for (T t : byGroups) {
			Map<String, String> tempmap = new HashMap<String, String>();
			tempmap.put("text", conver.getStr(t.getName()));
			tempmap.put("value", t.getName());
			templist.add(tempmap);
		}
		String text = JSONUtil.getJsonForListAlias(templist);
		return JSONArray.parseArray(text);
	}

}
