/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 是与否枚举
 * 
 * @author andy.zhou
 * 
 */
public enum YesOrNo implements IEnumCombobox {
	yes("是"), no("否");

	private final String desc;

	private YesOrNo(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static YesOrNo find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (YesOrNo ele : YesOrNo.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
