/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 时间单位，见类：java.util.Calendar
 * 
 * @author andy.zhou
 * 
 */
public enum TimeUnit implements IEnumCombobox {

	MINUTE("分钟", 12, new String[] { "flinkcep" }),

	SECOND("秒", 13, new String[] { "flinkcep" }),

	MILLISECOND("毫秒", 14, new String[] {}), // flink cep没有

	HOUR("小时", 10, new String[] { "flinkcep" }),

	DAY("天", 5, new String[] { "flinkcep" }), // DATE

	MONTH("月", 2, new String[] { "flinkcep" }),

	YEAR("年", 1, new String[] { "flinkcep" });

	private final String desc;

	private final int value;

	private final String[] groups;

	private TimeUnit(String desc, int value, String[] groups) {
		this.desc = desc;
		this.value = value;
		this.groups = groups;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	public int getValue() {
		return value;
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static TimeUnit find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (TimeUnit ele : TimeUnit.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	public String[] getGroups() {
		return groups;
	}

}
