/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant.dic;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 是与否枚举
 * 
 * @author andy.zhou
 * 
 */
public enum OrderBy implements IEnumCombobox {
	asc("升序"), desc("降序");

	private final String remark;

	private OrderBy(String remark) {
		this.remark = remark;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.remark;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static OrderBy find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (OrderBy ele : OrderBy.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	@Override
	public String getDesc() {
		return this.remark;
	}
}
