/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 页面元素的选项配置
 * 
 * @author andy.zhou
 * 
 */
public enum PageElementOpt implements IEnumCombobox {
	enumclass("枚举类型下拉框的枚举类", IEnumCombobox.class, null, new IConvertValue<Class<? extends IEnumCombobox>>() {

		@Override
		public String getStr(Class<? extends IEnumCombobox> keyObj) {
			return keyObj.getName();
		}
	}),

	groups("分组（如枚举类分多个组过滤）", String.class, null, new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	strpattern("validatebox用的字符检查", StrPattern.class, null, new IConvertValue<StrPattern>() {

		@Override
		public String getStr(StrPattern keyObj) {
			return keyObj.name();
		}
	}),

	url("地址", String.class, null, new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}), // 如combobox需要地址

	multiple("是否多选", Boolean.class, "false", new IConvertValue<Boolean>() {

		@Override
		public String getStr(Boolean keyObj) {
			return String.valueOf(keyObj);
		}
	}),

	min("最小值", String.class, String.valueOf(Integer.MIN_VALUE), new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	max("最大值", String.class, String.valueOf(Integer.MAX_VALUE), new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	missingmsg("较验错误消息", String.class, "该输入项为必输项，请注意输入要求", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}), // 失败的提示消息

	precision("精度", Integer.class, "-1", new IConvertValue<Integer>() {

		@Override
		public String getStr(Integer keyObj) {
			return String.valueOf(keyObj);
		}
	}),

	showGroup("是否显示分组信息", String.class, "-1", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),
	// 一般控制不需要用，只有Propertygrid类似控件需要
	height("控制高度", Integer.class, "250", new IConvertValue<Integer>() {

		@Override
		public String getStr(Integer keyObj) {
			return String.valueOf(keyObj);
		}
	}),

	toolbar("工具栏按钮", String.class, "250", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return String.valueOf(keyObj);
		}
	}),

	groupsplit("分隔符，3位一段", String.class, ",", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	columns("列名", String.class, "", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	idField("id字段", String.class, "id", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	panelWidth("打开面板宽度", Integer.class, "400", new IConvertValue<Integer>() {

		@Override
		public String getStr(Integer keyObj) {
			return String.valueOf(keyObj);
		}
	}),

	panelHeight("打开面板高度", Integer.class, "300", new IConvertValue<Integer>() {

		@Override
		public String getStr(Integer keyObj) {
			return String.valueOf(keyObj);
		}
	}),

//	textfield("text字段", String.class, "name", new IConvertValue<String>() {
//
//		@Override
//		public String getStr(String keyObj) {
//			return keyObj;
//		}
//	}),

	// combobox使用，默认为id
	valueField("value字段", String.class, "id", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),
	// combobox/ComboGrid使用，默认为name
	textField("text字段", String.class, "name", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	// Calendar使用
	dateFmt("日期格式", String.class, "yyyy-MM-dd", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),
	// 级连用的
	parent("级联的父字段", String.class, "", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	// 级连用的
	parentLibs("级联依赖的域id", String.class, "", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	tableToColumnsUrl("sql组件拿到提示表和字段", String.class, "", new IConvertValue<String>() {
		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	// changeHandle事件
	changeHandle("change事件", String.class, "", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	// 只能设置为"remote"和“local”,local为默认值
	mode("加载列表数据模式", String.class, "local", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	// 是否需要转换器，对于comboBox和comboGrid可以忽略
	convertIgnore("忽略转换器", String.class, "no", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	;

	private final String desc;

	private final Class<?> classz;// java对象类型

	private final String defaultValue;// 默认值

	@SuppressWarnings("rawtypes")
	private final IConvertValue convertValue;

	@SuppressWarnings("rawtypes")
	public IConvertValue getConvertValue() {
		return convertValue;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public Class<?> getClassz() {
		return classz;
	}

	private <T> PageElementOpt(String desc, Class<T> classz, String defaultValue, IConvertValue<T> convertValue) {
		this.desc = desc;
		this.classz = classz;
		this.defaultValue = defaultValue;
		this.convertValue = convertValue;
	}

//IEnumCombobox专用
	private PageElementOpt(String desc, Class<IEnumCombobox> classz, Object defaultValue,
			IConvertValue<Class<? extends IEnumCombobox>> convertValue) {
		this.desc = desc;
		this.classz = classz;
		this.defaultValue = String.valueOf(defaultValue);
		this.convertValue = convertValue;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

}
