/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.lang3.StringUtils;
import net.wicp.tams.common.constant.ods.AddColName;

import java.util.HashMap;
import java.util.Map;

/***
 * 中间件类型
 * 
 * @author andy.zhou
 * 
 */
public enum MiddlewareOption implements IEnumCombobox {
	connector("连接类型", "connector"),

	index("es的索引", "index"),

	url("连接地址", "url"),

	tableName("表名", "table-name"),

	topic("主题", "topic"),

	format("内容格式", "format", "duckula"),

	rowKindColName("rowKind取自哪个字段，空值或null为此模式不生效", "rowKindColName", AddColName.lastOpttype.getColNameTrue()),

	offset("启动模式", "offset", "earliest"), // tamskafka专用的option,它与kafka的模式保持一致。

	kafka_groupid("消费者", "properties.group.id"),

	keyformat("主键格式", "key.format", "json"),

	valueformat("value格式", "value.format", "duckulavalue"),

	valuefieldsinclude("控制哪些字段应该出现在value中", "value.fields-include", "ALL"),

//	kafka_autocommit("是否自动commit", "properties.enable.auto.commit"),

	// kafka_autocommit("是否自动提交", "properties.enable.auto.commit"),

	// kafka_session("session超时", "properties.session.timeout.ms"),

	// kafka_request("request超时", "properties.request.timeout.ms"),

	kafka_scan_mode("启动模式", "scan.startup.mode", "group-offsets"), // earliest-offset latest-offset',
																	// 'group-offsets，'timestamp' and 'specific-offsets'

	kafka_servers("kafkaservice", "properties.bootstrap.servers"),

	kafka_sink_partitioner("kafka自定义分区", "sink.partitioner",
			"net.wicp.tams.common.flink.connector.kafka.partitioner.KafkaTamsPartitioner"), // 自定义分分区，内置分区有fixed:每个Flink分区最多分配到一个Kafka分区中。round-robin:
																							// Flink分区轮询被分配到Kafka分区中

	// 下面用于duckula的binlog cdc配置 。
	db("监听/默认 库名", "db"), // duckula的监听库、 redis的默认库

	tb("监听表名", "tb"),

	cdc("是否CDC", "cdc"),

	path("路径", "path"), // 'connector'='filesystem'支持

	// clientId("监听clientid", "clientId"),

	// haType("ha类型", "haType"),

	host("主机", "host"),

	username("用户名", "username"),

	password("密码", "password"),

	port("端口", "port"),

	dorisbatchsize("单批写入数据量", "doris.batch.size"),

	dorisSinkEnable2pc("doris单批写入数据量", "sink.enable-2pc"),

	dorisSinkLabelPrefix("写入标签", "sink.label-prefix"),

	dorisFormat("doris写格式", "sink.properties.format"),

	dorisReadJsonByLine("json格式配合", "sink.properties.read_json_by_line"),

	// dorisbatchinterval("doris写入间隔","sink.batch.interval"),

	controlkey("组的key，用于存放此表中的所有id,相关于表的索引", "controlkey"),

	groupid("监听组,redis需要", "groupid"),

	searchkeyprefix("key的前缀《层级：上游库：上游表》", "searchkeyprefix"),

	tenantColName("tenant的列名", "tenantColName"),

	updateColName("用于分隔全量和增量的分界字段", "updateColName"),

	lookupCacheTtl("lookup的ttl时间", "lookup.cache.ttl", "60000"),

	lookupCacheMaxRows("lookup最大行数", "lookup.cache.max-rows", "100"),

	routeColName("分库分表时的路由字段名", "routeColName"), // 如redis需要tenant来组装key

	append("是否为append模式", "append"),

	// rds("端口", "rds"),

	fieldFormart("所有字段的格式", "fieldFormart"),

	addColNameType("新增字段的模式", "addColNameType"),

	// end 下面用于duckula的binlog cdc配置 。
	// doris相关
	fenodes("Doris FE http 地址", "fenodes"),

	table_identifier("Doris 表名，如：db1.tbl1", "table.identifier"),

	pushgateway("pushgateway 地址", "pushgateway"),

	job("提交的job名称", "job"),

	name("指标名", "name"),

	help("指标说明", "help"),

	type("指标类型", "type"),

	labels("标签", "labels"),

	;

	private final String desc;
	private final String nameUse;
	private final String defaultValue;// 默认值

	private MiddlewareOption(String desc, String nameUse) {
		this.desc = desc;
		this.nameUse = nameUse;
		this.defaultValue = null;
	}

	private MiddlewareOption(String desc, String nameUse, String defaultValue) {
		this.desc = desc;
		this.nameUse = nameUse;
		this.defaultValue = defaultValue;
	}

	@Override
	public String getDesc() {
		return desc;
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	@Override
	public String getNameUse() {
		return nameUse;
	}

	public static MiddlewareOption findByNameUse(String nameUse) {
		if (StringUtils.isEmpty(nameUse)) {
			return null;
		}
		for (MiddlewareOption ele : MiddlewareOption.values()) {
			if (nameUse.equalsIgnoreCase(ele.nameUse)) {
				return ele;
			}
		}
		return null;
	}

	public static Map<MiddlewareOption, String> parseByArray(JSONArray rows) {
		Map<MiddlewareOption, String> ret = new HashMap<MiddlewareOption, String>();
		for (Object object : rows) {
			JSONObject temp = (JSONObject) object;
			ret.put(MiddlewareOption.valueOf(temp.getString("name")), temp.getString("value"));// nameUse
		}
		return ret;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

}
