/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

public enum KafkaReset implements IEnumCombobox {
	earliest("从最早消费"),//当各分区下有已提交的offset时，从提交的offset开始消费；无提交的offset时，从头开始消费

	latest("从最后消费"),//当各分区下有已提交的offset时，从提交的offset开始消费；无提交的offset时，消费新产生的该分区下的数据

	none("指定offset消费");//topic各分区都存在已提交的offset时，从offset后开始消费；只要有一个分区不存在已提交的offset，则抛出异常

	private final String desc;

	private KafkaReset(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static KafkaReset find(String name) {
		if (StringUtils.isEmpty(name)) {
			return KafkaReset.earliest;
		}
		for (KafkaReset ele : KafkaReset.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return KafkaReset.earliest;
	}
}
