/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import java.io.Serializable;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 相关字符的类型
 * 
 * @author andy.zhou
 * 
 */
public enum FieldFormart implements IEnumCombobox,Serializable{
	ori("原始值", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj;
		}
	}),

	hump("驼峰", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return StringUtil.convertStr(keyObj);
		}
	}),

	dbstandard("数据库标准（下划线分隔）", new IConvertValue<String>() {

		@Override
		public String getStr(String keyObj) {
			return keyObj.toLowerCase().replace("-", "_");
		}
	});

	private final String desc;

	private final IConvertValue<String> colNameConvertFun;

	private FieldFormart(String desc, IConvertValue<String> colNameConvertFun) {
		this.desc = desc;
		this.colNameConvertFun = colNameConvertFun;
	}

	public String getColName(String colName) {
		return this.colNameConvertFun.getStr(colName);
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

}
