/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * http://lopica.sourceforge.net/os.html
 * 
 * @author andy.zhou
 *
 */
public enum EPlatform implements IEnumCombobox{
	Any("any", null),

	Linux("Linux", ".sh"),

	Mac_OS("Mac OS", ".sh"),

	Mac_OS_X("Mac OS X", ".sh"),

	Windows("Windows", ".bat"),

	OS2("OS/2", null),

	Solaris("Solaris", null),

	SunOS("SunOS", null),

	MPEiX("MPE/iX", null),

	HP_UX("HP-UX", null),

	AIX("AIX", null),

	OS390("OS/390", null),

	FreeBSD("FreeBSD", null),

	Irix("Irix", null),

	Digital_Unix("Digital Unix", null),

	NetWare_411("NetWare", null),

	OSF1("OSF1", null),

	OpenVMS("OpenVMS", null),

	Others("Others", null);

	private EPlatform(String desc, String batchSuffix) {
		this.desc = desc;
		this.batchSuffix = batchSuffix;
	}

	private final String desc;

	private final String batchSuffix;

	public String getBatchSuffix() {
		return batchSuffix;
	}

	public String getDescription() {
		return this.desc;
	}

	public String getDesc() {
		return this.desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}
}
