/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/****
 * 数仓分层
 * 
 * @author Andy.zhou
 *
 */
public enum DwLevel implements IEnumCombobox {
	// 贴源数据区，保存最新数据，数据结构与源系统一致，用于支持数据实时探察&分析，实时监控类数据应用，用以减轻业务系统压力
	ODS("结果表", YesOrNo.yes), // 申请开放，终极目标是不开放

	// 用于向数据仓库DWD加载数据临时表，根据表数据量，数据的记录变化频率，可以每天增量或者每天全量从ODS抽取，一般建议保留30天的数据，超过可以转移到归档文档区。
	STG("过程表", YesOrNo.no),

	// 数据仓库明细数据表，为未来分析类需求的扩展提供历史数据支撑，一般设计为全量快照表或者拉链表，部分场景可以设计为只保留最新数据事实表。可以在数据域内进行多表以及公共维表的关联，清洗操作，不会改变事实粒度，可以做指标级的分摊等逻辑计算，比如纬度转换，空值处理，脏数据处理，字段合并等，不建议跨数据域关联。
	DWD("明细层", YesOrNo.yes), // 申请开放

	// 汇总数据表，根据DWD各个维度的数据进行汇总，一般不做跨数据域的汇总关联，保持各数据域的解藕
	DWS("汇总数据", YesOrNo.yes), // 申请开放

	// 数据集市宽表层，根据分析主体进行各数据域整合的宽表，主要用于支持数据分析，数据挖掘和部分数据应用场景，具有公共性。
	DMT("数据集市宽表层", YesOrNo.yes), // 申请开放

	// 数据集市应用层，面对特定应用所做的加工表，不具有公用性，比如指数，排名指标等，横转纵处理，适配特定的报表工具所做的应用表（比如帆软，有数，kylin等）。备注：一般设置单独的高配物理集群，由中央数仓集市层向单独的DMA同步。
	DMA("数据集市应用层", YesOrNo.no),

	// 公司纬度表
	DIM("纬度表", YesOrNo.yes),

	// 数据处理过程，用于支持中间表&结果表生成，不保留数据，随任务结束而结束
	DWTMP("临时表", YesOrNo.no);

	private final String desc;

	private final YesOrNo open;// 是否开放，yes：开放 no：不开放 null:申请开放

	public YesOrNo getOpen() {
		return open;
	}

	private DwLevel(String desc, YesOrNo open) {
		this.desc = desc;
		this.open = open;
	}

	public String getDesc() {
		return desc;
	}

	public static DwLevel getByName(String env, DwLevel defaultEnv) {
		if (StringUtil.isNull(env)) {// 默认是任意匹配
			return defaultEnv;
		}
		for (DwLevel ele : DwLevel.values()) {
			if (env.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return defaultEnv;
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

}
