/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.beans.JdbcBean;
import org.apache.commons.lang3.ArrayUtils;

import java.sql.Connection;
import java.util.List;

public enum DbType {
	// zeroDateTimeBehavior=convertToNull&amp;useUnicode=true&amp;autoReconnect=true&amp;failOverReadOnly=false&amp;characterEncoding=utf8&amp;verifyServerCertificate=false&amp;useSSL=false
	// allowPublicKeyRetrieval: 解决：MySQL 8.0 Public Key Retrieval is not allowed
	mysql("com.mysql.jdbc.Driver", 3306, "jdbc:mysql://%s:%s", "%s/%s",
			"zeroDateTimeBehavior=convertToNull&useUnicode=true&characterEncoding=utf8&autoReconnect=true&failOverReadOnly=false&verifyServerCertificate=false&useSSL=false&allowPublicKeyRetrieval=true",
			"PRIMARY KEY (`%s`) USING BTREE",
			"^jdbc:mysql://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$"),

	doris("com.mysql.jdbc.Driver", 3306, "jdbc:mysql://%s:%s", "%s/%s",
			"zeroDateTimeBehavior=convertToNull&useUnicode=true&characterEncoding=utf8&autoReconnect=true&failOverReadOnly=false&verifyServerCertificate=false&useSSL=false&allowPublicKeyRetrieval=true",
			"", "^jdbc:mysql://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$"),

	// impala地址
	impala("com.cloudera.impala.jdbc41.Driver", 21050, "jdbc:impala://%s:%s", "%s/%s", "", "PRIMARY KEY (`%s`)",
			"^jdbc:impala://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$"),

	// com.microsoft.sqlserver.jdbc.SQLServerDriver无法识别元数据的表 MERGE INTO
	// demo.dbo.user_info
//	sqlserver("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://%s:%s", "%s;DatabaseName=%s", "",
//			"PRIMARY KEY (%s)");
	sqlserver("net.sourceforge.jtds.jdbc.Driver", 1433, "jdbc:jtds:sqlserver://%s:%s", "%s;DatabaseName=%s", "",
			"PRIMARY KEY (%s)",
			"^jdbc:jtds:sqlserver://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$");

	private final String formatestr;

	private final String formatedbstr;
	// 默认参数
	private final String defaultparam;

	private final String createTableKeystr;

	private final String jdbcDriver;

	private final int defaultPort;

	private final String urlPattern;

	public int getDefaultPort() {
		return defaultPort;
	}

	public JdbcBean getJdbcBeanByUrl(String url) {
		String[] group = StrPattern.group(this.urlPattern, url);
		if (ArrayUtils.isEmpty(group) || group.length < 3) {
			return null;
		}
		JdbcBean retbean = new JdbcBean();
		retbean.setUrl(url);
		retbean.setHost(group[1]);
		retbean.setPort(Integer.parseInt(group[2]));
		switch (group.length) {
		case 5:
			retbean.setUrlparam(group[4]);
			break;
		case 7:
			retbean.setDefaultdb(group[4]);
			retbean.setUrlparam(group[6]);
			break;
		default:
			break;
		}
		return retbean;
	}

	public boolean testConn(Connection conn) {
		if (conn == null) {
			return false;
		}
		Result rs = null;
		switch (this) {
		case mysql:
			rs = JdbcAssit.execSql(conn, "SELECT now()");
			break;
		case sqlserver:
			rs = JdbcAssit.execSql(conn, "select  getdate()");
			break;
		case doris:
			rs = JdbcAssit.execSql(conn, "SELECT now()");
			break;
		default:
			break;
		}
		if (rs != null && rs.isSuc()) {
			return true;
		} else {
			return false;
		}
	}

	public boolean testConn(String host, int port, String userName, String pwd) {
		Connection connection = null;
		try {
			connection = JdbcConnection.getConnectionMyql(this.getTestUrl(host, port, null), userName, pwd);
			boolean testConn = this.testConn(connection);
			return testConn;
		} finally {
			try {
				connection.close();
			} catch (Exception e) {
			}
		}
	}

	public String getCreateKeySql(List<String> keys) {
		if (StringUtil.isNull(createTableKeystr)) {
			return "";
		}
		String listJoinstr = CollectionUtil.listJoin(keys, "`,`");
		return String.format(createTableKeystr, listJoinstr);
	}

	public String getDefaultparam() {
		return defaultparam;
	}

	public String getFormatedbstr() {
		return formatedbstr;
	}

	public String getFormatestr() {
		return formatestr;
	}

	/****
	 * 得到测试用的连接地址
	 * 
	 * @param host
	 * @param port
	 * @param defaultdb
	 * @return
	 */
	public String getTestUrl(String host, int port, String defaultdb) {
		String returl = null;
		switch (this) {
		case mysql:
		case doris:
			returl = geturl(host, port, defaultdb,
					"useUnicode=true&characterEncoding=UTF8&connectTimeout=5000&socketTimeout=5000&useSSL=false");
			break;

		default:
			returl = geturl(host, port, defaultdb);
			break;
		}
		return returl;
	}

	public String geturl(String sshLocalhostprot, String host, int port, String defaultdb, String urlparam) {
		String temp = this.getFormatestr(); // "jdbc:mysql://%s:%s";
		String url;
		if (StringUtil.isNotNull(sshLocalhostprot)) {// 代理SSH
			SshAssist.ssh(Integer.parseInt(sshLocalhostprot), host, port);
			url = String.format(temp, "localhost", sshLocalhostprot);
		} else {
			url = String.format(temp, host, port);
		}
		if (StringUtil.isNotNull(defaultdb)) {
			// url += "/" + get(props, "defaultdb");
			url = String.format(this.getFormatedbstr(), url, defaultdb);
		}
		// urlparam的默认值不能放配置文件，编译出错
		if (StringUtil.isNotNull(urlparam)) {
			url += "?" + urlparam;
		} else {
			url += StringUtil.isNull(this.getDefaultparam()) ? "" : "?" + StringUtil.hasNull(this.getDefaultparam());
		}
		return url;
	}

	// jdbc:mysql://docker.for.win.localhost:3306/duckula?serverTimezone=UTC&useUnicode=true&characterEncoding=utf8&useSSL=false&allowPublicKeyRetrieval=true

	public String geturl(String host, int port) {
		return this.geturl(null, host, port, null, null);
	}

	public String geturl(String host) {
		return this.geturl(host, this.defaultPort);
	}

	public String geturl(String host, int port, String defaultdb) {
		return this.geturl(null, host, port, defaultdb, null);
	}

	public String geturl(String host, int port, String defaultdb, String urlparam) {
		return this.geturl(null, host, port, defaultdb, urlparam);
	}

	private DbType(String jdbcDriver, int defaultPort, String formatestr, String formatedbstr, String defaultparam,
			String createTableKeystr, String urlPattern) {
		this.formatestr = formatestr;
		this.formatedbstr = formatedbstr;
		this.defaultparam = defaultparam;
		this.createTableKeystr = createTableKeystr;
		this.jdbcDriver = jdbcDriver;
		this.defaultPort = defaultPort;
		this.urlPattern = urlPattern;
	}

	public String getJdbcDriver() {
		return jdbcDriver;
	}

}
