/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.commons.lang3.ArrayUtils;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectException;

/**
 * 2021-08-23 13:47:24.0653399 +0800 CST怎么处理，htlm list
 * @author 偏锋书生
 *
 */
public enum DateFormatCase implements IEnumCombobox{

	YYYY_MM_DD("yyyy-MM-dd", StrPattern.date),

	YYYY_MM_DD_hhmmss("yyyy-MM-dd HH:mm:ss", StrPattern.date_time),

	YYYY_MM_DD_hhmmssSSS("yyyy-MM-dd HH:mm:ss.SSS", StrPattern.date_time_SSS),//支持动态的精度

	YYYYMMDD("yyyyMMdd", StrPattern.date2),

	yyyyMMddHHmmss("yyyyMMddHHmmss", StrPattern.date_time2),

	yyyyMMddHHmmssSSS("yyyyMMddHHmmssSSS", StrPattern.date_time_SSS2),//支持动态的精度

	TyyyyMMddHHmmss("yyyy-MM-dd'T'HH:mm:ssz", StrPattern.date_time_t3),

	TZyyyyMMddHHmmss("yyyy-MM-dd'T'HH:mm:ss'Z'", StrPattern.date_time_t2),

	TyyyyMMddHHmmssNoZ("yyyy-MM-dd'T'HH:mm:ss", StrPattern.date_time_t1),
	
	TyyyyMMddHHmmssNoZSSS("yyyy-MM-dd'T'HH:mm:ss.SSS", StrPattern.date_time_t12),
	
	TyyyyMMddHHmmNoZ("yyyy-MM-dd'T'HH:mm", StrPattern.date_time_t13);//2022-10-27T16:01

	private final String pattern;

	public String getPattern() {
		return pattern;
	}

	private final StrPattern valuePattern;

	// 这是epoch，unix时间戳零点是utc 1970年1月1日0点整，北京是gmt 8所以变成八点。
	// 简单来说就是数据库出BuG，储存的时间是零，相当于1970年1月1日八点
	private static String[] excludes = new String[] { "0001-01-01 00:00:00","0000-00-00 00:00:00", "00010101000000", "1970-01-01 00:00:00",
			"19700101000000", "1970-01-01 08:00:00", "19700101080000" };

	public StrPattern getValuePattern() {
		return valuePattern;
	}

	private DateFormatCase(String pattern, StrPattern valuePattern) {
		this.pattern = pattern;
		this.valuePattern = valuePattern;
	}

	public SimpleDateFormat getInstanc() {
		SimpleDateFormat instanc = new SimpleDateFormat(pattern);
		return instanc;
	}

	public boolean validDateStr(String datestr) {
		if (this.valuePattern == null) {
			return false;
		}
		return this.valuePattern.checkStrFormat(datestr);
	}

	public static DateFormatCase validDateFormat(String datestr) {
		for (DateFormatCase dateFormatCase : DateFormatCase.values()) {
			if (dateFormatCase.validDateStr(datestr)) {
				return dateFormatCase;
			}
		}
		return null;
	}

	// 通过模式查找DateFormatCase，默认为YYYY_MM_DD
	public static DateFormatCase find(String dateformatstr) {
		if (StringUtil.isNull(dateformatstr)) {
			return YYYY_MM_DD;
		}
		for (DateFormatCase dateFormatCase : DateFormatCase.values()) {
			if (dateFormatCase.getPattern().equalsIgnoreCase(dateformatstr)) {
				return dateFormatCase;
			}
		}
		return YYYY_MM_DD;
	}

	
	public static Date toDate(String datestr) throws ProjectException {
		if (ArrayUtils.contains(excludes, datestr)) {
			//兼容，把它设置为0分时间，即1970-01-01 08:00:00
			return new Date(0);
			//throw new ProjectException(ExceptAll.project_datenofitformate, "时间为0，请检查程序是否有问题");
		}
		DateFormatCase validDateFormat = validDateFormat(datestr);
		if (validDateFormat == null) {
			throw new ProjectException(ExceptAll.project_nosupport, "不支持的数据类型");
		}
		Date retobj;
		switch (validDateFormat) {
		case YYYY_MM_DD_hhmmssSSS:			
			try {
				String[] group = validDateFormat.getValuePattern().group(datestr);
				datestr=group[24].length()<=3?datestr:datestr.substring(0, 23);
				retobj= validDateFormat.getInstanc().parse(datestr);
				//由于超过3会，会把后面的数字折合成秒和分钟往前加导致时间对不上
				//String proStr = StringUtil.proStr("S", group[24].length());
				//retobj= new SimpleDateFormat("yyyy-MM-dd HH:mm:ss."+proStr).parse(datestr);
			} catch (ParseException e) {
				throw new ProjectException(ExceptAll.project_formatnofit, e);
			}
			break;
		case yyyyMMddHHmmssSSS:			
			try {
				String[] group = validDateFormat.getValuePattern().group(datestr);
				datestr=group[18].length()<=3?datestr:datestr.substring(0, 17);
				retobj= validDateFormat.getInstanc().parse(datestr);
				//String proStr = StringUtil.proStr("S", group[18].length());
				//retobj= new SimpleDateFormat("yyyyMMddHHmmss"+proStr).parse(datestr);
			} catch (ParseException e) {
				throw new ProjectException(ExceptAll.project_formatnofit, e);
			}
			break;	
		case TyyyyMMddHHmmssNoZSSS:			
			try {
				String[] group = validDateFormat.getValuePattern().group(datestr);
				String proStr = StringUtil.proStr("S", group[24].length());
				retobj= new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss."+proStr).parse(datestr);
			} catch (ParseException e) {
				throw new ProjectException(ExceptAll.project_formatnofit, e);
			}
			break;	
			
			
		default:
			try {
				retobj = validDateFormat.getInstanc().parse(datestr);
			} catch (ParseException e) {
				throw new ProjectException(ExceptAll.project_formatnofit, e);
			}
			break;
		}
		
		return retobj;
		
	}

	@Override
	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc() {
		return this.pattern;
	}

	@Override
	public String getDesc_en() {
		return this.pattern;
	}

	@Override
	public String getDesc_zh() {
		return this.pattern;
	}

}
