/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.constant;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 后缀
 * 
 * @author andy.zhou
 * 
 */
public enum ContentType implements IEnumCombobox {
	  load("",".load","text/html"),
	  _123("",".123","application/vnd.lotus-1-2-3"),
	  _3ds("",".3ds","image/x-3ds"),
	  _3g2("",".3g2","video/3gpp"),
	  _3ga("",".3ga","video/3gpp"),
	  _3gp("",".3gp","video/3gpp"),
	  _3gpp("",".3gpp","video/3gpp"),
	  _602("",".602","application/x-t602"),
	  _669("",".669","audio/x-mod"),
	  _7z("",".7z","application/x-7z-compressed"),
	  a("",".a","application/x-archive"),
	  aac("",".aac","audio/mp4"),
	  abw("",".abw","application/x-abiword"),
	  abw_crashed("",".abw.crashed","application/x-abiword"),
	  abw_gz("",".abw.gz","application/x-abiword"),
	  ac3("",".ac3","audio/ac3"),
	  ace("",".ace","application/x-ace"),
	  adb("",".adb","text/x-adasrc"),
	  ads("",".ads","text/x-adasrc"),
	  afm("",".afm","application/x-font-afm"),
	  ag("",".ag","image/x-applix-graphics"),
	  ai("",".ai","application/illustrator"),
	  aif("",".aif","audio/x-aiff"),
	  aifc("",".aifc","audio/x-aiff"),
	  aiff("",".aiff","audio/x-aiff"),
	  al("",".al","application/x-perl"),
	  alz("",".alz","application/x-alz"),
	  amr("",".amr","audio/amr"),
	  ani("",".ani","application/x-navi-animation"),
	  anim("",".anim[1-9j]","video/x-anim"),
	  anx("",".anx","application/annodex"),
	  ape("",".ape","audio/x-ape"),
	  arj("",".arj","application/x-arj"),
	  arw("",".arw","image/x-sony-arw"),
	  as("",".as","application/x-applix-spreadsheet"),
	  asc("",".asc","text/plain"),
	  asf("",".asf","video/x-ms-asf"),
	  asp("",".asp","application/x-asp"),
	  ass("",".ass","text/x-ssa"),
	  asx("",".asx","audio/x-ms-asx"),
	  atom("",".atom","application/atom+xml"),
	  au("",".au","audio/basic"),
	  avi("",".avi","video/x-msvideo"),
	  aw("",".aw","application/x-applix-word"),
	  awb("",".awb","audio/amr-wb"),
	  awk("",".awk","application/x-awk"),
	  axa("",".axa","audio/annodex"),
	  axv("",".axv","video/annodex"),
	  bak("",".bak","application/x-trash"),
	  bcpio("",".bcpio","application/x-bcpio"),
	  bdf("",".bdf","application/x-font-bdf"),
	  bib("",".bib","text/x-bibtex"),
	  bin("",".bin","application/octet-stream"),
	  blend("",".blend","application/x-blender"),
	  blender("",".blender","application/x-blender"),
	  bmp("",".bmp","image/bmp"),
	  bz("",".bz","application/x-bzip"),
	  bz2("",".bz2","application/x-bzip"),
	  c("",".c","text/x-csrc"),
	  cplusplus("",".c++","text/x-c++src"),
	  cab("",".cab","application/vnd.ms-cab-compressed"),
	  cb7("",".cb7","application/x-cb7"),
	  cbr("",".cbr","application/x-cbr"),
	  cbt("",".cbt","application/x-cbt"),
	  cbz("",".cbz","application/x-cbz"),
	  cc("",".cc","text/x-c++src"),
	  cdf("",".cdf","application/x-netcdf"),
	  cdr("",".cdr","application/vnd.corel-draw"),
	  cer("",".cer","application/x-x509-ca-cert"),
	  cert("",".cert","application/x-x509-ca-cert"),
	  cgm("",".cgm","image/cgm"),
	  chm("",".chm","application/x-chm"),
	  chrt("",".chrt","application/x-kchart"),
	  _class("",".class","application/x-java"),
	  cls("",".cls","text/x-tex"),
	  cmake("",".cmake","text/x-cmake"),
	  cpio("",".cpio","application/x-cpio"),
	  cpio_gz("",".cpio.gz","application/x-cpio-compressed"),
	  cpp("",".cpp","text/x-c++src"),
	  cr2("",".cr2","image/x-canon-cr2"),
	  crt("",".crt","application/x-x509-ca-cert"),
	  crw("",".crw","image/x-canon-crw"),
	  cs("",".cs","text/x-csharp"),
	  csh("",".csh","application/x-csh"),
	  css("",".css","text/css"),
	  cssl("",".cssl","text/css"),
	  csv("",".csv","text/csv"),
	  cue("",".cue","application/x-cue"),
	  cur("",".cur","image/x-win-bitmap"),
	  cxx("",".cxx","text/x-c++src"),
	  d("",".d","text/x-dsrc"),
	  dar("",".dar","application/x-dar"),
	  dbf("",".dbf","application/x-dbf"),
	  dc("",".dc","application/x-dc-rom"),
	  dcl("",".dcl","text/x-dcl"),
	  dcm("",".dcm","application/dicom"),
	  dcr("",".dcr","image/x-kodak-dcr"),
	  dds("",".dds","image/x-dds"),
	  deb("",".deb","application/x-deb"),
	  der("",".der","application/x-x509-ca-cert"),
	  desktop("",".desktop","application/x-desktop"),
	  dia("",".dia","application/x-dia-diagram"),
	  diff("",".diff","text/x-patch"),
	  divx("",".divx","video/x-msvideo"),
	  djv("",".djv","image/vnd.djvu"),
	  djvu("",".djvu","image/vnd.djvu"),
	  dng("",".dng","image/x-adobe-dng"),
	  doc("",".doc","application/msword"),
	  docbook("",".docbook","application/docbook+xml"),
	  docm("",".docm","application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
	  docx("",".docx","application/vnd.openxmlformats-officedocument.wordprocessingml.document"),
	  dot("",".dot","text/vnd.graphviz"),
	  dsl("",".dsl","text/x-dsl"),
	  dtd("",".dtd","application/xml-dtd"),
	  dtx("",".dtx","text/x-tex"),
	  dv("",".dv","video/dv"),
	  dvi("",".dvi","application/x-dvi"),
	  dvi_bz2("",".dvi.bz2","application/x-bzdvi"),
	  dvi_gz("",".dvi.gz","application/x-gzdvi"),
	  dwg("",".dwg","image/vnd.dwg"),
	  dxf("",".dxf","image/vnd.dxf"),
	  e("",".e","text/x-eiffel"),
	  egon("",".egon","application/x-egon"),
	  eif("",".eif","text/x-eiffel"),
	  el("",".el","text/x-emacs-lisp"),
	  emf("",".emf","image/x-emf"),
	  emp("",".emp","application/vnd.emusic-emusic_package"),
	  ent("",".ent","application/xml-external-parsed-entity"),
	  eps("",".eps","image/x-eps"),
	  eps_bz2("",".eps.bz2","image/x-bzeps"),
	  eps_gz("",".eps.gz","image/x-gzeps"),
	  epsf("",".epsf","image/x-eps"),
	  epsf_bz2("",".epsf.bz2","image/x-bzeps"),
	  epsf_gz("",".epsf.gz","image/x-gzeps"),
	  epsi("",".epsi","image/x-eps"),
	  epsi_bz2("",".epsi.bz2","image/x-bzeps"),
	  epsi_gz("",".epsi.gz","image/x-gzeps"),
	  epub("",".epub","application/epub+zip"),
	  erl("",".erl","text/x-erlang"),
	  es("",".es","application/ecmascript"),
	  etheme("",".etheme","application/x-e-theme"),
	  etx("",".etx","text/x-setext"),
	  exe("",".exe","application/x-ms-dos-executable"),
	  exr("",".exr","image/x-exr"),
	  ez("",".ez","application/andrew-inset"),
	  f("",".f","text/x-fortran"),
	  f90("",".f90","text/x-fortran"),
	  f95("",".f95","text/x-fortran"),
	  fb2("",".fb2","application/x-fictionbook+xml"),
	  fig("",".fig","image/x-xfig"),
	  fits("",".fits","image/fits"),
	  fl("",".fl","application/x-fluid"),
	  flac("",".flac","audio/x-flac"),
	  flc("",".flc","video/x-flic"),
	  fli("",".fli","video/x-flic"),
	  flv("",".flv","video/x-flv"),
	  flw("",".flw","application/x-kivio"),
	  fo("",".fo","text/x-xslfo"),
	  _for("",".for","text/x-fortran"),
	  g3("",".g3","image/fax-g3"),
	  gb("",".gb","application/x-gameboy-rom"),
	  gba("",".gba","application/x-gba-rom"),
	  gcrd("",".gcrd","text/directory"),
	  ged("",".ged","application/x-gedcom"),
	  gedcom("",".gedcom","application/x-gedcom"),
	  gen("",".gen","application/x-genesis-rom"),
	  gf("",".gf","application/x-tex-gf"),
	  gg("",".gg","application/x-sms-rom"),
	  gif("",".gif","image/gif"),
	  glade("",".glade","application/x-glade"),
	  gmo("",".gmo","application/x-gettext-translation"),
	  gnc("",".gnc","application/x-gnucash"),
	  gnd("",".gnd","application/gnunet-directory"),
	  gnucash("",".gnucash","application/x-gnucash"),
	  gnumeric("",".gnumeric","application/x-gnumeric"),
	  gnuplot("",".gnuplot","application/x-gnuplot"),
	  gp("",".gp","application/x-gnuplot"),
	  gpg("",".gpg","application/pgp-encrypted"),
	  gplt("",".gplt","application/x-gnuplot"),
	  gra("",".gra","application/x-graphite"),
	  gsf("",".gsf","application/x-font-type1"),
	  gsm("",".gsm","audio/x-gsm"),
	  gtar("",".gtar","application/x-tar"),
	  gv("",".gv","text/vnd.graphviz"),
	  gvp("",".gvp","text/x-google-video-pointer"),
	  gz("",".gz","application/x-gzip"),
	  h("",".h","text/x-chdr"),
	  hplusplus("",".h++","text/x-c++hdr"),
	  hdf("",".hdf","application/x-hdf"),
	  hh("",".hh","text/x-c++hdr"),
	  hp("",".hp","text/x-c++hdr"),
	  hpgl("",".hpgl","application/vnd.hp-hpgl"),
	  hpp("",".hpp","text/x-c++hdr"),
	  hs("",".hs","text/x-haskell"),
	  htm("",".htm","text/html"),
	  html("",".html","text/html"),
	  hwp("",".hwp","application/x-hwp"),
	  hwt("",".hwt","application/x-hwt"),
	  hxx("",".hxx","text/x-c++hdr"),
	  ica("",".ica","application/x-ica"),
	  icb("",".icb","image/x-tga"),
	  icns("",".icns","image/x-icns"),
	  ico("",".ico","image/vnd.microsoft.icon"),
	  ics("",".ics","text/calendar"),
	  idl("",".idl","text/x-idl"),
	  ief("",".ief","image/ief"),
	  iff("",".iff","image/x-iff"),
	  ilbm("",".ilbm","image/x-ilbm"),
	  ime("",".ime","text/x-imelody"),
	  imy("",".imy","text/x-imelody"),
	  ins("",".ins","text/x-tex"),
	  iptables("",".iptables","text/x-iptables"),
	  iso("",".iso","application/x-cd-image"),
	  iso9660("",".iso9660","application/x-cd-image"),
	  it("",".it","audio/x-it"),
	  j2k("",".j2k","image/jp2"),
	  jad("",".jad","text/vnd.sun.j2me.app-descriptor"),
	  jar("",".jar","application/x-java-archive"),
	  java("",".java","text/x-java"),
	  jng("",".jng","image/x-jng"),
	  jnlp("",".jnlp","application/x-java-jnlp-file"),
	  jp2("",".jp2","image/jp2"),
	  jpc("",".jpc","image/jp2"),
	  jpe("",".jpe","image/jpeg"),
	  jpeg("",".jpeg","image/jpeg"),
	  jpf("",".jpf","image/jp2"),
	  jpg("",".jpg","image/jpeg"),
	  jpr("",".jpr","application/x-jbuilder-project"),
	  jpx("",".jpx","image/jp2"),
	  js("",".js","application/javascript"),
	  json("",".json","application/json"),
	  jsonp("",".jsonp","application/jsonp"),
	  k25("",".k25","image/x-kodak-k25"),
	  kar("",".kar","audio/midi"),
	  karbon("",".karbon","application/x-karbon"),
	  kdc("",".kdc","image/x-kodak-kdc"),
	  kdelnk("",".kdelnk","application/x-desktop"),
	  kexi("",".kexi","application/x-kexiproject-sqlite3"),
	  kexic("",".kexic","application/x-kexi-connectiondata"),
	  kexis("",".kexis","application/x-kexiproject-shortcut"),
	  kfo("",".kfo","application/x-kformula"),
	  kil("",".kil","application/x-killustrator"),
	  kino("",".kino","application/smil"),
	  kml("",".kml","application/vnd.google-earth.kml+xml"),
	  kmz("",".kmz","application/vnd.google-earth.kmz"),
	  kon("",".kon","application/x-kontour"),
	  kpm("",".kpm","application/x-kpovmodeler"),
	  kpr("",".kpr","application/x-kpresenter"),
	  kpt("",".kpt","application/x-kpresenter"),
	  kra("",".kra","application/x-krita"),
	  ksp("",".ksp","application/x-kspread"),
	  kud("",".kud","application/x-kugar"),
	  kwd("",".kwd","application/x-kword"),
	  kwt("",".kwt","application/x-kword"),
	  la("",".la","application/x-shared-library-la"),
	  latex("",".latex","text/x-tex"),
	  ldif("",".ldif","text/x-ldif"),
	  lha("",".lha","application/x-lha"),
	  lhs("",".lhs","text/x-literate-haskell"),
	  lhz("",".lhz","application/x-lhz"),
	  log("",".log","text/x-log"),
	  ltx("",".ltx","text/x-tex"),
	  lua("",".lua","text/x-lua"),
	  lwo("",".lwo","image/x-lwo"),
	  lwob("",".lwob","image/x-lwo"),
	  lws("",".lws","image/x-lws"),
	  ly("",".ly","text/x-lilypond"),
	  lyx("",".lyx","application/x-lyx"),
	  lz("",".lz","application/x-lzip"),
	  lzh("",".lzh","application/x-lha"),
	  lzma("",".lzma","application/x-lzma"),
	  lzo("",".lzo","application/x-lzop"),
	  m("",".m","text/x-matlab"),
	  m15("",".m15","audio/x-mod"),
	  m2t("",".m2t","video/mpeg"),
	  m3u("",".m3u","audio/x-mpegurl"),
	  m3u8("",".m3u8","audio/x-mpegurl"),
	  m4("",".m4","application/x-m4"),
	  m4a("",".m4a","audio/mp4"),
	  m4b("",".m4b","audio/x-m4b"),
	  m4v("",".m4v","video/mp4"),
	  mab("",".mab","application/x-markaby"),
	  man("",".man","application/x-troff-man"),
	  mbox("",".mbox","application/mbox"),
	  md("",".md","application/x-genesis-rom"),
	  mdb("",".mdb","application/vnd.ms-access"),
	  mdi("",".mdi","image/vnd.ms-modi"),
	  me("",".me","text/x-troff-me"),
	  med("",".med","audio/x-mod"),
	  metalink("",".metalink","application/metalink+xml"),
	  mgp("",".mgp","application/x-magicpoint"),
	  mid("",".mid","audio/midi"),
	  midi("",".midi","audio/midi"),
	  mif("",".mif","application/x-mif"),
	  minipsf("",".minipsf","audio/x-minipsf"),
	  mka("",".mka","audio/x-matroska"),
	  mkv("",".mkv","video/x-matroska"),
	  ml("",".ml","text/x-ocaml"),
	  mli("",".mli","text/x-ocaml"),
	  mm("",".mm","text/x-troff-mm"),
	  mmf("",".mmf","application/x-smaf"),
	  mml("",".mml","text/mathml"),
	  mng("",".mng","video/x-mng"),
	  mo("",".mo","application/x-gettext-translation"),
	  mo3("",".mo3","audio/x-mo3"),
	  moc("",".moc","text/x-moc"),
	  mod("",".mod","audio/x-mod"),
	  mof("",".mof","text/x-mof"),
	  moov("",".moov","video/quicktime"),
	  mov("",".mov","video/quicktime"),
	  movie("",".movie","video/x-sgi-movie"),
	  mpplus("",".mp+","audio/x-musepack"),
	  mp2("",".mp2","video/mpeg"),
	  mp3("",".mp3","audio/mpeg"),
	  mp4("",".mp4","video/mp4"),
	  mpc("",".mpc","audio/x-musepack"),
	  mpe("",".mpe","video/mpeg"),
	  mpeg("",".mpeg","video/mpeg"),
	  mpg("",".mpg","video/mpeg"),
	  mpga("",".mpga","audio/mpeg"),
	  mpp("",".mpp","audio/x-musepack"),
	  mrl("",".mrl","text/x-mrml"),
	  mrml("",".mrml","text/x-mrml"),
	  mrw("",".mrw","image/x-minolta-mrw"),
	  ms("",".ms","text/x-troff-ms"),
	  msi("",".msi","application/x-msi"),
	  msod("",".msod","image/x-msod"),
	  msx("",".msx","application/x-msx-rom"),
	  mtm("",".mtm","audio/x-mod"),
	  mup("",".mup","text/x-mup"),
	  mxf("",".mxf","application/mxf"),
	  n64("",".n64","application/x-n64-rom"),
	  nb("",".nb","application/mathematica"),
	  nc("",".nc","application/x-netcdf"),
	  nds("",".nds","application/x-nintendo-ds-rom"),
	  nef("",".nef","image/x-nikon-nef"),
	  nes("",".nes","application/x-nes-rom"),
	  nfo("",".nfo","text/x-nfo"),
	  not("",".not","text/x-mup"),
	  nsc("",".nsc","application/x-netshow-channel"),
	  nsv("",".nsv","video/x-nsv"),
	  o("",".o","application/x-object"),
	  obj("",".obj","application/x-tgif"),
	  ocl("",".ocl","text/x-ocl"),
	  oda("",".oda","application/oda"),
	  odb("",".odb","application/vnd.oasis.opendocument.database"),
	  odc("",".odc","application/vnd.oasis.opendocument.chart"),
	  odf("",".odf","application/vnd.oasis.opendocument.formula"),
	  odg("",".odg","application/vnd.oasis.opendocument.graphics"),
	  odi("",".odi","application/vnd.oasis.opendocument.image"),
	  odm("",".odm","application/vnd.oasis.opendocument.text-master"),
	  odp("",".odp","application/vnd.oasis.opendocument.presentation"),
	  ods("",".ods","application/vnd.oasis.opendocument.spreadsheet"),
	  odt("",".odt","application/vnd.oasis.opendocument.text"),
	  oga("",".oga","audio/ogg"),
	  ogg("",".ogg","video/x-theora+ogg"),
	  ogm("",".ogm","video/x-ogm+ogg"),
	  ogv("",".ogv","video/ogg"),
	  ogx("",".ogx","application/ogg"),
	  old("",".old","application/x-trash"),
	  oleo("",".oleo","application/x-oleo"),
	  opml("",".opml","text/x-opml+xml"),
	  ora("",".ora","image/openraster"),
	  orf("",".orf","image/x-olympus-orf"),
	  otc("",".otc","application/vnd.oasis.opendocument.chart-template"),
	  otf("",".otf","application/x-font-otf"),
	  otg("",".otg","application/vnd.oasis.opendocument.graphics-template"),
	  oth("",".oth","application/vnd.oasis.opendocument.text-web"),
	  otp("",".otp","application/vnd.oasis.opendocument.presentation-template"),
	  ots("",".ots","application/vnd.oasis.opendocument.spreadsheet-template"),
	  ott("",".ott","application/vnd.oasis.opendocument.text-template"),
	  owl("",".owl","application/rdf+xml"),
	  oxt("",".oxt","application/vnd.openofficeorg.extension"),
	  p("",".p","text/x-pascal"),
	  p10("",".p10","application/pkcs10"),
	  p12("",".p12","application/x-pkcs12"),
	  p7b("",".p7b","application/x-pkcs7-certificates"),
	  p7s("",".p7s","application/pkcs7-signature"),
	  pack("",".pack","application/x-java-pack200"),
	  pak("",".pak","application/x-pak"),
	  par2("",".par2","application/x-par2"),
	  pas("",".pas","text/x-pascal"),
	  patch("",".patch","text/x-patch"),
	  pbm("",".pbm","image/x-portable-bitmap"),
	  pcd("",".pcd","image/x-photo-cd"),
	  pcf("",".pcf","application/x-cisco-vpn-settings"),
	  pcf_gz("",".pcf.gz","application/x-font-pcf"),
	  pcf_z("",".pcf.z","application/x-font-pcf"),
	  pcl("",".pcl","application/vnd.hp-pcl"),
	  pcx("",".pcx","image/x-pcx"),
	  pdb("",".pdb","chemical/x-pdb"),
	  pdc("",".pdc","application/x-aportisdoc"),
	  pdf("",".pdf","application/pdf"),
	  pdf_bz2("",".pdf.bz2","application/x-bzpdf"),
	  pdf_gz("",".pdf.gz","application/x-gzpdf"),
	  pef("",".pef","image/x-pentax-pef"),
	  pem("",".pem","application/x-x509-ca-cert"),
	  perl("",".perl","application/x-perl"),
	  pfa("",".pfa","application/x-font-type1"),
	  pfb("",".pfb","application/x-font-type1"),
	  pfx("",".pfx","application/x-pkcs12"),
	  pgm("",".pgm","image/x-portable-graymap"),
	  pgn("",".pgn","application/x-chess-pgn"),
	  pgp("",".pgp","application/pgp-encrypted"),
	  php("",".php","application/x-php"),
	  php3("",".php3","application/x-php"),
	  php4("",".php4","application/x-php"),
	  pict("",".pict","image/x-pict"),
	  pict1("",".pict1","image/x-pict"),
	  pict2("",".pict2","image/x-pict"),
	  pickle("",".pickle","application/python-pickle"),
	  pk("",".pk","application/x-tex-pk"),
	  pkipath("",".pkipath","application/pkix-pkipath"),
	  pkr("",".pkr","application/pgp-keys"),
	  pl("",".pl","application/x-perl"),
	  pla("",".pla","audio/x-iriver-pla"),
	  pln("",".pln","application/x-planperfect"),
	  pls("",".pls","audio/x-scpls"),
	  pm("",".pm","application/x-perl"),
	  png("",".png","image/png"),
	  pnm("",".pnm","image/x-portable-anymap"),
	  pntg("",".pntg","image/x-macpaint"),
	  po("",".po","text/x-gettext-translation"),
	  por("",".por","application/x-spss-por"),
	  pot("",".pot","text/x-gettext-translation-template"),
	  ppm("",".ppm","image/x-portable-pixmap"),
	  pps("",".pps","application/vnd.ms-powerpoint"),
	  ppt("",".ppt","application/vnd.ms-powerpoint"),
	  pptm("",".pptm","application/vnd.openxmlformats-officedocument.presentationml.presentation"),
	  pptx("",".pptx","application/vnd.openxmlformats-officedocument.presentationml.presentation"),
	  ppz("",".ppz","application/vnd.ms-powerpoint"),
	  prc("",".prc","application/x-palm-database"),
	  ps("",".ps","application/postscript"),
	  ps_bz2("",".ps.bz2","application/x-bzpostscript"),
	  ps_gz("",".ps.gz","application/x-gzpostscript"),
	  psd("",".psd","image/vnd.adobe.photoshop"),
	  psf("",".psf","audio/x-psf"),
	  psf_gz("",".psf.gz","application/x-gz-font-linux-psf"),
	  psflib("",".psflib","audio/x-psflib"),
	  psid("",".psid","audio/prs.sid"),
	  psw("",".psw","application/x-pocket-word"),
	  pw("",".pw","application/x-pw"),
	  py("",".py","text/x-python"),
	  pyc("",".pyc","application/x-python-bytecode"),
	  pyo("",".pyo","application/x-python-bytecode"),
	  qif("",".qif","image/x-quicktime"),
	  qt("",".qt","video/quicktime"),
	  qtif("",".qtif","image/x-quicktime"),
	  qtl("",".qtl","application/x-quicktime-media-link"),
	  qtvr("",".qtvr","video/quicktime"),
	  ra("",".ra","audio/vnd.rn-realaudio"),
	  raf("",".raf","image/x-fuji-raf"),
	  ram("",".ram","application/ram"),
	  rar("",".rar","application/x-rar"),
	  ras("",".ras","image/x-cmu-raster"),
	  raw("",".raw","image/x-panasonic-raw"),
	  rax("",".rax","audio/vnd.rn-realaudio"),
	  rb("",".rb","application/x-ruby"),
	  rdf("",".rdf","application/rdf+xml"),
	  rdfs("",".rdfs","application/rdf+xml"),
	  reg("",".reg","text/x-ms-regedit"),
	  rej("",".rej","application/x-reject"),
	  rgb("",".rgb","image/x-rgb"),
	  rle("",".rle","image/rle"),
	  rm("",".rm","application/vnd.rn-realmedia"),
	  rmj("",".rmj","application/vnd.rn-realmedia"),
	  rmm("",".rmm","application/vnd.rn-realmedia"),
	  rms("",".rms","application/vnd.rn-realmedia"),
	  rmvb("",".rmvb","application/vnd.rn-realmedia"),
	  rmx("",".rmx","application/vnd.rn-realmedia"),
	  roff("",".roff","text/troff"),
	  rp("",".rp","image/vnd.rn-realpix"),
	  rpm("",".rpm","application/x-rpm"),
	  rss("",".rss","application/rss+xml"),
	  rt("",".rt","text/vnd.rn-realtext"),
	  rtf("",".rtf","application/rtf"),
	  rtx("",".rtx","text/richtext"),
	  rv("",".rv","video/vnd.rn-realvideo"),
	  rvx("",".rvx","video/vnd.rn-realvideo"),
	  s3m("",".s3m","audio/x-s3m"),
	  sam("",".sam","application/x-amipro"),
	  sami("",".sami","application/x-sami"),
	  sav("",".sav","application/x-spss-sav"),
	  scm("",".scm","text/x-scheme"),
	  sda("",".sda","application/vnd.stardivision.draw"),
	  sdc("",".sdc","application/vnd.stardivision.calc"),
	  sdd("",".sdd","application/vnd.stardivision.impress"),
	  sdp("",".sdp","application/sdp"),
	  sds("",".sds","application/vnd.stardivision.chart"),
	  sdw("",".sdw","application/vnd.stardivision.writer"),
	  sgf("",".sgf","application/x-go-sgf"),
	  sgi("",".sgi","image/x-sgi"),
	  sgl("",".sgl","application/vnd.stardivision.writer"),
	  sgm("",".sgm","text/sgml"),
	  sgml("",".sgml","text/sgml"),
	  sh("",".sh","application/x-shellscript"),
	  shar("",".shar","application/x-shar"),
	  shn("",".shn","application/x-shorten"),
	  siag("",".siag","application/x-siag"),
	  sid("",".sid","audio/prs.sid"),
	  sik("",".sik","application/x-trash"),
	  sis("",".sis","application/vnd.symbian.install"),
	  sisx("",".sisx","x-epoc/x-sisx-app"),
	  sit("",".sit","application/x-stuffit"),
	  siv("",".siv","application/sieve"),
	  sk("",".sk","image/x-skencil"),
	  sk1("",".sk1","image/x-skencil"),
	  skr("",".skr","application/pgp-keys"),
	  slk("",".slk","text/spreadsheet"),
	  smaf("",".smaf","application/x-smaf"),
	  smc("",".smc","application/x-snes-rom"),
	  smd("",".smd","application/vnd.stardivision.mail"),
	  smf("",".smf","application/vnd.stardivision.math"),
	  smi("",".smi","application/x-sami"),
	  smil("",".smil","application/smil"),
	  sml("",".sml","application/smil"),
	  sms("",".sms","application/x-sms-rom"),
	  snd("",".snd","audio/basic"),
	  so("",".so","application/x-sharedlib"),
	  spc("",".spc","application/x-pkcs7-certificates"),
	  spd("",".spd","application/x-font-speedo"),
	  spec("",".spec","text/x-rpm-spec"),
	  spl("",".spl","application/x-shockwave-flash"),
	  spx("",".spx","audio/x-speex"),
	  sql("",".sql","text/x-sql"),
	  sr2("",".sr2","image/x-sony-sr2"),
	  src("",".src","application/x-wais-source"),
	  srf("",".srf","image/x-sony-srf"),
	  srt("",".srt","application/x-subrip"),
	  ssa("",".ssa","text/x-ssa"),
	  stc("",".stc","application/vnd.sun.xml.calc.template"),
	  std("",".std","application/vnd.sun.xml.draw.template"),
	  sti("",".sti","application/vnd.sun.xml.impress.template"),
	  stm("",".stm","audio/x-stm"),
	  stw("",".stw","application/vnd.sun.xml.writer.template"),
	  sty("",".sty","text/x-tex"),
	  sub("",".sub","text/x-subviewer"),
	  sun("",".sun","image/x-sun-raster"),
	  sv4cpio("",".sv4cpio","application/x-sv4cpio"),
	  sv4crc("",".sv4crc","application/x-sv4crc"),
	  svg("",".svg","image/svg+xml"),
	  svgz("",".svgz","image/svg+xml-compressed"),
	  swf("",".swf","application/x-shockwave-flash"),
	  sxc("",".sxc","application/vnd.sun.xml.calc"),
	  sxd("",".sxd","application/vnd.sun.xml.draw"),
	  sxg("",".sxg","application/vnd.sun.xml.writer.global"),
	  sxi("",".sxi","application/vnd.sun.xml.impress"),
	  sxm("",".sxm","application/vnd.sun.xml.math"),
	  sxw("",".sxw","application/vnd.sun.xml.writer"),
	  sylk("",".sylk","text/spreadsheet"),
	  t("",".t","text/troff"),
	  t2t("",".t2t","text/x-txt2tags"),
	  tar("",".tar","application/x-tar"),
	  tar_bz("",".tar.bz","application/x-bzip-compressed-tar"),
	  tar_bz2("",".tar.bz2","application/x-bzip-compressed-tar"),
	  tar_gz("",".tar.gz","application/x-compressed-tar"),
	  tar_lzma("",".tar.lzma","application/x-lzma-compressed-tar"),
	  tar_lzo("",".tar.lzo","application/x-tzo"),
	  tar_xz("",".tar.xz","application/x-xz-compressed-tar"),
	  tar_z("",".tar.z","application/x-tarz"),
	  tbz("",".tbz","application/x-bzip-compressed-tar"),
	  tbz2("",".tbz2","application/x-bzip-compressed-tar"),
	  tcl("",".tcl","text/x-tcl"),
	  tex("",".tex","text/x-tex"),
	  texi("",".texi","text/x-texinfo"),
	  texinfo("",".texinfo","text/x-texinfo"),
	  tga("",".tga","image/x-tga"),
	  tgz("",".tgz","application/x-compressed-tar"),
	  theme("",".theme","application/x-theme"),
	  themepack("",".themepack","application/x-windows-themepack"),
	  tif("",".tif","image/tiff"),
	  tiff("",".tiff","image/tiff"),
	  tk("",".tk","text/x-tcl"),
	  tlz("",".tlz","application/x-lzma-compressed-tar"),
	  tnef("",".tnef","application/vnd.ms-tnef"),
	  tnf("",".tnf","application/vnd.ms-tnef"),
	  toc("",".toc","application/x-cdrdao-toc"),
	  torrent("",".torrent","application/x-bittorrent"),
	  tpic("",".tpic","image/x-tga"),
	  tr("",".tr","text/troff"),
	  ts("",".ts","application/x-linguist"),
	  tsv("",".tsv","text/tab-separated-values"),
	  tta("",".tta","audio/x-tta"),
	  ttc("",".ttc","application/x-font-ttf"),
	  ttf("",".ttf","application/x-font-ttf"),
	  ttx("",".ttx","application/x-font-ttx"),
	  txt("",".txt","text/plain"),
	  txz("",".txz","application/x-xz-compressed-tar"),
	  tzo("",".tzo","application/x-tzo"),
	  ufraw("",".ufraw","application/x-ufraw"),
	  ui("",".ui","application/x-designer"),
	  uil("",".uil","text/x-uil"),
	  ult("",".ult","audio/x-mod"),
	  uni("",".uni","audio/x-mod"),
	  uri("",".uri","text/x-uri"),
	  url("",".url","text/x-uri"),
	  ustar("",".ustar","application/x-ustar"),
	  vala("",".vala","text/x-vala"),
	  vapi("",".vapi","text/x-vala"),
	  vcf("",".vcf","text/directory"),
	  vcs("",".vcs","text/calendar"),
	  vct("",".vct","text/directory"),
	  vda("",".vda","image/x-tga"),
	  vhd("",".vhd","text/x-vhdl"),
	  vhdl("",".vhdl","text/x-vhdl"),
	  viv("",".viv","video/vivo"),
	  vivo("",".vivo","video/vivo"),
	  vlc("",".vlc","audio/x-mpegurl"),
	  vob("",".vob","video/mpeg"),
	  voc("",".voc","audio/x-voc"),
	  vor("",".vor","application/vnd.stardivision.writer"),
	  vst("",".vst","image/x-tga"),
	  wav("",".wav","audio/x-wav"),
	  wax("",".wax","audio/x-ms-asx"),
	  wb1("",".wb1","application/x-quattropro"),
	  wb2("",".wb2","application/x-quattropro"),
	  wb3("",".wb3","application/x-quattropro"),
	  wbmp("",".wbmp","image/vnd.wap.wbmp"),
	  wcm("",".wcm","application/vnd.ms-works"),
	  wdb("",".wdb","application/vnd.ms-works"),
	  webm("",".webm","video/webm"),
	  wk1("",".wk1","application/vnd.lotus-1-2-3"),
	  wk3("",".wk3","application/vnd.lotus-1-2-3"),
	  wk4("",".wk4","application/vnd.lotus-1-2-3"),
	  wks("",".wks","application/vnd.ms-works"),
	  wma("",".wma","audio/x-ms-wma"),
	  wmf("",".wmf","image/x-wmf"),
	  wml("",".wml","text/vnd.wap.wml"),
	  wmls("",".wmls","text/vnd.wap.wmlscript"),
	  wmv("",".wmv","video/x-ms-wmv"),
	  wmx("",".wmx","audio/x-ms-asx"),
	  wp("",".wp","application/vnd.wordperfect"),
	  wp4("",".wp4","application/vnd.wordperfect"),
	  wp5("",".wp5","application/vnd.wordperfect"),
	  wp6("",".wp6","application/vnd.wordperfect"),
	  wpd("",".wpd","application/vnd.wordperfect"),
	  wpg("",".wpg","application/x-wpg"),
	  wpl("",".wpl","application/vnd.ms-wpl"),
	  wpp("",".wpp","application/vnd.wordperfect"),
	  wps("",".wps","application/vnd.ms-works"),
	  wri("",".wri","application/x-mswrite"),
	  wrl("",".wrl","model/vrml"),
	  wv("",".wv","audio/x-wavpack"),
	  wvc("",".wvc","audio/x-wavpack-correction"),
	  wvp("",".wvp","audio/x-wavpack"),
	  wvx("",".wvx","audio/x-ms-asx"),
	  x3f("",".x3f","image/x-sigma-x3f"),
	  xac("",".xac","application/x-gnucash"),
	  xbel("",".xbel","application/x-xbel"),
	  xbl("",".xbl","application/xml"),
	  xbm("",".xbm","image/x-xbitmap"),
	  xcf("",".xcf","image/x-xcf"),
	  xcf_bz2("",".xcf.bz2","image/x-compressed-xcf"),
	  xcf_gz("",".xcf.gz","image/x-compressed-xcf"),
	  xhtml("",".xhtml","application/xhtml+xml"),
	  xi("",".xi","audio/x-xi"),
	  xla("",".xla","application/vnd.ms-excel"),
	  xlc("",".xlc","application/vnd.ms-excel"),
	  xld("",".xld","application/vnd.ms-excel"),
	  xlf("",".xlf","application/x-xliff"),
	  xliff("",".xliff","application/x-xliff"),
	  xll("",".xll","application/vnd.ms-excel"),
	  xlm("",".xlm","application/vnd.ms-excel"),
	  xls("",".xls","application/vnd.ms-excel"),
	  xlsm("",".xlsm","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
	  xlsx("",".xlsx","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"),
	  xlt("",".xlt","application/vnd.ms-excel"),
	  xlw("",".xlw","application/vnd.ms-excel"),
	  xm("",".xm","audio/x-xm"),
	  xmf("",".xmf","audio/x-xmf"),
	  xmi("",".xmi","text/x-xmi"),
	  xml("",".xml","application/xml"),
	  xpm("",".xpm","image/x-xpixmap"),
	  xps("",".xps","application/vnd.ms-xpsdocument"),
	  xsl("",".xsl","application/xml"),
	  xslfo("",".xslfo","text/x-xslfo"),
	  xslt("",".xslt","application/xml"),
	  xspf("",".xspf","application/xspf+xml"),
	  xul("",".xul","application/vnd.mozilla.xul+xml"),
	  xwd("",".xwd","image/x-xwindowdump"),
	  xyz("",".xyz","chemical/x-pdb"),
	  xz("",".xz","application/x-xz"),
	  w2p("",".w2p","application/w2p"),
	  z("",".z","application/x-compress"),
	  zabw("",".zabw","application/x-abiword"),
	  zip("",".zip","application/zip"),
	  zoo("",".zoo","application/x-zoo"),
	  //另加的
	  defaultValue("默认值，如果没有命中则返回它",".*","application/octet-stream"),
	;

	
	private final String desc;

	private final String value;

	private final String suffix;

	public String getValue() {
		return value;
	}

	public String getSuffix() {
		return suffix;
	}

	private ContentType(String desc, String suffix, String value) {
		this.desc = desc;
		this.suffix = suffix;
		this.value = value;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}
	//suffix变为name规则：+改为plus  , 数据开前前加_,  中间点改为_
	//通过后缀得到枚举值
	public static ContentType findSuffix(String suffix) {
		if (StringUtils.isEmpty(suffix)) {
			return ContentType.defaultValue;//默认做为application/octet-stream流进行处理
		}
		for (ContentType ele : ContentType.values()) {
			if (suffix.equalsIgnoreCase(ele.getSuffix())) {
				return ele;
			}
		}
		return ContentType.defaultValue;
	}
	
	public static ContentType findByFileName(String fileName) {
		int lastIndexOf = fileName.lastIndexOf(".");
		String suffix=fileName.substring(lastIndexOf);
		return findSuffix(suffix);
	}
	
	
}
