/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;

import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;

/***
 * 从一个list选出解释值
 * 
 * @author andy.zhou
 *
 */
public class ConvertValueList implements IConvertValue<String> {
	private final List<?> valList;
	private final String idCol;
	private final String valCol;

	public ConvertValueList(List<?> valList, String idCol, String valCol) {
		this.valList = valList;
		this.idCol = idCol;
		this.valCol = valCol;
	}

	@Override
	public String getStr(String keyObj) {
		if (CollectionUtils.isEmpty(valList) || StringUtil.isNull(idCol) || StringUtil.isNull(valCol)) {
			return keyObj;
		}
		String retstr = keyObj;
		for (Object object : valList) {
			try {
				String id = BeanUtils.getProperty(object, idCol);
				if (StringUtil.hasNull(keyObj).equals(id)) {
					retstr = BeanUtils.getProperty(object, valCol);
					break;
				}
			} catch (Exception e) {
			}
		}
		return retstr;
	}

}
