/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.callback.impl.convertvalue;

import java.util.Map;

import org.apache.commons.collections.MapUtils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.StrPattern;

@Slf4j
public class ConvertValueEasyUICombobox implements IConvertValue<String> {
	private final String url;
	private final boolean cache;
	private JSONArray objs;
	private final String textField;
	private final String valueField;

	/***
	 * 
	 * @param url        查询地址
	 * @param cache      是否缓存结果
	 * @param urlContext 用于替换地址中${}的参数，达到动态修改地址的目的
	 */
	public ConvertValueEasyUICombobox(String url, String textField, String valueField, boolean cache,
			Map<String, String> urlContext) {
		String urlTrue = url;
		if (MapUtils.isNotEmpty(urlContext)) {
			for (String contextKey : urlContext.keySet()) {
				urlTrue = urlTrue.replace(String.format("${%s}", contextKey), urlContext.get(contextKey));
			}
		}
		if (!StrPattern.weburl.checkStrFormat(urlTrue)) {// 是weburl
			String context = Conf.get("common.apiext.context");
			log.info("后端使用的context为：{}", context);
			urlTrue = StringUtil.isNull(context) ? urlTrue : IOUtil.mergeFolderAndFilePath(context, urlTrue);
		}
		if (cache) {
			try {
				JSONArray objs = JSONArray.parseArray(ConvertValueEasyUIGrid.callUrlByTenant(urlTrue));
				this.objs = objs;
			} catch (Throwable e) {
				this.objs = null;
			}
		} else {
			this.objs = null;
		}
		this.url = urlTrue;
		this.cache = cache;
		this.textField = StringUtil.hasNull(textField, "name");
		this.valueField = StringUtil.hasNull(valueField, "id");
	}

	@Override
	public String getStr(String keyObj) {
		if (StringUtil.isNull(keyObj)) {
			return "";
		}
		try {
			JSONArray tempObjs = this.objs;
			if (tempObjs == null) {
				tempObjs = JSONArray.parseArray(ConvertValueEasyUIGrid.callUrlByTenant(this.url));
				if (this.cache) {
					this.objs = tempObjs;
				}
			}
			for (int i = 0; i < tempObjs.size(); i++) {
				JSONObject object = tempObjs.getJSONObject(i);
				if (keyObj.equals(object.getString(this.valueField))) {
					return object.getString(this.textField);
				}
			}
			return keyObj;
		} catch (Throwable e) {
			return keyObj;
		}
	}

}
