/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.beans;

import java.util.HashMap;
import java.util.Map;

import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;

/**
 * jdbc的数据库配置
 * 
 * @author Administrator
 *
 */
@Data
public class JdbcBean {
	private String url;
	private String host;
	private Integer port;
	private String defaultdb;
	private String urlparam;
	private String username;
	private String password;

	public Map<String, String> toMap() {
		Map<String, String> retmap = new HashMap<String, String>();
		if (StringUtil.isNotNull(url)) {
			retmap.put("url", url);
		}
		if (StringUtil.isNotNull(host)) {
			retmap.put("host", host);
		}
		if (port != null) {
			retmap.put("port", String.valueOf(port));
		}
		if (StringUtil.isNotNull(defaultdb)) {
			retmap.put("defaultdb", defaultdb);
		}
		if (StringUtil.isNotNull(urlparam)) {
			retmap.put("urlparam", urlparam);
		}
		if (StringUtil.isNotNull(username)) {
			retmap.put("username", username);
		}
		if (StringUtil.isNotNull(password)) {
			retmap.put("password", password);
		}
		return retmap;
	}
}
