/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.constant.MathConvertType;
import net.wicp.tams.common.thread.threadlocal.PerthreadManager;

/**
 * 时间处理常用方法
 * 
 * @author 偏锋书生
 *
 */
@Slf4j
public abstract class TimeAssist {

	/***
	 * 把秒数转为分钟数
	 * 
	 * @param min     秒数
	 * @param conType 转换类型，分为trunc("取整"),round("四舍五入"),ceil("有值进1")
	 * @return 分钟数
	 */
	public static int convertMinuteToSecond(int min, MathConvertType conType) {
		int retValue = 0;
		switch (conType) {
		case trunc:
			retValue = (int) Math.floor((float) min / 60);
			break;
		case round:
			retValue = (int) Math.rint((float) min / 60);
			break;
		case ceil:
			retValue = (int) Math.ceil((float) min / 60);
			break;
		default:
			break;
		}
		return retValue;
	}

	/***
	 * 再次做需要等待，1：1秒 2:2秒，3：4秒，4：8秒，后面是前面的2倍
	 * 
	 * @param key      唯一区别码
	 * @param maxDoNum 最大重试次数
	 * @return false:没到达最大次数,true:已到达最大次数
	 */
	public static boolean reDoWait(String key, int maxDoNum) {
		Integer sendNum = PerthreadManager.getInstance().createValue(key + "-sendNum", Integer.class).get(0);
		Integer timeout = PerthreadManager.getInstance().createValue(key + "-timeout", Integer.class).get(1);
		if (sendNum >= maxDoNum) {
			log.error("已超过最大处理次数：{}，总等待时长：{}，需要联系相关人员", maxDoNum, timeout);
			return true;
		}
		PerthreadManager.getInstance().createValue(key + "-sendNum", Integer.class).set(sendNum + 1);
		try {
			Thread.sleep(timeout * 1000);
		} catch (InterruptedException e) {
		}
		log.error("第[{}]次发送失败，当前等待时长：{}，总等待时长：{}，需要联系相关人员", sendNum, timeout, timeout * 2);
		PerthreadManager.getInstance().createValue(key + "-timeout", Integer.class).set(timeout * 2);
		return false;
	}

	/***
	 * 与reDoWait配合使用，重新计时
	 * 
	 * @param key 唯一区别码
	 */
	public static void reDoWaitInit(String key) {
		PerthreadManager.getInstance().cleanValue(key + "-sendNum");
		PerthreadManager.getInstance().cleanValue(key + "-timeout");
	}

}
