/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

@Slf4j
public abstract class SshAssist {
	public static void ssh(int localhostPort, String proxyhost, int proxyport) {
		try {
			JSch jsch = new JSch();
			Session session = jsch.getSession(Conf.get("common.apiext.ssh.username"),
					Conf.get("common.apiext.ssh.host"), Integer.parseInt(Conf.get("common.apiext.ssh.port")));
			session.setPassword(Conf.get("common.apiext.ssh.password"));
			session.setConfig("StrictHostKeyChecking", "no");
			session.connect();
			// 打印SSH服务器版本信息
			log.info("ssh server version:{}", session.getServerVersion());
			// ssh -L 192.168.0.102:5555:192.168.0.101:3306 username@192.168.0.102 正向代理
			session.setPortForwardingL(localhostPort, proxyhost, proxyport);// 端口映射转发

		} catch (Exception e) {
			log.error("SSH失败", e);
			throw new ProjectExceptionRuntime(ExceptAll.auth_proxy_setting, "SSH配置失败");
		}
	}

	public static void ssh() {
		ssh(Integer.parseInt(Conf.get("common.apiext.ssh.proxy.localhost.port")),
				Conf.get("common.apiext.ssh.proxy.go.host"),
				Integer.parseInt(Conf.get("common.apiext.ssh.proxy.go.port")));
	}
}
