/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.apiext;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.constant.dic.YesOrNo;

/**
 * 
 * @author 偏锋书生
 *
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
@Slf4j
public abstract class ReflectAssist {

	private static String[] excludeGet = new String[] { "getClass" };

	private static String[] objectMethod;

	public static String[] interfaceMethod = new String[] { "annotationType", "isProxyClass", "getProxyClass",
			"newProxyInstance", "getInvocationHandler" };// @interface含有的内部方法

	public static String[] getObjectMethods() {
		if (objectMethod == null) {
			List<String> retlist = new ArrayList<String>();
			Method[] methods = Object.class.getMethods();
			for (Method method : methods) {
				retlist.add(method.getName());
			}
			objectMethod = retlist.toArray(new String[retlist.size()]);
		}
		return objectMethod;
	}

//得到非object的方法
	public static String[] getNotObjectMethods(Class classz) {
		List<String> retlist = new ArrayList<String>();
		Method[] methods = classz.getMethods();
		for (Method method : methods) {
			if (!ArrayUtils.contains(getObjectMethods(), method.getName())
					&& !ArrayUtils.contains(interfaceMethod, method.getName())) {
				retlist.add(method.getName());
			}
		}
		return retlist.toArray(new String[retlist.size()]);
	}

	// 只取二层
	public static Object getPrivateField(Object bean, String fieldName) {
		Field field = null;
		try {
			field = bean.getClass().getDeclaredField(fieldName);
		} catch (Exception e) {
			log.error("get   field:[{}]  from class:[{}] error", fieldName, bean.getClass().getName());
			Class<?> superclass = bean.getClass().getSuperclass();
			try {
				field = superclass.getDeclaredField(fieldName);
			} catch (Exception e2) {
				log.error("get   field:[{}]  from super class:[{}] error", fieldName, superclass.getName());
				return null;
			}
		}
		if (!field.isAccessible()) {
			field.setAccessible(true);
		}
		try {
			Object retobj = field.get(bean);
			return retobj;
		} catch (Exception e) {
			log.error("get object error", e);
			return null;
		}
	}

	public static Object invokeStaticMothed(String className, String methodName, Class[] paramclass, Object... param)
			throws Exception {
		Class c = Class.forName(className);
		Method m = c.getMethod(methodName, paramclass);
		Object retobj = m.invoke(c, param);
		return retobj;
	}

	/****
	 * 用简单参数调用静态方法
	 * 
	 * @param className  要调用的静态方法所在的类名
	 * @param methodName 静态方法名
	 * @param param      调用的参数
	 * @return 调用返回值
	 * @throws Exception 调用时错误
	 */
	public static Object invokeStaticMothed(String className, String methodName, Object... param) throws Exception {
		Class[] paramClass = null;
		if (!org.apache.commons.lang3.ArrayUtils.isEmpty(param)) {
			paramClass = new Class[param.length];
			for (int i = 0; i < param.length; i++) {
				paramClass[i] = param.getClass();
			}
		}
		return invokeStaticMothed(className, methodName, paramClass, param);
	}

	/***
	 * 不断重试调用某方法
	 * 
	 * @param invokeObj
	 * @param methodName
	 * @param retryNum
	 * @param param
	 * @return
	 */
	public static Object invokeMothedRetry(Object invokeObj, String methodName, int retryNum, Object... param) {
		String uniqueLong = String.valueOf(UUIDGenerator.getUniqueLong());
		while (true) {
			try {
				Object object = invokeMothed(invokeObj, methodName, param);
				TimeAssist.reDoWaitInit(uniqueLong);
				return object;
			} catch (Throwable e) {
				boolean reDoWait = TimeAssist.reDoWait(uniqueLong, retryNum);
				log.error("--需要重试---", e);
				if (reDoWait) {
					throw e;
				}
			}
		}
	}

	/***
	 * 调用对象中的方法
	 * 
	 * @param invokeObj  方法所在的对象
	 * @param methodName 方法名
	 * @param param      调用的参数
	 * @return 调用方法返回的结果
	 */
	public static Object invokeMothed(Object invokeObj, String methodName, Object... param) {
		Class c = invokeObj.getClass();
		if (StringUtil.isNull(methodName)) {
			log.error("反射中缺少方法");
			return null;
		}
		Method[] m = c.getMethods();// .getMethod(methodName,ptypes);
		Method exeMethod = null;
		for (int i = 0; i < m.length; i++) {
			Method tempMethod = m[i];
			if (!methodName.equals(tempMethod.getName())) {// 方法名不相等
				continue;
			}
			Class[] classAry = tempMethod.getParameterTypes();
			if (classAry.length != param.length) {// 方法的参数不匹配
				continue;
			}
			if ((param == null && classAry == null) || (classAry.length == 0 && param.length == 0)) {// 无参数调用
				exeMethod = tempMethod;
				break;
			}

			boolean isthisMethod = true;
			for (int j = 1; j < classAry.length; j++) {
				Class classAryEle = classAry[j];
				Object paramEle = param[j];
				if (classAryEle.isArray() && paramEle.getClass().isArray()) {// TODO
																				// 参数是数组的如何查询它的元类型？？？？？
					try {
						Object[] paramArry = (Object[]) param;
						Object[] classInstArry = (Object[]) classAryEle.newInstance();
						if (paramArry[0].getClass().isAssignableFrom(classInstArry[0].getClass())) {
							isthisMethod = false;
							break;
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else if (!paramEle.getClass().isArray() && !classAryEle.isArray()) {
					if (!paramEle.getClass().isAssignableFrom(classAryEle)) {
						isthisMethod = false;
						break;
					}
				} else {
					isthisMethod = false;
					break;
				}
			}
			if (isthisMethod) {
				exeMethod = tempMethod;
				break;
			}

		}
		if (exeMethod != null) {
			try {
				exeMethod.setAccessible(true);
				return exeMethod.invoke(invokeObj, param);
			} catch (Exception e) {
				log.error("反射调用方法出错。",e);
			}
		}
		return null;
	}

	/***
	 * 判断类是否基本数据类型
	 * 
	 * @param clz 要判断的类
	 * @return 是否基本数据类型 true:是，false:否
	 */
	public static boolean isPrimitieClass(Class clz) {
		try {
			return ((Class) clz.getField("TYPE").get(null)).isPrimitive();
		} catch (Exception e) {
			return false;
		}
	}

	/***
	 * 找到get方法且没有参数的方法
	 * 
	 * @param clz get方法所在的类
	 * @return 所有的get方法的方法名，排除"getClass"方法
	 */
	public static List<String> findGetMethod(Class clz) {
		List<String> methList = new ArrayList<String>();
		Method[] m = clz.getMethods();
		if (m.length == 0) {
			return methList;
		}
		for (int i = 0; i < m.length; i++) {
			Method method = m[i];
			String methodName = method.getName();
			if (!methodName.startsWith("get")) {
				continue;
			}
			if (ArrayUtils.contains(excludeGet, methodName)) {
				continue;
			}
			Class[] classAry = method.getParameterTypes();
			if (classAry.length == 0) {
				methList.add(method.getName());
			}
		}
		return methList;
	}

	/***
	 * 找到get方法对应的域
	 * 
	 * @param clz 域所在的类
	 * @return 所有的域的名称
	 */
	public static List<String> findGetField(Class clz) {
		List<String> retList = new ArrayList<String>();
		List<String> methodList = findGetMethod(clz);
		for (String methodname : methodList) {
			String ele = methodname.substring(3);
			retList.add(ele.substring(0, 1).toLowerCase() + ele.substring(1));
		}
		return retList;
	}

	/***
	 * 把Bean对象转为Map
	 * 
	 * @param obj       要转换的Bean对象
	 * @param convermap 对象值的转换器，key：对象的域名称,value：转换器，它会把对应域的值按转换器规则转换值，把转换后的值放入结果Map
	 * @param allowNull 是否允许为空，true:允许，false：不允许，如果允许为空，则对象域的值为null也会加到结果map中
	 * @return 转换后的结果
	 */
	public static Map<String, String> convertMapFromBeanForConvert(Object obj, Map<String, IConvertValue> convermap,
			boolean allowNull) {
		Map<String, String> retmap = new HashMap<String, String>();
		if (obj == null) {
			return retmap;
		}
		List<String> fields = findGetField(obj.getClass());
		if (CollectionUtils.isNotEmpty(fields)) {
			for (String field : fields) {
				try {
					String value = null;
					if (convermap == null || !convermap.containsKey(field)) {
						value = BeanUtils.getProperty(obj, field);
					} else {
						IConvertValue convert = convermap.get(field);
						if (convert != null) {
							Object oriDate = PropertyUtils.getProperty(obj, field);
							value = convert.getStr(oriDate);
						} else {
							value = BeanUtils.getProperty(obj, field);
						}
					}
					if (!allowNull && StringUtil.isNull(value)) {// 不允许为空但又是空值
						continue;
					}
					if (StringUtil.isNotNull(value) && value.startsWith("org.apache.openjpa.enhance")) {// 由jpa生成的对象不放入
						continue;
					}
					retmap.put(field, value);
				} catch (Exception e) {
				}
			}
		}
		return retmap;
	}

	/***
	 * 把对象转为Map值, 主要用于把对象放到redis中(未测试)
	 * 
	 * @param obj 要转换的对象
	 * 
	 * @param <T> 转为map的bean类型
	 * @return 转换后的Map值
	 */
	public static <T> Map<String, String> convertMapFromBean(T obj) {
		Map<String, String> retmap = new HashMap<String, String>();
		if (obj == null) {
			return retmap;
		}
		List<String> fields = findGetField(obj.getClass());
		if (CollectionUtils.isNotEmpty(fields)) {
			for (String field : fields) {
				packMap(retmap, null, obj, field);
			}
		}
		return retmap;
	}

	/**
	 * 适合于简单的对象，如：mybatis生成的po
	 * 
	 * @param <T> 转为map的bean类型
	 */
	public static <T> Map<String, Object> convertMapFromSimpleBean(T obj) {
		Map<String, Object> retmap = new HashMap<String, Object>();
		if (obj == null) {
			return retmap;
		}
		List<String> fields = findGetField(obj.getClass());
		if (CollectionUtils.isNotEmpty(fields)) {
			for (String field : fields) {
				Object fieldObj = null;
				try {
					fieldObj = PropertyUtils.getProperty(obj, field);
				} catch (Exception e) {
				}
				retmap.put(field, fieldObj);
			}
		}
		return retmap;
	}

	/***
	 * 把对象的某个域设置到map中(未测试)，使用递归的方法找出子对象的值放入map
	 * 
	 * @param map      要放结果的map
	 * @param oldfield 父对象的域名称
	 * @param obj      要操作的对象
	 * @param field    要操作的域名称
	 */
	private static void packMap(Map<String, String> map, String oldfield, Object obj, String field) {
		String key = StringUtil.isNull(oldfield) ? field : String.format("%s.%s", oldfield, field);
		Object fieldObj = null;
		try {
			fieldObj = PropertyUtils.getProperty(obj, field);
		} catch (Exception e) {
		}
		if (fieldObj == null) {
			return;
		}
		if (isPrimitieClass(fieldObj.getClass()) || fieldObj instanceof String || fieldObj instanceof Enum) {
			String value = String.valueOf(fieldObj);
			if (StringUtil.isNotNull(value) && value.startsWith("org.apache.openjpa.enhance")) {// 由jpa生成的对象不放入
				return;
			}
			map.put(key, value);
		} else if (fieldObj instanceof Date) {
			SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy", java.util.Locale.US);// tostring默认的转码
			String datestr = sdf.format(fieldObj);
			map.put(key, datestr);
		} else {
			// 可能是一个复合对象
			List<String> fields = findGetField(fieldObj.getClass());
			if (CollectionUtils.isNotEmpty(fields)) {
				for (String subFields : fields) {
					packMap(map, key, fieldObj, subFields);
				}
			}
		}
	}

	/***
	 * 把map对象转为可序列化的对象，支持用.来级联 主要用于把redis的Map值转为相应的对象
	 * 
	 * @param clazz    要返回对象的类
	 * @param valueMap 要返回对象的值，key:如果是 a.b 那么它对应的value则是子对象的值
	 * @param <T>      要转的bean类型
	 * @return 转换后的对象值
	 */
	public static <T extends Serializable> T convertMapToBean(Class clazz, Map<String, String> valueMap) {
		if (MapUtils.isEmpty(valueMap)) {
			return null;
		}
		try {
			T t = (T) clazz.newInstance();
			for (String key : valueMap.keySet()) {
				String value = valueMap.get(key);
				StringUtil.packObj(t, key, value);
			}
			return t;
		} catch (Exception e) {
			throw new IllegalAccessError(e.getMessage());
		}
	}

	/***
	 * 得到指定父类的所有的泛型
	 * 
	 * @param clazz
	 * @param parentClass 父类
	 * @return
	 */
	private static void setSuperClassGenricTypes(List<Class> retClassList, Class clazz, Class parentClass) {
		Type genType = clazz.getGenericSuperclass();
		if(parentClass==null) {//默认只找一级
			setClassGenricTypes(retClassList,genType);
			return;
		}
		if (parentClass.isInterface()) {// 接口
			Type[] face = clazz.getGenericInterfaces();
			Type isFace = null;
			for (int i = 0, j = face.length; i < j; i++) {
				String className = null;
				if (face[i] instanceof ParameterizedType) {
					className = ((ParameterizedType) face[i]).getRawType().getTypeName();
				} else {
					className = ((Class) face[i]).getName();
				}
				if (className.equals(parentClass.getName())) {// 找到了这个接口
					isFace = face[i];
					break;
				}
			}
			if (isFace == null) {// 没有找到父接口
				for (int i = -1; i < face.length; i++) {
					if (i == -1) {
						setSuperClassGenricTypes(retClassList, (Class) genType, parentClass);// 父类
					} else {
						setSuperClassGenricTypes(retClassList, (Class) face[i], parentClass);// 接口类
					}
				}
			} else {
				setClassGenricTypes(retClassList, isFace);
			}
		} else {// 父类
			if (genType == null) {// 没有父类
				return;
			}
			// parentClass为空表示只找直属父类
			if (parentClass != null && !((Class) genType).getName().equals(parentClass.getName())) {// 不是找到的父类
				setSuperClassGenricTypes(retClassList, (Class) genType, parentClass);
			} else {// 是要找的父类
				setClassGenricTypes(retClassList, genType);
			}
		}
	}

	/***
	 * 设置类型的泛型
	 * 
	 * @param retClassList
	 * @param genType
	 */
	public static void setClassGenricTypes(List<Class> retClassList, Type genType) {
		if (genType instanceof ParameterizedType) {
			// return new Class[] {Object.class};
			Type[] params = ((ParameterizedType) genType).getActualTypeArguments();
			if (ArrayUtils.isNotEmpty(params)) {
//						return new Class[] {Object.class};
				// Class[] retClassAry=new Class[params.length];
				for (int i = 0; i < params.length; i++) {
					if (params[i] instanceof Class) {
						retClassList.add((Class) params[i]);
					}
					// retClassAry[i]=!(params[i] instanceof Class)?Object.class:(Class) params[i];
				}
				// return retClassAry;
			}
		}
	}

	public static Class[] getSuperClassGenricTypes(Class clazz, Class parentClass) {
		List<Class> retClassList = new ArrayList<Class>();
		setSuperClassGenricTypes(retClassList, clazz, parentClass);
		return retClassList.toArray(new Class[retClassList.size()]);
	}

	/***
	 * 判断类是否实现某个接口
	 * 
	 * @param classz      要判断的类
	 * @param szInterface 要判断的接口
	 * @return 是否继承了接口，true：是 false：否
	 */
	public static boolean isInterface(Class classz, String szInterface) {
		if (classz.getName().equals(szInterface)) {// tapestry中自动组装参数时添加。就是本类
			return true;
		}
		Class[] face = classz.getInterfaces();
		for (int i = 0, j = face.length; i < j; i++) {
			if (face[i].getName().equals(szInterface)) {
				return true;
			} else {
				Class[] face1 = face[i].getInterfaces();
				for (int x = 0; x < face1.length; x++) {
					if (face1[x].getName().equals(szInterface)) {
						return true;
					} else if (isInterface(face1[x], szInterface)) {
						return true;
					}
				}
			}
		}
		if (null != classz.getSuperclass()) {
			return isInterface(classz.getSuperclass(), szInterface);
		}
		return false;
	}

	/***
	 * 得到类的属性描述
	 * 
	 * @param clazz 要操作的类
	 * @return 属性描述数组
	 */
	public static PropertyDescriptor[] getPropertyDescriptors(Class clazz) {
		BeanInfo beanInfo = null;
		try {
			beanInfo = Introspector.getBeanInfo(clazz);
		} catch (IntrospectionException e) {
			e.printStackTrace();
		}
		return beanInfo.getPropertyDescriptors();
	}

	/***
	 * 得到属性描述所对应的类
	 * 
	 * @param propertyDescriptor 指定的属性描述
	 * @return 对应的类
	 */
	public static Class getClassRefType(PropertyDescriptor propertyDescriptor) {
		Field[] fields = propertyDescriptor.getClass().getSuperclass().getDeclaredFields();
		if (fields == null || fields.length <= 0) {
			return null;
		} else {
			for (Field field : fields) {
				if ("classRef".equals(field.getName())) {
					try {
						field.setAccessible(true); // 一定要设置为可访问
						return (Class) ((Reference) field.get(propertyDescriptor)).get();
					} catch (IllegalArgumentException e) {
						e.printStackTrace();
					} catch (IllegalAccessException e) {
						e.printStackTrace();
					}
				}
			}
		}
		return null;
	}

	/***
	 * 得到类所有域及对应的类
	 * 
	 * @param classz 要操作的类
	 * @return 所有域及对应的类
	 */
	public static Map<String, Class[]> getContextType(Class classz) {
		return getType(classz, YesOrNo.yes);
	}

	public static Map<String, Class[]> getAllType(Class classz) {
		return getType(classz, YesOrNo.no);
	}

	public static Map<String, Class[]> getFieldType(Class classz) {
		return getType(classz, null);
	}

	/***
	 * 
	 * @param classz
	 * @param onlyContext null：只导出字段的类型
	 *                    ，yes：只导出context类型，不导出数据类型，no：全部，即导出字段类型也导出context类型
	 * @return
	 */
	private static Map<String, Class[]> getType(Class classz, YesOrNo onlyContext) {
		Field[] fs = classz.getDeclaredFields(); // 得到所有的fields
		Map<String, Class[]> retMap = new HashMap<String, Class[]>();
		for (Field f : fs) {
			Class fieldClazz = f.getType(); // 得到field的class及类型全路径
			Class[] tempClassAry = null;
			if (fieldClazz.isPrimitive()) {
				if (onlyContext != null && onlyContext == YesOrNo.yes) {
					continue; // 【1】 //判断是否为基本类型
				} else {
					tempClassAry = new Class[] { fieldClazz };
				}
			} else if (fieldClazz.getName().startsWith("java.lang")) {
				if (onlyContext != null && onlyContext == YesOrNo.yes) {
					continue; // getName()返回field的类型全路径；
				} else {
					tempClassAry = new Class[] { fieldClazz };
				}
			} else if (fieldClazz.isAssignableFrom(List.class)) {
				// 【2】
				Type fc = f.getGenericType(); // 关键的地方，如果是List类型，得到其Generic的类型
				if (fc == null) {// 不是泛型，识别不出Generic类型

					if (onlyContext != null && onlyContext == YesOrNo.yes) {
						continue; //
					} else {
						tempClassAry = new Class[] { fieldClazz };
					}

				} else if (fc instanceof ParameterizedType) // 【3】如果是泛型参数的类型
				{
					ParameterizedType pt = (ParameterizedType) fc;
					Class genericClazz = (Class) pt.getActualTypeArguments()[0]; // 【4】
																					// 得到泛型里的class类型对象。

					if (onlyContext == null) {
						tempClassAry = new Class[] { fieldClazz };
					} else if (onlyContext == YesOrNo.yes) {
						tempClassAry = new Class[] { genericClazz };
					} else {
						tempClassAry = new Class[] { fieldClazz, genericClazz };
					}

					// retMap.put(f.getName(), new Class[] { genericClazz });
					// Map<String, Class> m1 = prepareMap(genericClazz);
					// m.putAll(m1);
				}
			} else if (fieldClazz.isAssignableFrom(Map.class)) {
				Type fc = f.getGenericType();

				if (fc == null) {// 不是泛型，识别不出Generic类型

					if (onlyContext != null && onlyContext == YesOrNo.yes) {
						continue; //
					} else {
						tempClassAry = new Class[] { fieldClazz };
					}

				} else if (fc instanceof ParameterizedType) {
					ParameterizedType pt = (ParameterizedType) fc;
					Class param0 = (Class) pt.getActualTypeArguments()[0]; // 【4】
					Class param1 = (Class) pt.getActualTypeArguments()[1]; // 【4】

					if (onlyContext == null) {
						tempClassAry = new Class[] { fieldClazz };
					} else if (onlyContext == YesOrNo.yes) {
						tempClassAry = new Class[] { param0, param1 };
					} else {
						tempClassAry = new Class[] { fieldClazz, param0, param1 };
					}
					// retMap.put(f.getName(), new Class[] { param0, param1 });
				}
			} else if (fieldClazz.isArray()) {
				if (onlyContext == null) {
					tempClassAry = new Class[] { fieldClazz };
				} else if (onlyContext == YesOrNo.yes) {
					tempClassAry = new Class[] { fieldClazz.getComponentType() };
				} else {
					tempClassAry = new Class[] { fieldClazz, fieldClazz.getComponentType() };
				}
				// retMap.put(f.getName(), new Class[] { fieldClazz.getComponentType() });
			} else {// Date等单值类型
				if (onlyContext != null && onlyContext == YesOrNo.yes) {
					continue;
				} else {
					tempClassAry = new Class[] { fieldClazz };
				}
			}
			if (tempClassAry != null) {
				retMap.put(f.getName(), tempClassAry);
			}
		}
		return retMap;
	}

	/***
	 * 复制对象
	 * 
	 * @param dest 目标对象
	 * @param orig 源对象
	 * @return 复制是否成功 result.isSuc() 为true:成功，false失败
	 */
	public static Result copyProperties(Object dest, Object orig) {
		try {
			BeanUtils.copyProperties(dest, orig);
			return Result.getSuc();
		} catch (Exception e) {
			log.error("复制属性出错", e);
			return Result.getError(e.getMessage());
		}
	}

	/***
	 * 合并对象，不合并空对象和空字符串
	 * 
	 * @param to      目标对象
	 * @param from    要被合并的对象
	 * @param removes 希望排除的字段
	 */
	public static void mergeObj(Object to, Object from, String... removes) {
		mergeObj(to, from, false, false, removes);
	}

	/***
	 * 合并对象，空字符串还是会合并。
	 * 
	 * @param to       目标对象
	 * @param from     要被合并的对象
	 * @param copyNull 是否复制空对象 true:空值也合并 false:空值不合并
	 * @param removes  希望排除的字段
	 */
	public static void mergeObj(Object to, Object from, boolean copyNull, String... removes) {
		mergeObj(to, from, copyNull, true, removes);
	}

	/***
	 * 合并对象
	 * 
	 * @param to        目标对象
	 * @param from      要被合并的对象
	 * @param copyNull  是否复制空对象 true:空值也合并 false:空值不合并
	 * @param copyBlank 是否复制空字符吕 true:空字符串也合并 false:空字符串不合并
	 * @param removes   希望排除的字段
	 */
	public static void mergeObj(Object to, Object from, boolean copyNull, boolean copyBlank, String... removes) {
		if (from == null)
			return;
		List<String> fields = findGetField(from.getClass());
		for (String field : fields) {
			if (ArrayUtils.contains(removes, field)) {
				continue;
			}
			try {
				Object value = PropertyUtils.getProperty(from, field);
				if ((!copyNull && value == null) || (!copyBlank && StringUtil.isNull(value))) {
					continue;
				}
				BeanUtils.copyProperty(to, field, value);
			} catch (Exception e) {
			}
		}
	}

	/**
	 * 通过反射,获得定义Class时声明的父类的范型参数的类型.
	 * 
	 * @param clazz 要得到此class的泛型class
	 * @param index 泛型的第几个参数，从0开始
	 */
	public static Class getSuperClassGenricType(Class clazz, Class parentClass, int index) {
		return getSuperClassGenricTypes(clazz, parentClass)[index];
	}

	/***
	 * 得到第0个泛型参数的类型
	 * 
	 * @param clazz 要得到此class的泛型class
	 * @return
	 */
	public static Class getSuperClassGenricType(Class clazz) {
		return getSuperClassGenricType(clazz, null, 0);
	}

	/***
	 * 调用无参的构造方法
	 * 
	 * @param clazz
	 * @return
	 */
	public static <T> T newInst(Class<T> clazz) {
		try {
			/* 以下调用无参的、私有构造函数 */
			Constructor c0 = clazz.getDeclaredConstructor();
			c0.setAccessible(true);
			T retobj = (T) c0.newInstance();
			return retobj;
		} catch (InstantiationException | IllegalAccessException | NoSuchMethodException | SecurityException
				| IllegalArgumentException | InvocationTargetException e) {
			return null;
		}
	}

	public static <T> T newInst(String className) {
		try {
			Class<T> clazz = (Class<T>) Class.forName(className);
			return newInst(clazz);
		} catch (ClassNotFoundException e) {
			return null;
		}
	}

	/***
	 * 获取方法上的注解值
	 * 
	 * @param calssZ
	 * @param classA
	 * @return
	 */
	public static List<Method> findMethods(Class<?> calssZ, Class<? extends Annotation> classA) {
		// 获取方法上的注解值
		Method[] methods = calssZ.getDeclaredMethods();
		List<Method> retMethods = new ArrayList<>();
		if (methods != null) {
			for (Method method : methods) {
				Annotation annotation = method.getAnnotation(classA);
				if (annotation == null)
					continue;
				retMethods.add(method);
			}
		}
		return retMethods;
	}

	/*****
	 * 获取申明了注解的字段
	 * 
	 * @param calssZ
	 * @param classA
	 * @param predicate 过滤条件
	 * @return
	 */
	public static List<Field> findFields(Class<?> calssZ, Class<? extends Annotation> classA, Predicate predicate) {
		// 获取字段上的注解值
		Field[] field = calssZ.getDeclaredFields();
		List<Field> retlist = new ArrayList<>();
		if (field != null) {
			for (Field fie : field) {
				if (!fie.isAccessible()) {
					fie.setAccessible(true);
				}
				// Annotation[] declaredAnnotations = fie.getDeclaredAnnotations();
				Annotation annotation = fie.getDeclaredAnnotation(classA); // .getAnnotation(classA);
				if (annotation == null)
					continue;
				retlist.add(fie);
			}
		}
		if (predicate != null) {
			CollectionUtils.filter(retlist, predicate);
		}
		return retlist;
	}

	/**
	 * 修改field级别的注解值，注意：是静态的，一修改全都修改了
	 * 
	 * @param <T>
	 * @param beanClass              拥有field的class
	 * @param hasAnnotationFieldName field的名称
	 * @param annotationClass        注解的class
	 * @param annotationFieldName    注解的名字
	 * @param newValue               新的值
	 * @throws Throwable
	 */
	public static <T> void alertFieldAnnotationValue(final Class<T> beanClass, String hasAnnotationFieldName,
			Class<? extends Annotation> annotationClass, String annotationFieldName, String newValue) throws Throwable {
		Field value = beanClass.getDeclaredField(hasAnnotationFieldName);
		value.setAccessible(true);
		// APIParam 是一个自定义的注解
		Annotation annotation = (Annotation) value.getAnnotation(annotationClass);
		java.lang.reflect.InvocationHandler invocationHandler = Proxy.getInvocationHandler(annotation);
		Field memberValues = invocationHandler.getClass().getDeclaredField("memberValues");
		memberValues.setAccessible(true);
		Map<String, Object> values = (Map<String, Object>) memberValues.get(invocationHandler);
		values.put(annotationFieldName, newValue);// 修改属性
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * void(V).
	 */
	public static final char JVM_VOID = 'V';

	/**
	 * boolean(Z).
	 */
	public static final char JVM_BOOLEAN = 'Z';

	/**
	 * byte(B).
	 */
	public static final char JVM_BYTE = 'B';

	/**
	 * char(C).
	 */
	public static final char JVM_CHAR = 'C';

	/**
	 * double(D).
	 */
	public static final char JVM_DOUBLE = 'D';

	/**
	 * float(F).
	 */
	public static final char JVM_FLOAT = 'F';

	/**
	 * int(I).
	 */
	public static final char JVM_INT = 'I';

	/**
	 * long(J).
	 */
	public static final char JVM_LONG = 'J';

	/**
	 * short(S).
	 */
	public static final char JVM_SHORT = 'S';

	public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class<?>[0];

	public static final String JAVA_IDENT_REGEX = "(?:[_$a-zA-Z][_$a-zA-Z0-9]*)";

	public static final String JAVA_NAME_REGEX = "(?:" + JAVA_IDENT_REGEX + "(?:\\." + JAVA_IDENT_REGEX + ")*)";

	public static final String CLASS_DESC = "(?:L" + JAVA_IDENT_REGEX + "(?:\\/" + JAVA_IDENT_REGEX + ")*;)";

	public static final String ARRAY_DESC = "(?:\\[+(?:(?:[VZBCDFIJS])|" + CLASS_DESC + "))";

	public static final String DESC_REGEX = "(?:(?:[VZBCDFIJS])|" + CLASS_DESC + "|" + ARRAY_DESC + ")";

	public static final Pattern DESC_PATTERN = Pattern.compile(DESC_REGEX);

	public static final String METHOD_DESC_REGEX = "(?:(" + JAVA_IDENT_REGEX + ")?\\((" + DESC_REGEX + "*)\\)("
			+ DESC_REGEX + ")?)";

	public static final Pattern METHOD_DESC_PATTERN = Pattern.compile(METHOD_DESC_REGEX);

	public static final Pattern GETTER_METHOD_DESC_PATTERN = Pattern
			.compile("get([A-Z][_a-zA-Z0-9]*)\\(\\)(" + DESC_REGEX + ")");

	public static final Pattern SETTER_METHOD_DESC_PATTERN = Pattern
			.compile("set([A-Z][_a-zA-Z0-9]*)\\((" + DESC_REGEX + ")\\)V");

	public static final Pattern IS_HAS_CAN_METHOD_DESC_PATTERN = Pattern
			.compile("(?:is|has|can)([A-Z][_a-zA-Z0-9]*)\\(\\)Z");

	private static final ConcurrentMap<String, Class<?>> NAME_CLASS_CACHE = new ConcurrentHashMap<String, Class<?>>();

	public static Class<?> forName(String name) {
		try {
			return name2class(name);
		} catch (ClassNotFoundException e) {
			throw new IllegalStateException("Not found class " + name + ", cause: " + e.getMessage(), e);
		}
	}

	/**
	 * name to class. "boolean" =》 boolean.class "java.util.Map[][]" =》
	 * java.util.Map[][].class
	 * 
	 * @param name name.
	 * @return Class instance.
	 */
	public static Class<?> name2class(String name) throws ClassNotFoundException {
		return name2class(ClassHelper.getClassLoader(), name);
	}

	/**
	 * name to class. "boolean" => boolean.class "java.util.Map[][]" =>
	 * java.util.Map[][].class
	 * 
	 * @param cl   ClassLoader instance.
	 * @param name name.
	 * @return Class instance.
	 */
	private static Class<?> name2class(ClassLoader cl, String name) throws ClassNotFoundException {
		int c = 0, index = name.indexOf('[');
		if (index > 0) {
			c = (name.length() - index) / 2;
			name = name.substring(0, index);
		}
		if (c > 0) {
			StringBuilder sb = new StringBuilder();
			while (c-- > 0)
				sb.append("[");

			if ("void".equals(name))
				sb.append(JVM_VOID);
			else if ("boolean".equals(name))
				sb.append(JVM_BOOLEAN);
			else if ("byte".equals(name))
				sb.append(JVM_BYTE);
			else if ("char".equals(name))
				sb.append(JVM_CHAR);
			else if ("double".equals(name))
				sb.append(JVM_DOUBLE);
			else if ("float".equals(name))
				sb.append(JVM_FLOAT);
			else if ("int".equals(name))
				sb.append(JVM_INT);
			else if ("long".equals(name))
				sb.append(JVM_LONG);
			else if ("short".equals(name))
				sb.append(JVM_SHORT);
			else
				sb.append('L').append(name).append(';'); // "java.lang.Object" ==> "Ljava.lang.Object;"
			name = sb.toString();
		} else {
			if ("void".equals(name))
				return void.class;
			else if ("boolean".equals(name))
				return boolean.class;
			else if ("byte".equals(name))
				return byte.class;
			else if ("char".equals(name))
				return char.class;
			else if ("double".equals(name))
				return double.class;
			else if ("float".equals(name))
				return float.class;
			else if ("int".equals(name))
				return int.class;
			else if ("long".equals(name))
				return long.class;
			else if ("short".equals(name))
				return short.class;
		}

		if (cl == null)
			cl = ClassHelper.getClassLoader();
		Class<?> clazz = NAME_CLASS_CACHE.get(name);
		if (clazz == null) {
			clazz = Class.forName(name, true, cl);
			NAME_CLASS_CACHE.put(name, clazz);
		}
		return clazz;
	}
	
    /**
     * 判断返回值类型是否是集合或者数组类型
     * @param returnType 类型
     * @return 是否是集合或者数组类型
     */
    public static boolean returnsMany(Class<?> returnType) {
        //判断返回类型是否是集合类型
        boolean isCollection = Collection.class.isAssignableFrom(returnType);
        //判断返回类型是否是数组类型
        boolean isArray = returnType.isArray();
        return isCollection || isArray;
    }


}
