/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Comparator;

import net.wicp.tams.common.constant.PageElement;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 用于生成对应的转换器
 * 
 * @author Andy
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.FIELD })
public @interface TamsCol {
	/***
	 * 字段描述,就是显示的label,暂不支持国际化
	 * 
	 * @return
	 */
	String value();

	/***
	 * grid列要显示的宽度，默认为0表示不显示
	 * 
	 * @return
	 */
	int showWidth() default 0;

	/***
	 * 是否出现在查询模块小于0:不显示 0：不必填 1：必填
	 * 
	 * @return
	 */
	short query() default -1;

	/**
	 * 在新增和修改时是否出现， 小于0:不显示，等于0：要显示但不必填，等于1：要显示且必填
	 * 
	 * @return
	 */
	short save() default -1;

	/***
	 * 是否需要组装查询结果到前端，有些大字段（如text类型）需要跳过，一避免前端json太大，二避免给前端的json出现格式错误
	 * 
	 * @return
	 */
	boolean excludeField() default false;

	/***
	 * 排序值,升序，默认排最后
	 * 
	 * @return
	 */
	int orderby() default Integer.MAX_VALUE;

	/***
	 * 页面元素，默认为输入框架。
	 * 
	 * @return
	 */
	PageElement pageElement() default PageElement.ValidateBox;

	/***
	 * 页面元素相关配置，json类型，元素为PageElementOpt,值为value
	 * 
	 * @return
	 */
	String pageElementOpt() default "";

	/**
	 * 跨td的数量，如果某个元素需要跨2列，那么colspan设置为3，加上label就是4，也就占据了2列的位置了
	 * 
	 * @return
	 */
	int colspan() default 1;

	/***
	 * 为了方便pageElementOpt里的重要配置项的配置，会把它们提出来单独配置 规则 ：opt_
	 * 开头，这些配置会覆盖pageElementOpt里的json值。
	 * 
	 * 这个字段用于配置枚举值的combobox，只要配置继承IEnumCombobox接口的枚举类就可以了。参考：YesOrNo.java
	 * 
	 * @return
	 */

	Class<? extends IEnumCombobox> opt_enumclass() default IEnumCombobox.class;

	/***
	 * validatebox用的字符检测，如果有更多的需要检查的正则表达式，可以在StrPattern枚举里添加，或做一些保存前的check勾子就好了
	 * 
	 * @return
	 */
	StrPattern opt_strpattern() default StrPattern.no;

	/***
	 * ComboGrid和ComboTree的列名快捷配置
	 * 
	 * @return
	 */
	String opt_columns() default "";
	
	String opt_toolbar() default "";

	/***
	 * 与TamsBean的convert配置作用相同，不过TamsBean的convert的元素需要配置4项，但此convert只要配置3项，
	 * 还有一项就是TamsCol所标注的这列的列名， eg在updateBy列上的注解:{"updateByName,100,创建者"}
	 * 相当于{"updateBy,updateByName,100,创建者"}
	 * 
	 * @return
	 */
	String[] convert() default {};

	/**
	 * 是否为json字符，查询时返回结果需要处理，如果是json字符不处理就会导致结果格式错误
	 * 
	 * @return
	 */
	boolean jsonFormat() default false;

	/***
	 * by andy.zhou 20211221 查询时出base64转成结果 ，这样在js上就可以把base64转为图片了，就不会出错。
	 * 
	 * @return
	 */
	boolean base64() default false;

	/****
	 * by andy.zhou 20211221 默认值
	 * 
	 * @return
	 */
	String defaultvalue() default "";

	/***
	 * 通过orderby字段排序
	 */
	public static Comparator<Field> comparator = new Comparator<Field>() {
		@Override
		public int compare(Field o1, Field o2) {
			TamsCol tamsCol1 = o1.getAnnotation(TamsCol.class);
			TamsCol tamsCol2 = o2.getAnnotation(TamsCol.class);
			return tamsCol1.orderby() - tamsCol2.orderby();
		}
	};
}
