/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/***
 * 用于脚手架生产查询
 * 
 * @author Andy
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
public @interface TamsBean {
	/***
	 * 页面标题
	 * 
	 * @return
	 */
	String title();

	/**
	 * 隐藏查询域，多个用逗号分隔
	 * 
	 * @return
	 */
	String hiddenQuery() default "";
	
	/**
	 * 隐藏保存域，多个用逗号分隔
	 * 
	 * @return
	 */
	String hiddenSave() default "";

	/***
	 * 增删改查的页面地址,如果没有配置，将会找到父类算出地址。 eg: queryUrl="/demo/CurdBeanMybatis:query"
	 * 地址为：/demo/CurdBeanMybatis
	 * 
	 * @return
	 */
	String url() default "";// 可以控制save/query/del，如果那三个参数没有配置，又配置了它，以它为主，没配置它时再跟据页面推导出地址

	String urlSave() default "";// 点击“保存”时调用的地址

	String urlQuery() default "";// 点击“查询”时调用的地址

	String urlDel() default "";// 点击“删除”时调用的地址

	/***
	 * 弹出新增和修改窗的样式。
	 * 
	 * @return
	 */
	String dialogStyle() default "width:800px;height:460px;";

	/**
	 * 转换器，示例：{",helmStatus,100,helm状态","updateBy,updateByName,100,创建者"}
	 * 每个元素格式如下：原始列名（全部行为*）,转换后的列名,grid上显示的宽度,grid上显示的标题
	 * 上面第一个元素解析：表示把整行数据输入，输出的值的列名为helmstatus，在grid上显示100宽度，grid的列名显示helm状态
	 * 
	 * @return
	 */
	String[] convert() default {};

}
