/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant.dbType;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.BitSet;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.PageElement;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.ArrayUtils;

public enum BinlogType {
    DECIMAL(0, 3, new String[0], (Type)((Object)BigDecimal.class), PageElement.NumberBox, new String[]{"DECIMAL"}),
    TINY(1, -6, new String[]{"tinyint"}, (Type)((Object)Short.class), PageElement.NumberIncrement, new String[]{"BOOLEAN", "TINYINT"}),
    SHORT(2, 5, new String[]{"smallint"}, (Type)((Object)Short.class), PageElement.NumberIncrement, new String[]{"SMALLINT"}),
    LONG(3, 4, new String[]{"int", "integer(int)"}, (Type)((Object)Integer.class), PageElement.NumberIncrement, new String[]{"INT"}),
    FLOAT(4, 6, new String[]{"float"}, (Type)((Object)Float.class), PageElement.NumberIncrement, new String[]{"FLOAT"}),
    DOUBLE(5, 8, new String[]{"real(double)", "double"}, (Type)((Object)Double.class), PageElement.NumberBox, new String[]{"DOUBLE"}),
    NULL(6, 0, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    TIMESTAMP(7, 93, new String[0], (Type)((Object)Date.class), PageElement.Calendar, new String[0]),
    LONGLONG(8, -5, new String[]{"bigint"}, (Type)((Object)Long.class), PageElement.NumberBox, new String[]{"BIGINT"}),
    INT24(9, 4, new String[]{"mediumint"}, (Type)((Object)Integer.class), PageElement.NumberBox, new String[0]),
    DATE(10, 91, new String[]{"date"}, (Type)((Object)Date.class), PageElement.Calendar, new String[]{"DATE"}),
    TIME(11, 92, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[]{"TIME"}),
    DATETIME(12, 91, new String[0], (Type)((Object)Date.class), PageElement.Calendar, new String[0]),
    YEAR(13, 12, new String[]{"year"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    NEWDATE(14, 12, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    VARCHAR(15, 12, new String[]{"varchar", "varbinary", "varchar(8000)", "tinytext", "text", "mediumtext", "longtext"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[]{"CHAR", "VARCHAR", "STRING"}),
    BIT(16, -7, new String[]{"bit"}, (Type)((Object)BitSet.class), PageElement.ValidateBox, new String[0]),
    TIMESTAMP2(17, 93, new String[]{"timestamp"}, (Type)((Object)Long.class), PageElement.NumberIncrement, new String[]{"TIMESTAMP", "TIMESTAMP WITH LOCAL TIME ZONE"}),
    DATETIME2(18, 91, new String[]{"datetime"}, (Type)((Object)Date.class), PageElement.Calendar, new String[0]),
    TIME2(19, 92, new String[]{"time"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    JSON(245, 12, new String[]{"json"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    NEWDECIMAL(246, 3, new String[]{"decimal", "numeric(decimal)"}, (Type)((Object)BigDecimal.class), PageElement.NumberBox, new String[0]),
    ENUM(247, 12, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    SET(248, 12, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    TINY_BLOB(249, 2004, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    MEDIUM_BLOB(250, 2004, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    LONG_BLOB(251, 2004, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    BLOB(252, 2004, new String[]{"tinyblob", "blob", "mediumblob", "longblob"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[]{"BINARY", "VARBINARY", "BYTES"}),
    VAR_STRING(253, 12, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    STRING(254, 12, new String[]{"char", "enum('e3','e2','e1')", "set('s1','s3','s2')", "binary"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    GEOMETRY(255, 12, new String[]{"point", "linestring", "polygon", "geometry", "multipoint", "multilinestring", "multipolygon", "geometrycollection"}, (Type)((Object)String.class), PageElement.ValidateBox, new String[0]),
    UNRECOGNIZED(-1, 12, new String[0], (Type)((Object)String.class), PageElement.ValidateBox, new String[0]);

    private final int value;
    private final int types;
    private final String[] mysqlTypes;
    private final Type javaType;
    private final PageElement pageElement;
    private final String[] flinkLogicalTypes;
    private String[] strType = new String[]{"java.lang.String", "java.util.Date", "java.sql.Date"};

    public String[] getFlinkLogicalTypes() {
        return this.flinkLogicalTypes;
    }

    public PageElement getPageElement() {
        return this.pageElement;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public int getValue() {
        return this.value;
    }

    private BinlogType(int value, int types, String[] mysqlTypes, Type javaType, PageElement pageElement, String[] flinkLogicalTypes) {
        this.value = value;
        this.types = types;
        this.mysqlTypes = mysqlTypes;
        this.javaType = javaType;
        this.pageElement = pageElement;
        this.flinkLogicalTypes = flinkLogicalTypes;
    }

    public static BinlogType getByName(String mysqlType) {
        if (StringUtil.isNull(mysqlType)) {
            return UNRECOGNIZED;
        }
        for (BinlogType ele : BinlogType.values()) {
            if (!ArrayUtils.contains((Object[])ele.getMysqlTypes(), (Object)mysqlType)) continue;
            return ele;
        }
        return UNRECOGNIZED;
    }

    public static BinlogType getByFlinkLogicalType(String flinkLogicalType) {
        if (StringUtil.isNull(flinkLogicalType)) {
            return UNRECOGNIZED;
        }
        for (BinlogType ele : BinlogType.values()) {
            if (!ArrayUtils.contains((Object[])ele.getFlinkLogicalTypes(), (Object)flinkLogicalType)) continue;
            return ele;
        }
        return UNRECOGNIZED;
    }

    public static BinlogType getByValue(int value) {
        if (value < 0) {
            return UNRECOGNIZED;
        }
        for (BinlogType ele : BinlogType.values()) {
            if (value != ele.getValue()) continue;
            return ele;
        }
        return UNRECOGNIZED;
    }

    public String getSqlStr(String values) {
        if (StringUtil.isNull(values)) {
            return "";
        }
        if (ArrayUtils.contains((Object[])this.strType, (Object)this.getJavaType().getTypeName())) {
            Object[] valueAry = values.split(",", 0);
            String arrayJoin = CollectionUtil.arrayJoin(valueAry, "','");
            return String.format("'%s'", arrayJoin);
        }
        return values;
    }

    public static <T extends Serializable> T getValue(BinlogType columnType, String value) {
        Object retobj = null;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case DECIMAL: 
            case NEWDECIMAL: {
                retobj = new BigDecimal(value);
                break;
            }
            case GEOMETRY: {
                try {
                    retobj = Base64.decodeBase64((String)value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case YEAR: {
                try {
                    retobj = Integer.valueOf(value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case DATE: {
                retobj = DateUtil.objToDate(value);
                break;
            }
            case TIMESTAMP2: 
            case DATETIME2: {
                retobj = Timestamp.valueOf(value);
                break;
            }
            default: {
                retobj = value;
            }
        }
        return (T)retobj;
    }

    public static <T extends Serializable> T getValueBuildSql(BinlogType columnType, String value) {
        Object retobj = null;
        switch (columnType) {
            case LONGLONG: {
                retobj = Long.valueOf(value);
                break;
            }
            case BIT: 
            case TINY: 
            case SHORT: 
            case INT24: 
            case LONG: 
            case ENUM: 
            case SET: {
                retobj = Integer.valueOf(value);
                break;
            }
            case FLOAT: {
                retobj = Float.valueOf(value);
                break;
            }
            case DOUBLE: {
                retobj = Double.valueOf(value);
                break;
            }
            case DECIMAL: 
            case NEWDECIMAL: {
                retobj = new BigDecimal(value);
                break;
            }
            case GEOMETRY: {
                try {
                    retobj = Base64.decodeBase64((String)value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            case YEAR: {
                try {
                    retobj = Integer.valueOf(value);
                }
                catch (Exception e) {
                    retobj = value;
                }
                break;
            }
            default: {
                String ret = "'" + value + "'";
                retobj = ret.replaceAll("\\\\", "");
            }
        }
        return (T)retobj;
    }

    public static <T extends Serializable> T getDateDefaultValue(BinlogType columnType) {
        String retobj = "";
        switch (columnType) {
            case DATE: 
            case TIMESTAMP2: 
            case DATETIME2: {
                retobj = "1970-01-01 00:00:00";
                break;
            }
        }
        return (T)retobj;
    }

    public String[] getMysqlTypes() {
        return this.mysqlTypes;
    }

    public int getTypes() {
        return this.types;
    }
}

