/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.wicp.tams.common.constant.MiddlewareOption;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum Middleware implements IEnumCombobox
{
    no("\u4e0d\u8bbe\u7f6e\u503c", new String[0], new MiddlewareOption[0]),
    mysql("mysql\u6570\u636e\u5e93", new String[]{"flinkcatalogmeta", "jdbctype", "duckularule"}, new MiddlewareOption[]{MiddlewareOption.connector, MiddlewareOption.url, MiddlewareOption.tableName, MiddlewareOption.username, MiddlewareOption.password}),
    es("es\u641c\u7d22", new String[]{"duckularule"}, new MiddlewareOption[0]),
    sqlserver("sqlserver\u6570\u636e\u5e93", new String[]{"duckularule"}, new MiddlewareOption[0]),
    http("http\u670d\u52a1\u5668", new String[]{"duckularule"}, new MiddlewareOption[0]),
    logger("logger\u65e5\u5fd7", new String[]{"duckularule"}, new MiddlewareOption[0]),
    kafka("kafka", new String[]{"flinkcatalogmeta", "duckularule"}, new MiddlewareOption[]{MiddlewareOption.connector, MiddlewareOption.topic, MiddlewareOption.kafka_servers, MiddlewareOption.kafka_groupid, MiddlewareOption.format, MiddlewareOption.kafka_scan_mode}),
    upsertkafka("upsert-kafka", new String[]{"flinkcatalogmeta"}, new MiddlewareOption[]{MiddlewareOption.connector, MiddlewareOption.topic, MiddlewareOption.kafka_servers, MiddlewareOption.keyformat, MiddlewareOption.valueformat}),
    duckula("binlog\u76d1\u542c", new String[]{"flinkcatalogmeta", "jdbctype"}, new MiddlewareOption[]{MiddlewareOption.db, MiddlewareOption.tb, MiddlewareOption.host, MiddlewareOption.username, MiddlewareOption.password, MiddlewareOption.port, MiddlewareOption.fieldFormart, MiddlewareOption.cdc, MiddlewareOption.addColNameType, MiddlewareOption.updateColName}),
    doris("doris\u6570\u636e\u5e93", new String[]{"flinkcatalogmeta", "duckularule"}, new MiddlewareOption[]{MiddlewareOption.connector, MiddlewareOption.fenodes, MiddlewareOption.table_identifier, MiddlewareOption.username, MiddlewareOption.password}),
    redis("redis", new String[]{"flinkcatalogmeta", "duckularule"}, new MiddlewareOption[]{MiddlewareOption.connector, MiddlewareOption.host, MiddlewareOption.port, MiddlewareOption.password, MiddlewareOption.groupid, MiddlewareOption.searchkeyprefix}),
    kudu("kudu\u6570\u636e\u5e93", new String[]{"flinkcatalogmeta", "duckularule"}, new MiddlewareOption[0]);

    private final String desc;
    private final String[] groups;
    private final MiddlewareOption[] flinkOptions;

    public String buildFlinkOpt(Map<String, String> keymap) {
        if (MapUtils.isEmpty(keymap)) {
            return "";
        }
        HashMap<MiddlewareOption, String> keymaps = new HashMap<MiddlewareOption, String>();
        for (MiddlewareOption flinkOption : this.flinkOptions) {
            if (!keymap.containsKey(flinkOption.name())) continue;
            keymaps.put(flinkOption, keymap.get(flinkOption.name()));
        }
        return this.buildFlinkOptStr(keymaps);
    }

    public String buildFlinkOptStr(Map<MiddlewareOption, String> keymap) {
        if (this == no || MapUtils.isEmpty(keymap)) {
            return "";
        }
        String optmain = "";
        StringBuffer buf = new StringBuffer();
        for (MiddlewareOption middlewareConfOption : keymap.keySet()) {
            if (!ArrayUtils.contains((Object[])this.flinkOptions, (Object)middlewareConfOption)) continue;
            buf.append(String.format(",'%s' = '%s'", middlewareConfOption.getNameUse(), keymap.get(middlewareConfOption)));
        }
        optmain = buf.length() > 0 ? buf.substring(1) : "";
        return String.format("WITH (%s)", optmain);
    }

    public static JSONObject convertJson(Map<MiddlewareOption, String> keymap) {
        JSONObject retobj = new JSONObject();
        if (MapUtils.isEmpty(keymap)) {
            return retobj;
        }
        for (MiddlewareOption middlewareOption : keymap.keySet()) {
            retobj.put(middlewareOption.getNameUse(), (Object)keymap.get(middlewareOption));
        }
        return retobj;
    }

    private static String convertOtherJson(Map<MiddlewareOption, String> otherOptmap) {
        JSONObject retobj = new JSONObject();
        retobj.put("total", (Object)otherOptmap.size());
        JSONArray rows = new JSONArray();
        for (MiddlewareOption middlewareOption : otherOptmap.keySet()) {
            JSONObject temp = new JSONObject();
            temp.put("editor", (Object)"text");
            temp.put("name", (Object)middlewareOption.name());
            temp.put("value", (Object)otherOptmap.get(middlewareOption));
            temp.put("nameUse", (Object)middlewareOption.getNameUse());
            temp.put("desc", (Object)middlewareOption.getDesc());
            rows.add((Object)temp);
        }
        retobj.put("rows", (Object)rows);
        String jsonString = JSONObject.toJSONString((Object)retobj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes});
        return jsonString;
    }

    public static Pair<String, String> proOptStr(Map<MiddlewareOption, String> allOps, MiddlewareOption ... otherOpt) {
        HashMap<MiddlewareOption, String> allOpsMap;
        HashMap<MiddlewareOption, String> otherOpsMap = new HashMap<MiddlewareOption, String>();
        HashMap<MiddlewareOption, String> hashMap = allOpsMap = MapUtils.isEmpty(allOps) ? new HashMap<MiddlewareOption, String>() : allOps;
        if (ArrayUtils.isNotEmpty((Object[])otherOpt) && MapUtils.isNotEmpty(allOpsMap)) {
            for (MiddlewareOption key : otherOpt) {
                if (!allOpsMap.containsKey(key)) continue;
                otherOpsMap.put(key, (String)allOpsMap.get(key));
            }
        }
        String allOpt = JSONObject.toJSONString((Object)Middleware.convertJson(allOpsMap), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes});
        String otherJson = Middleware.convertOtherJson(otherOpsMap);
        return Pair.of((Object)allOpt, (Object)otherJson);
    }

    @Override
    public String[] getGroups() {
        return this.groups;
    }

    private Middleware(String desc, String[] groups, MiddlewareOption[] flinkOptions) {
        this.desc = desc;
        this.groups = groups;
        this.flinkOptions = flinkOptions;
    }

    public static Middleware[] getMiddleTypeByGroup(String ... groups) {
        Middleware[] allTypes = Middleware.values();
        if (ArrayUtils.isEmpty((Object[])groups)) {
            return allTypes;
        }
        HashSet<Middleware> retset = new HashSet<Middleware>();
        for (String group : groups) {
            for (Middleware middlewareType : allTypes) {
                if (!ArrayUtils.contains((Object[])middlewareType.getGroups(), (Object)group)) continue;
                retset.add(middlewareType);
            }
        }
        return retset.toArray(new Middleware[retset.size()]);
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDesc_zh() {
        return this.desc;
    }

    @Override
    public String getDesc_en() {
        return this.name();
    }

    public MiddlewareOption[] getFlinkOptions() {
        return this.flinkOptions;
    }

    public static Middleware find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (Middleware ele : Middleware.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return null;
    }
}

