/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public enum DrdsPattern implements IEnumCombobox
{
    no("\u4e0d\u5206\u5e93\u4e0d\u5206\u8868", "^%s$", "^%s$"),
    db("\u53ea\u5206\u5e93\u4e0d\u5206\u8868", "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$", "^%s_[0-9a-zA-Z]{4}"),
    db_equaltb("\u53ea\u5206\u5e93\u4e0d\u5206\u8868(\u8868\u540d\u76f8\u540c\u5e93\u540d\u4e0d\u540c)", "", ""),
    dbtb("\u5373\u5206\u5e93\u4e5f\u5206\u8868", "^%s_[0-9a-zA-Z]{4}_[0-9]{2,}$", "%s_[0-9a-zA-Z]{4}_[0-9]{2,}$");

    private final String desc;
    private final String dbPatternFormat;
    private final String tbPatternFormat;

    private DrdsPattern(String desc, String dbPatternFormat, String tbPatternFormat) {
        this.desc = desc;
        this.dbPatternFormat = dbPatternFormat;
        this.tbPatternFormat = tbPatternFormat;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getDesc_zh() {
        return this.desc;
    }

    public String getRootDb(String oriDb) {
        Pattern dbPattern = Pattern.compile(this.getDbPatternFormat());
        Matcher m = dbPattern.matcher(oriDb);
        String rootstr = m.find() ? m.group(1) : null;
        return rootstr;
    }

    public String getRootTb(String oriTb) {
        Pattern dbPattern = Pattern.compile(this.getTbPatternFormat());
        Matcher m = dbPattern.matcher(oriTb);
        String rootstr = m.find() ? m.group(1) : null;
        return rootstr;
    }

    public String getTargetTb(String pre, Pair<String, String> oriDbtb) {
        String targetTb = null;
        switch (this) {
            case no: {
                targetTb = StringUtil.isNull(pre) ? String.format("%s_%s", oriDbtb.getLeft(), oriDbtb.getRight()) : String.format("%s_%s_%s", pre, oriDbtb.getLeft(), oriDbtb.getRight());
                break;
            }
            case db: 
            case db_equaltb: 
            case dbtb: {
                targetTb = StringUtil.isNull(pre) ? String.format("%s", this.getRootDb((String)oriDbtb.getRight())) : String.format("%s_%s", pre, this.getRootDb((String)oriDbtb.getRight()));
            }
        }
        return targetTb;
    }

    public boolean isSameGroup(Pair<String, String> standardDbtb, Pair<String, String> contrastDbtb) {
        boolean isSame = false;
        switch (this) {
            case no: {
                isSame = ((String)standardDbtb.getLeft()).equals(contrastDbtb.getLeft()) && ((String)standardDbtb.getRight()).equalsIgnoreCase((String)contrastDbtb.getRight());
                break;
            }
            case db_equaltb: {
                isSame = ((String)standardDbtb.getRight()).equalsIgnoreCase((String)contrastDbtb.getRight());
                break;
            }
            default: {
                String rootDb1 = this.getRootDb((String)standardDbtb.getLeft());
                String rootTb1 = this.getRootTb((String)standardDbtb.getRight());
                String rootDb2 = this.getRootDb((String)contrastDbtb.getLeft());
                String rootTb2 = this.getRootTb((String)contrastDbtb.getRight());
                isSame = rootDb1 != null && rootDb2 != null && rootDb1.equals(rootDb2) && rootTb1 != null && rootTb2 != null && rootTb1.equals(rootTb2);
            }
        }
        return isSame;
    }

    @Override
    public String getDesc_en() {
        return this.name();
    }

    public static DrdsPattern find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return no;
        }
        for (DrdsPattern ele : DrdsPattern.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return no;
    }

    public String getDbPatternFormat() {
        return this.dbPatternFormat;
    }

    public String getTbPatternFormat() {
        return this.tbPatternFormat;
    }
}

