/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.sql.Connection;
import java.util.List;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.beans.JdbcBean;
import net.wicp.tams.common.constant.StrPattern;
import org.apache.commons.lang3.ArrayUtils;

public enum DbType {
    mysql("com.mysql.jdbc.Driver", 3306, "jdbc:mysql://%s:%s", "%s/%s", "zeroDateTimeBehavior=convertToNull&useUnicode=true&characterEncoding=utf8&autoReconnect=true&failOverReadOnly=false&verifyServerCertificate=false&useSSL=false&allowPublicKeyRetrieval=true", "PRIMARY KEY (`%s`) USING BTREE", "^jdbc:mysql://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$"),
    doris("com.mysql.jdbc.Driver", 3306, "jdbc:mysql://%s:%s", "%s/%s", "zeroDateTimeBehavior=convertToNull&useUnicode=true&characterEncoding=utf8&autoReconnect=true&failOverReadOnly=false&verifyServerCertificate=false&useSSL=false&allowPublicKeyRetrieval=true", "", "^jdbc:mysql://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$"),
    impala("com.cloudera.impala.jdbc41.Driver", 21050, "jdbc:impala://%s:%s", "%s/%s", "", "PRIMARY KEY (`%s`)", "^jdbc:impala://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$"),
    sqlserver("net.sourceforge.jtds.jdbc.Driver", 1433, "jdbc:jtds:sqlserver://%s:%s", "%s;DatabaseName=%s", "", "PRIMARY KEY (%s)", "^jdbc:jtds:sqlserver://([\\w\\.\\-\\_]+):([0-9]{4,5})(/([\\w]+))(\\?([\\w\\.\\-\\_\\&\\=]*))?$");

    private final String formatestr;
    private final String formatedbstr;
    private final String defaultparam;
    private final String createTableKeystr;
    private final String jdbcDriver;
    private final int defaultPort;
    private final String urlPattern;

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public JdbcBean getJdbcBeanByUrl(String url) {
        Object[] group = StrPattern.group(this.urlPattern, url);
        if (ArrayUtils.isEmpty((Object[])group) || group.length < 3) {
            return null;
        }
        JdbcBean retbean = new JdbcBean();
        retbean.setUrl(url);
        retbean.setHost((String)group[1]);
        retbean.setPort(Integer.parseInt((String)group[2]));
        switch (group.length) {
            case 5: {
                retbean.setUrlparam((String)group[4]);
                break;
            }
            case 7: {
                retbean.setDefaultdb((String)group[4]);
                retbean.setUrlparam((String)group[6]);
                break;
            }
        }
        return retbean;
    }

    public boolean testConn(Connection conn) {
        Result rs = null;
        switch (this) {
            case mysql: {
                rs = JdbcAssit.execSql(conn, "SELECT 1 FROM DUAL");
                break;
            }
            case sqlserver: {
                rs = JdbcAssit.execSql(conn, "select  getdate()");
                break;
            }
        }
        return rs != null;
    }

    public String getCreateKeySql(List<String> keys) {
        if (StringUtil.isNull(this.createTableKeystr)) {
            return "";
        }
        String listJoinstr = CollectionUtil.listJoin(keys, "`,`");
        return String.format(this.createTableKeystr, listJoinstr);
    }

    public String getDefaultparam() {
        return this.defaultparam;
    }

    public String getFormatedbstr() {
        return this.formatedbstr;
    }

    public String getFormatestr() {
        return this.formatestr;
    }

    public String geturl(String sshLocalhostprot, String host, int port, String defaultdb, String urlparam) {
        String url;
        String temp = this.getFormatestr();
        if (StringUtil.isNotNull(sshLocalhostprot)) {
            SshAssist.ssh(Integer.parseInt(sshLocalhostprot), host, port);
            url = String.format(temp, "localhost", sshLocalhostprot);
        } else {
            url = String.format(temp, host, port);
        }
        if (StringUtil.isNotNull(defaultdb)) {
            url = String.format(this.getFormatedbstr(), url, defaultdb);
        }
        url = StringUtil.isNotNull(urlparam) ? url + "?" + urlparam : url + (StringUtil.isNull(this.getDefaultparam()) ? "" : "?" + StringUtil.hasNull(this.getDefaultparam()));
        return url;
    }

    public String geturl(String host, int port) {
        return this.geturl(null, host, port, null, null);
    }

    public String geturl(String host) {
        return this.geturl(host, this.defaultPort);
    }

    public String geturl(String host, int port, String defaultdb) {
        return this.geturl(null, host, port, defaultdb, null);
    }

    public String geturl(String host, int port, String defaultdb, String urlparam) {
        return this.geturl(null, host, port, defaultdb, urlparam);
    }

    private DbType(String jdbcDriver, int defaultPort, String formatestr, String formatedbstr, String defaultparam, String createTableKeystr, String urlPattern) {
        this.formatestr = formatestr;
        this.formatedbstr = formatedbstr;
        this.defaultparam = defaultparam;
        this.createTableKeystr = createTableKeystr;
        this.jdbcDriver = jdbcDriver;
        this.defaultPort = defaultPort;
        this.urlPattern = urlPattern;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }
}

