/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.beans;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.wicp.tams.common.callback.IProcess;

public class StreamCopyBean
implements IProcess {
    private InputStream thatIn;
    private OutputStream thatOut;
    private OutputStream thatError;
    private InputStream thisIn;
    private OutputStream thisOut;
    private InputStream thisError;

    public static StreamCopyBean procToSystem(Process proc) {
        StreamCopyBean retbean = new StreamCopyBean();
        retbean.setThisIn(proc.getInputStream());
        retbean.setThisOut(proc.getOutputStream());
        retbean.setThisError(proc.getErrorStream());
        retbean.setThatIn(System.in);
        retbean.setThatOut(System.out);
        retbean.setThatError(System.err);
        return retbean;
    }

    public void copyOutputStream() {
        try {
            ByteStreams.copy((InputStream)this.thatIn, (OutputStream)this.thisOut);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void copyInputStream() {
        try {
            ByteStreams.copy((InputStream)this.thisIn, (OutputStream)this.thatOut);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void copyErrorStream() {
        try {
            ByteStreams.copy((InputStream)this.thisError, (OutputStream)this.thatError);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void doInputStream(InputStream inputStream) {
        this.copyInputStream();
    }

    @Override
    public void doOutputStream(OutputStream outputStream) {
        this.copyOutputStream();
    }

    @Override
    public void doErrorStream(InputStream errorStream) {
        this.copyErrorStream();
    }

    public InputStream getThatIn() {
        return this.thatIn;
    }

    public OutputStream getThatOut() {
        return this.thatOut;
    }

    public OutputStream getThatError() {
        return this.thatError;
    }

    public InputStream getThisIn() {
        return this.thisIn;
    }

    public OutputStream getThisOut() {
        return this.thisOut;
    }

    public InputStream getThisError() {
        return this.thisError;
    }

    public void setThatIn(InputStream thatIn) {
        this.thatIn = thatIn;
    }

    public void setThatOut(OutputStream thatOut) {
        this.thatOut = thatOut;
    }

    public void setThatError(OutputStream thatError) {
        this.thatError = thatError;
    }

    public void setThisIn(InputStream thisIn) {
        this.thisIn = thisIn;
    }

    public void setThisOut(OutputStream thisOut) {
        this.thisOut = thisOut;
    }

    public void setThisError(InputStream thisError) {
        this.thisError = thisError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamCopyBean)) {
            return false;
        }
        StreamCopyBean other = (StreamCopyBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InputStream this$thatIn = this.getThatIn();
        InputStream other$thatIn = other.getThatIn();
        if (this$thatIn == null ? other$thatIn != null : !this$thatIn.equals(other$thatIn)) {
            return false;
        }
        OutputStream this$thatOut = this.getThatOut();
        OutputStream other$thatOut = other.getThatOut();
        if (this$thatOut == null ? other$thatOut != null : !this$thatOut.equals(other$thatOut)) {
            return false;
        }
        OutputStream this$thatError = this.getThatError();
        OutputStream other$thatError = other.getThatError();
        if (this$thatError == null ? other$thatError != null : !this$thatError.equals(other$thatError)) {
            return false;
        }
        InputStream this$thisIn = this.getThisIn();
        InputStream other$thisIn = other.getThisIn();
        if (this$thisIn == null ? other$thisIn != null : !this$thisIn.equals(other$thisIn)) {
            return false;
        }
        OutputStream this$thisOut = this.getThisOut();
        OutputStream other$thisOut = other.getThisOut();
        if (this$thisOut == null ? other$thisOut != null : !this$thisOut.equals(other$thisOut)) {
            return false;
        }
        InputStream this$thisError = this.getThisError();
        InputStream other$thisError = other.getThisError();
        return !(this$thisError == null ? other$thisError != null : !this$thisError.equals(other$thisError));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamCopyBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InputStream $thatIn = this.getThatIn();
        result = result * 59 + ($thatIn == null ? 43 : $thatIn.hashCode());
        OutputStream $thatOut = this.getThatOut();
        result = result * 59 + ($thatOut == null ? 43 : $thatOut.hashCode());
        OutputStream $thatError = this.getThatError();
        result = result * 59 + ($thatError == null ? 43 : $thatError.hashCode());
        InputStream $thisIn = this.getThisIn();
        result = result * 59 + ($thisIn == null ? 43 : $thisIn.hashCode());
        OutputStream $thisOut = this.getThisOut();
        result = result * 59 + ($thisOut == null ? 43 : $thisOut.hashCode());
        InputStream $thisError = this.getThisError();
        result = result * 59 + ($thisError == null ? 43 : $thisError.hashCode());
        return result;
    }

    public String toString() {
        return "StreamCopyBean(thatIn=" + this.getThatIn() + ", thatOut=" + this.getThatOut() + ", thatError=" + this.getThatError() + ", thisIn=" + this.getThisIn() + ", thisOut=" + this.getThisOut() + ", thisError=" + this.getThisError() + ")";
    }
}

