/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcAssit {
    private static final Logger log = LoggerFactory.getLogger(JdbcAssit.class);

    public static ResultSet querySql(Connection conn, String sql) {
        Statement stmt = null;
        try {
            if (conn == null || conn.isClosed()) {
                return null;
            }
            stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            return rs;
        }
        catch (SQLException e) {
            log.error(String.format("\u67e5\u8be2sql\u51fa\u9519\uff0csql:[%s]", sql), (Throwable)e);
            return null;
        }
    }

    public static Result execSql(Connection conn, String sql) {
        Statement stmt = null;
        try {
            if (conn == null || conn.isClosed()) {
                return Result.getError("\u62ff\u4e0d\u5230\u8fde\u63a5");
            }
            stmt = conn.createStatement();
            stmt.execute(sql);
            return Result.getSuc();
        }
        catch (SQLException e) {
            String format = String.format("\u67e5\u8be2sql\u51fa\u9519\uff0csql:[%s]", sql);
            log.error(format, (Throwable)e);
            return Result.getError(format);
        }
    }

    public static void setPreParam(PreparedStatement stmt, BinlogType[] typeAry, boolean isQuery, Object ... queryParams) throws SQLException {
        if (stmt == null) {
            return;
        }
        int needparamscount = stmt.getParameterMetaData().getParameterCount();
        if (needparamscount == 0 && ArrayUtils.isEmpty((Object[])queryParams)) {
            return;
        }
        if (needparamscount != queryParams.length) {
            throw new SQLException(String.format("\u53c2\u6570\u7684\u4e2a\u6570\u4e0d\u5339\u914d\uff0c\u9700\u8981[%s]\u4e2a\u53c2\u6570\uff0c\u4f46\u4f20\u8fdb\u6765[%s]\u4e2a\u53c2\u6570", needparamscount, queryParams.length));
        }
        for (int i = 0; i < queryParams.length; ++i) {
            String valueStr;
            Object queryParam = queryParams[i];
            if (queryParam == null) {
                if (ArrayUtils.isEmpty((Object[])typeAry) || typeAry.length < i + 1) {
                    throw new SQLException(String.format("\u7b2c%s\u4e2a\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u6ca1\u6709\u4f20\u5165typeAry\u5374\u5b58\u5728null\u503c", i));
                }
                stmt.setNull(i + 1, typeAry[i].getTypes());
                continue;
            }
            if (queryParam instanceof String) {
                valueStr = String.valueOf(queryParam);
                if (isQuery) {
                    stmt.setString(i + 1, valueStr);
                    continue;
                }
                stmt.setBytes(i + 1, valueStr.getBytes());
                continue;
            }
            if (queryParam instanceof Integer) {
                stmt.setInt(i + 1, (Integer)queryParam);
                continue;
            }
            if (queryParam instanceof Timestamp) {
                stmt.setTimestamp(i + 1, (Timestamp)queryParam);
                continue;
            }
            if (queryParam instanceof java.util.Date) {
                stmt.setDate(i + 1, new Date(((java.util.Date)queryParam).getTime()));
                continue;
            }
            if (queryParam instanceof Long) {
                stmt.setLong(i + 1, (Long)queryParam);
                continue;
            }
            if (queryParam instanceof Double) {
                stmt.setDouble(i + 1, (Double)queryParam);
                continue;
            }
            if (queryParam instanceof Boolean) {
                stmt.setBoolean(i + 1, (Boolean)queryParam);
                continue;
            }
            if (queryParam instanceof byte[]) {
                stmt.setBlob(i + 1, StringUtil.convertInputStream((byte[])queryParam));
                continue;
            }
            if (queryParam instanceof BigDecimal) {
                stmt.setBigDecimal(i + 1, (BigDecimal)queryParam);
                continue;
            }
            valueStr = String.valueOf(queryParam);
            throw new SQLException(String.format("\u4e0d\u652f\u6301\u7684\u7c7b\u578b,\u53c2\u6570\u503c[%s]", valueStr));
        }
    }

    public static void setPreParam(PreparedStatement stmt, boolean isQuery, Object ... queryParams) throws SQLException {
        JdbcAssit.setPreParam(stmt, null, isQuery, queryParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> querySqlMap(Connection conn, String sql, boolean isConvertKey) {
        ResultSet rs = JdbcAssit.querySql(conn, sql);
        try {
            List<Map<String, String>> list = JdbcAssit.rsToMap(rs, isConvertKey);
            return list;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static List<Map<String, String>> querySqlMapPre(Connection conn, String sql, boolean isConvertKey, Object ... queryParams) {
        ResultSet rs = null;
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            JdbcAssit.setPreParam(stmt, true, queryParams);
            rs = stmt.executeQuery();
            List<Map<String, String>> list = JdbcAssit.rsToMap(rs, isConvertKey);
            return list;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u67e5\u8be2sql\u51fa\u9519,sql:" + sql);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void execSqlPre(Connection conn, String sql, Object ... queryParams) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(sql);
        String selectStr = StringUtil.trimSpace(sql).substring(0, 6);
        JdbcAssit.setPreParam(stmt, selectStr.equalsIgnoreCase("select"), queryParams);
        stmt.execute();
    }

    public static List<Map<String, String>> rsToMap(ResultSet rs, boolean isConvertKey) {
        ArrayList<Map<String, String>> retlist = new ArrayList<Map<String, String>>();
        try {
            int nums = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                HashMap<String, String> retmap = new HashMap<String, String>();
                for (int i = 0; i < nums; ++i) {
                    String colName = rs.getMetaData().getColumnLabel(i + 1);
                    String value = rs.getString(colName);
                    if (isConvertKey) {
                        retmap.put(StringUtil.convertStr(colName), value);
                        continue;
                    }
                    retmap.put(colName, value);
                }
                retlist.add(retmap);
            }
            return retlist;
        }
        catch (Exception e) {
            log.error("\u8f6c\u6362ResultSet\u51fa\u9519", (Throwable)e);
            return null;
        }
    }
}

