/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;

public class TamsURLClassLoader
extends URLClassLoader {
    private ClassLoader system;
    private String[] systemfilterary = StringUtil.isNull(Conf.get("common.apiext.classload.systemfilter")) ? new String[]{} : Conf.get("common.apiext.classload.systemfilter").split(",");
    private boolean childFirst = Conf.getBoolean("common.apiext.classload.child-first");

    public TamsURLClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.system = TamsURLClassLoader.getSystemClassLoader();
    }

    private boolean canFindFormSystem(String name) {
        for (String systemfilter : this.systemfilterary) {
            if (!name.startsWith(systemfilter)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.system != null && this.canFindFormSystem(name)) {
                try {
                    c = this.system.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                if (this.childFirst) {
                    try {
                        c = this.findClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        c = super.loadClass(name, resolve);
                    }
                } else {
                    try {
                        c = super.loadClass(name, resolve);
                    }
                    catch (ClassNotFoundException e) {
                        c = this.findClass(name);
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.system != null && this.canFindFormSystem(name)) {
            url = this.system.getResource(name);
        }
        if (url == null) {
            if (this.childFirst) {
                url = this.findResource(name);
                if (url == null) {
                    url = super.getResource(name);
                }
            } else {
                url = super.getResource(name);
                if (url == null) {
                    url = this.findResource(name);
                }
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ArrayList<URL> urls;
        block12: {
            Enumeration<URL> parentUrls;
            Enumeration<URL> localUrls;
            block11: {
                Enumeration<URL> systemUrls = null;
                if (this.system != null && this.canFindFormSystem(name)) {
                    systemUrls = this.system.getResources(name);
                }
                localUrls = this.findResources(name);
                parentUrls = null;
                if (this.getParent() != null) {
                    parentUrls = this.getParent().getResources(name);
                }
                urls = new ArrayList<URL>();
                if (systemUrls != null) {
                    while (systemUrls.hasMoreElements()) {
                        urls.add(systemUrls.nextElement());
                    }
                }
                if (!this.childFirst) break block11;
                if (localUrls != null) {
                    while (localUrls.hasMoreElements()) {
                        urls.add(localUrls.nextElement());
                    }
                }
                if (parentUrls == null) break block12;
                while (parentUrls.hasMoreElements()) {
                    urls.add(parentUrls.nextElement());
                }
                break block12;
            }
            if (parentUrls != null) {
                while (parentUrls.hasMoreElements()) {
                    urls.add(parentUrls.nextElement());
                }
            }
            if (localUrls != null) {
                while (localUrls.hasMoreElements()) {
                    urls.add(localUrls.nextElement());
                }
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> iter;
            {
                this.iter = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iter.next();
            }
        };
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

