/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.BasePath;
import net.wicp.tams.common.constant.Encoding;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.thread.ThreadPool;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOUtil {
    private static final Logger log = LoggerFactory.getLogger(IOUtil.class);
    private static String[] binSuffixs = new String[]{"png", "jpg", "gif", "ico", "eot", "svg", "ttf", "woff"};

    public static boolean isBinFile(String filename) {
        boolean ret = false;
        for (String binSuffix : binSuffixs) {
            if (!filename.endsWith("." + binSuffix)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static String slurp(InputStream in, Encoding oriEncoding) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.append(new String(b, 0, n, oriEncoding.getEncode()));
        }
        return out.toString();
    }

    public static String slurp(InputStream in) throws IOException {
        return IOUtil.slurp(in, Encoding.UTF8);
    }

    public static String slurpPathTypePath(String pathTypePath) {
        String path2 = PathType.getPath(pathTypePath, true);
        return IOUtil.slurp(path2);
    }

    public static String slurp(String filePath) {
        FileInputStream fileInputStream = null;
        try {
            String slurp;
            fileInputStream = new FileInputStream(new File(filePath));
            String string = slurp = IOUtil.slurp(fileInputStream);
            return string;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime(ExceptAll.Project_default, "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6587\u4ef6 " + filePath, e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] slurpbyte(InputStream in) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = in.read(buffer))) {
            output.write(buffer, 0, n);
        }
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fileToProperties(String filePath, Class classz) {
        Properties returnPro = new Properties();
        InputStream inputFile = null;
        try {
            inputFile = IOUtil.fileToInputStream(filePath, classz);
            returnPro.load(inputFile);
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6{}", (Object)filePath);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6{}\u9519\u8bef", (Object)filePath);
        }
        finally {
            if (inputFile != null) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u51fa\u9519");
                }
            }
        }
        return returnPro;
    }

    public static Properties StringToProperties(String propStr) {
        try {
            ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(propStr.getBytes("UTF-8"));
            Properties props = new Properties();
            props.load(tInputStringStream);
            return props;
        }
        catch (Exception ex) {
            log.error("string\u8f6c\u6362\u4e3aProperties\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties fileToProperties(File filePath) {
        Properties returnPro = new Properties();
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(filePath);
            returnPro.load(inputFile);
        }
        catch (FileNotFoundException e) {
            log.error("\u627e\u4e0d\u5230\u6587\u4ef6{}", (Object)filePath);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u5c5e\u6027\u6587\u4ef6{}\u9519\u8bef", (Object)filePath);
        }
        finally {
            if (inputFile != null) {
                try {
                    ((InputStream)inputFile).close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95ed\u6d41\u51fa\u9519");
                }
            }
        }
        return returnPro;
    }

    public static InputStream fileToInputStream(String filePath, Class classz) {
        InputStream inputFile = null;
        if (StringUtil.isNull(filePath)) {
            return null;
        }
        filePath = filePath.replace("\\", "/");
        log.info("--------filePath:{}-------------", (Object)filePath);
        if (classz != null) {
            inputFile = classz.getResourceAsStream(filePath);
            if (inputFile == null && !filePath.startsWith("/") && !filePath.startsWith("\\")) {
                inputFile = classz.getResourceAsStream("/" + filePath);
            }
        } else {
            inputFile = Thread.currentThread().getContextClassLoader().getResourceAsStream(filePath);
        }
        return inputFile;
    }

    public static List<Pair<String, InputStream>>[] findProps(String propFilePre, URL root, String rootDir, String jarpre, String ... firstConfs) {
        return IOUtil.findFiles(propFilePre, root, rootDir, jarpre, "properties", firstConfs);
    }

    public static List<Pair<String, InputStream>>[] findFiles(String propFilePre, URL root, String rootDir, String jarpre, String suffix, String ... firstConfs) {
        RegexFileFilter fileFilter;
        File dir;
        File[] files;
        ArrayList<Pair> firstlist = new ArrayList<Pair>();
        ArrayList<Pair> secondlist = new ArrayList<Pair>();
        String properPattern = String.format("^(BOOT-INF/classes/)?%s([a-zA-z0-9]-*){1,}\\.%s$", propFilePre, suffix);
        if ("jar".equals(root.getProtocol())) {
            try {
                Map<String, InputStream> is = IOUtil.getFilesFromJar(root.getPath(), StringUtil.hasNull(rootDir, "."), suffix);
                String fileDir = IOUtil.getCurFolder(Conf.class, false).getPath();
                File dir2 = new File(IOUtil.mergeFolderAndFilePath(fileDir, "/temp"));
                if (!dir2.exists()) {
                    dir2.mkdir();
                }
                for (String key : is.keySet()) {
                    if (key.contains("/" + jarpre) && key.contains(".jar")) {
                        String[] paths = key.split("/");
                        File newFile = new File(dir2, paths[paths.length - 1]);
                        log.info("newfile:{}", (Object)newFile.getPath());
                        if (!newFile.exists()) {
                            FileUtils.copyInputStreamToFile((InputStream)is.get(key), (File)newFile);
                        }
                        String filepathTrue = newFile.getPath().startsWith("file:") ? "jar:" + newFile.getPath() : "jar:file:" + newFile.getPath();
                        Map<String, InputStream> map2 = IOUtil.getFilesFromJar(filepathTrue, ".", suffix);
                        for (String key2 : map2.keySet()) {
                            if (!StrPattern.checkStrFormat(properPattern, key2)) continue;
                            firstlist.add(Pair.of((Object)key2, (Object)map2.get(key2)));
                        }
                        continue;
                    }
                    if (!StrPattern.checkStrFormat(properPattern, key)) continue;
                    firstlist.add(Pair.of((Object)key, (Object)is.get(key)));
                }
            }
            catch (Exception e) {
                log.error("\u52a0\u8f7dproperties\u9519\u8bef", (Throwable)e);
            }
        } else if ("file".equals(root.getProtocol()) && (files = (dir = new File(IOUtil.mergeFolderAndFilePath(root.getPath(), StringUtil.hasNull(rootDir, "")))).listFiles((FileFilter)(fileFilter = new RegexFileFilter(properPattern)))) != null) {
            for (File file : files) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    if (!ArrayUtils.contains((Object[])firstConfs, (Object)file.getName())) {
                        secondlist.add(Pair.of((Object)file.getName(), (Object)fileInputStream));
                        continue;
                    }
                    firstlist.add(Pair.of((Object)file.getName(), (Object)fileInputStream));
                }
                catch (FileNotFoundException e) {
                    log.error("\u8bfb\u6587\u4ef6\u9519\u8bef", (Throwable)e);
                }
            }
        }
        return new List[]{firstlist, secondlist};
    }

    public static Properties fileToProperties(String filePath) {
        return IOUtil.fileToProperties(filePath, null);
    }

    private static String mergeFolderAndFilePath(String folderPath, String fileName) {
        if (StringUtils.isBlank((CharSequence)folderPath) && StringUtils.isBlank((CharSequence)fileName)) {
            return "";
        }
        if (StringUtils.isBlank((CharSequence)folderPath)) {
            return fileName.replace("\\", "/");
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return folderPath.replace("\\", "/");
        }
        folderPath = folderPath.replace("\\", "/");
        fileName = fileName.replace("\\", "/");
        if (folderPath.endsWith("/")) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        if (fileName.startsWith("/")) {
            fileName = fileName.substring(1);
        }
        if (fileName.endsWith("/")) {
            fileName = fileName.substring(0, fileName.length() - 1);
        }
        return String.format("%s/%s", folderPath, fileName);
    }

    public static String mergeFolderAndFilePath(String folderPath, String ... paths) {
        if (ArrayUtils.isEmpty((Object[])paths)) {
            return folderPath;
        }
        String retstr = folderPath;
        for (String path : paths) {
            retstr = IOUtil.mergeFolderAndFilePath(retstr, path);
        }
        return retstr;
    }

    public static String getDirForFilePath(Class classStr, String filePath) {
        URL url = classStr.getResource(filePath);
        int lastIndex = url.getPath().lastIndexOf("/");
        if (lastIndex > 0) {
            return url.getPath().substring(0, lastIndex);
        }
        return null;
    }

    public static String getDirForCommonUtilFilePath(String filePath) {
        return IOUtil.getDirForFilePath(IOUtil.class, filePath);
    }

    public static long copyInToOut(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[1024];
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static void replaceFile(String oriPath, String destPath, Encoding oriEncoding, Encoding destEncoding, String ... replaceRule) throws IOException {
        String strs = FileUtils.readFileToString((File)new File(oriPath), (String)oriEncoding.getEncode());
        IOUtil.replaceFileByStr(strs, destPath, oriEncoding, destEncoding, replaceRule);
    }

    public static void replaceFileByStr(String oriContext, String destPath, Encoding oriEncoding, Encoding destEncoding, String ... replaceRule) throws IOException {
        if (ArrayUtils.isNotEmpty((Object[])replaceRule) && replaceRule.length >= 2) {
            for (int i = 0; i < replaceRule.length / 2; ++i) {
                oriContext = oriContext.replaceAll(replaceRule[2 * i], replaceRule[2 * i + 1]);
            }
        }
        File destfile = new File(destPath);
        FileUtils.writeStringToFile((File)destfile, (String)oriContext, (String)destEncoding.getEncode());
    }

    public static void replaceFileByStr(String oriContext, String destPath, String ... replaceRule) throws IOException {
        IOUtil.replaceFileByStr(oriContext, destPath, Encoding.UTF8, Encoding.UTF8, replaceRule);
    }

    public static void replaceFileByStr(String oriContext, BasePath basePath, String relaPath, String ... replaceRule) throws IOException {
        String path = IOUtil.mergeFolderAndFilePath(basePath.getPath(), relaPath);
        IOUtil.replaceFileByStr(oriContext, path, replaceRule);
    }

    public static void replaceFile(String oriPath, String destPath, String ... replaceRule) throws IOException {
        IOUtil.replaceFile(oriPath, destPath, Encoding.UTF8, Encoding.UTF8, replaceRule);
    }

    public static void replaceDir(String oriPath, String destPath, String ... replaceRule) throws IOException {
        Collection files = FileUtils.listFiles((File)new File(oriPath), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        for (File file : files) {
            String filepath = file.getPath().replace("\\", "/");
            filepath = filepath.charAt(0) == '/' ? filepath : "/" + filepath;
            String newPath = filepath.replace(oriPath, destPath);
            if (!file.isDirectory()) {
                IOUtil.replaceFile(file.getPath(), newPath, Encoding.UTF8, Encoding.UTF8, replaceRule);
                continue;
            }
            FileUtils.copyFile((File)file, (File)new File(newPath));
        }
    }

    public static Map<String, InputStream> getFilesFromJar(String jarUrlStr, String dirPath, String ... suffix) throws Exception {
        int lastIndex;
        JarFile jarFile = IOUtil.jarRead(jarUrlStr);
        Enumeration<JarEntry> jarEntrys = jarFile.entries();
        HashMap<String, InputStream> retobj = new HashMap<String, InputStream>();
        if (jarEntrys == null || !jarEntrys.hasMoreElements()) {
            return retobj;
        }
        int firstIndex = jarUrlStr.indexOf(".jar!/");
        int n = lastIndex = jarUrlStr.endsWith(".jar") ? jarUrlStr.lastIndexOf(".jar") : jarUrlStr.lastIndexOf(".jar!/");
        if (firstIndex == lastIndex) {
            int n2 = lastIndex = jarUrlStr.endsWith(".jar") ? jarUrlStr.lastIndexOf(".jar") : jarUrlStr.lastIndexOf(".jar!");
        }
        while (jarEntrys.hasMoreElements()) {
            JarEntry entry = jarEntrys.nextElement();
            String name = entry.getName();
            boolean need = false;
            if (firstIndex != lastIndex && name.endsWith(".jar")) {
                need = true;
            } else if ((".".equals(dirPath) && (name.indexOf("/") == -1 || name.replace("BOOT-INF/classes/", "").indexOf("/") == -1) || name.startsWith(dirPath)) && !entry.isDirectory()) {
                if (ArrayUtils.isNotEmpty((Object[])suffix)) {
                    int lastindex = name.lastIndexOf(".");
                    if (lastindex > 0 && ArrayUtils.contains((Object[])suffix, (Object)name.substring(lastindex + 1))) {
                        need = true;
                    }
                } else {
                    need = true;
                }
            }
            if (!need) continue;
            InputStream is = jarFile.getInputStream(entry);
            retobj.put(name, is);
        }
        return retobj;
    }

    public static JarFile jarRead(String jarUrlStr) throws MalformedURLException, IOException {
        jarUrlStr = jarUrlStr.startsWith("jar:") ? jarUrlStr : String.format("jar:%s", jarUrlStr);
        String jarPath = jarUrlStr.indexOf("!/") > 0 ? jarUrlStr.substring(0, jarUrlStr.indexOf("!/") + 2) : jarUrlStr + "!/";
        URL jarURL = new URL(jarPath);
        JarURLConnection jarCon = (JarURLConnection)jarURL.openConnection();
        JarFile jarFile = jarCon.getJarFile();
        return jarFile;
    }

    public static List<String> getClassNameFromJar(String jarUrlStr, String filtDirPath) throws Exception {
        JarFile jarFile = IOUtil.jarRead(jarUrlStr);
        Enumeration<JarEntry> jarEntrys = jarFile.entries();
        ArrayList<String> retlist = new ArrayList<String>();
        if (jarEntrys == null || !jarEntrys.hasMoreElements()) {
            return retlist;
        }
        while (jarEntrys.hasMoreElements()) {
            JarEntry entry = jarEntrys.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class") || entry.isDirectory() || !StringUtil.isNull(filtDirPath) && !name.startsWith(filtDirPath)) continue;
            String addstr = name.substring(0, name.length() - 6);
            retlist.add(addstr.replace("/", "."));
        }
        return retlist;
    }

    public static List<String> getClassNameFromDir(String classDir, String packageName) {
        String classDirTrue = classDir.replace("\\", "/");
        if (StringUtil.isNotNull(packageName)) {
            classDirTrue = IOUtil.mergeFolderAndFilePath(classDirTrue, packageName.replace(".", "/"));
        }
        Collection files = FileUtils.listFiles((File)new File(classDirTrue), (String[])new String[]{"class"}, (boolean)true);
        ArrayList<String> retlist = new ArrayList<String>();
        for (File file : files) {
            String filepathTemp = file.getPath().replace("\\", "/");
            if ((filepathTemp = filepathTemp.substring(0, filepathTemp.length() - 6).replace(classDir.replace("\\", "/"), "")).startsWith("/")) {
                filepathTemp = filepathTemp.substring(1);
            }
            filepathTemp = filepathTemp.replace("/", ".");
            retlist.add(filepathTemp);
        }
        return retlist;
    }

    public static List<String> getSubTypeFromJar(String jarUrlStr, String dirPath, String parentClassName, ClassPool pool) throws Exception {
        List<String> allClassName = IOUtil.getClassNameFromJar(jarUrlStr, dirPath);
        IOUtil.subClassFilter(allClassName, parentClassName, pool);
        return allClassName;
    }

    public static List<String> getSubTypeFromDir(String classDir, String packageName, String parentClassName, ClassPool pool) throws Exception {
        List<String> allClassName = IOUtil.getClassNameFromDir(classDir, packageName);
        IOUtil.subClassFilter(allClassName, parentClassName, pool);
        return allClassName;
    }

    public static List<String> getSubType(String filepath, String packageName, String parentClassName, ClassPool pool) throws Exception {
        File tempfile = new File(filepath);
        if (tempfile.isDirectory()) {
            return IOUtil.getSubTypeFromDir(filepath, packageName, parentClassName, pool);
        }
        return IOUtil.getSubTypeFromJar("jar:file:" + (filepath.charAt(0) == '/' ? "" : "/") + filepath, packageName, parentClassName, pool);
    }

    public static void subClassFilter(List<String> allClassName, String parentClassName, ClassPool pool) throws NotFoundException {
        final ClassPool pooltrue = pool != null ? pool : ClassPool.getDefault();
        final CtClass superclassTrue = pool.get(parentClassName);
        CollectionUtils.filter(allClassName, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                try {
                    CtClass ctClass = pooltrue.get(String.valueOf(object));
                    if (ctClass.subtypeOf(superclassTrue)) {
                        return true;
                    }
                }
                catch (Exception e) {
                    return false;
                }
                return false;
            }
        });
    }

    public static boolean isSubClass(String subClass, String parentClassName, ClassPool pool) throws NotFoundException {
        ClassPool pooltrue = pool != null ? pool : ClassPool.getDefault();
        CtClass superclassTrue = pool.get(parentClassName);
        CtClass ctClass = pooltrue.get(subClass);
        return ctClass.subtypeOf(superclassTrue);
    }

    public static Set<String> findSubClassByJars(final String parentClassName, int threadnum, Set<String> jars, final ClassPool pool) throws Exception {
        final HashSet<String> sublist = new HashSet<String>();
        if (CollectionUtils.isEmpty(jars)) {
            return sublist;
        }
        if (CollectionUtils.isEmpty(jars)) {
            return sublist;
        }
        if (threadnum <= 0) {
            threadnum = 1;
        }
        List<String> jarAry = Arrays.asList(jars.toArray(new String[jars.size()]));
        List<List<String>> inputlist = CollectionUtil.splitListN(String.class, jarAry, threadnum);
        ArrayList<FutureTask<Result>> furlist = new ArrayList<FutureTask<Result>>();
        for (final List<String> list : inputlist) {
            FutureTask<Result> aa = new FutureTask<Result>(new Callable<Result>(){

                @Override
                public Result call() throws Exception {
                    for (String jarpath : list) {
                        try {
                            File file = new File(jarpath);
                            List<String> templist = IOUtil.getSubType(file.getPath(), null, parentClassName, pool);
                            sublist.addAll(templist);
                        }
                        catch (Exception e) {
                            return Result.getError(String.format("[%s]\u6267\u884c\u5931\u8d25", Thread.currentThread().getName()));
                        }
                    }
                    return Result.getSuc(String.format("[%s]\u6267\u884c\u6210\u529f", Thread.currentThread().getName()));
                }
            });
            furlist.add(aa);
            ThreadPool.getDefaultPool().submit(aa);
        }
        for (Future future : furlist) {
            if (((Result)future.get()).isSuc()) {
                log.info(((Result)future.get()).getMessage());
                continue;
            }
            log.info(((Result)future.get()).getMessage());
        }
        return sublist;
    }

    public static File getCurFolder(Class<?> classz, boolean isTarget) {
        URL url = classz.getProtectionDomain().getCodeSource().getLocation();
        String filePath = null;
        try {
            filePath = URLDecoder.decode(url.getPath(), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean isDelClass = false;
        if (filePath.endsWith(".jar")) {
            filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        }
        if (filePath.indexOf("!/") > 0) {
            int endpos = filePath.substring(0, filePath.indexOf("!/")).lastIndexOf("/");
            filePath = filePath.substring(0, endpos);
            filePath = filePath.replace("file:", "");
        } else if (isTarget) {
            isDelClass = true;
        }
        File file = new File(filePath);
        if (isDelClass) {
            file = file.getParentFile();
        }
        return file;
    }

    public static File getCurFolder(Class<?> classz) {
        return IOUtil.getCurFolder(classz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileReverse(String filename, int maxNum, String charset, boolean isKipnull) {
        RandomAccessFile rf = null;
        ArrayList<String> retlist = new ArrayList<String>();
        try {
            rf = new RandomAccessFile(filename, "r");
            long len = rf.length();
            long start = rf.getFilePointer();
            long nextend = start + len - 1L;
            rf.seek(nextend);
            int c = -1;
            while (nextend > start) {
                c = rf.read();
                if (c == 10 || c == 13) {
                    String line = rf.readLine();
                    if (line != null) {
                        retlist.add(new String(line.getBytes("ISO-8859-1"), charset));
                    } else if (!isKipnull) {
                        retlist.add("");
                    }
                    --nextend;
                }
                rf.seek(--nextend);
                if (nextend == 0L) {
                    retlist.add(new String(rf.readLine().getBytes("ISO-8859-1"), charset));
                }
                if (maxNum <= 0 || retlist.size() < maxNum - 1) continue;
                break;
            }
        }
        catch (FileNotFoundException e) {
            List<String> list = null;
            return list;
        }
        catch (IOException e) {
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (rf != null) {
                    rf.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retlist;
    }

    public static List<String> readFileReverse(String filename, int maxNum) {
        return IOUtil.readFileReverse(filename, maxNum, "UTF-8", true);
    }

    public static void createFile(String fileName, long fileSize) throws IOException {
        File newFile = new File(fileName);
        RandomAccessFile raf = new RandomAccessFile(newFile, "rw");
        raf.setLength(fileSize);
        raf.close();
    }

    public static Set<Class<?>> getClasses(String pack, boolean inSubPackage) {
        LinkedHashSet classes = new LinkedHashSet();
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    IOUtil.findClassByFile(packageName, filePath, inSubPackage, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !inSubPackage || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findClassByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                IOUtil.findClassByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<Pair<String, InputStream>> getResources(String rootpackage, String packageele, String suffix) {
        List<URL> roots = IOUtil.findHasPackRootPath(rootpackage);
        ArrayList<Pair<String, InputStream>> resources = new ArrayList<Pair<String, InputStream>>();
        for (URL root : roots) {
            List<Pair<String, InputStream>>[] findFiles = IOUtil.findFiles("", root, packageele, "tams-cas", suffix, new String[0]);
            resources.addAll(findFiles[1]);
        }
        return resources;
    }

    public static List<URL> findHasPackRootPath(String ... packageNames) {
        ArrayList<URL> retRoots = new ArrayList<URL>();
        if (ArrayUtils.isEmpty((Object[])packageNames)) {
            return retRoots;
        }
        for (String packageName : packageNames) {
            String packageDirName = packageName.replace('.', '/');
            try {
                Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
                while (dirs.hasMoreElements()) {
                    URL url2;
                    String rootpath;
                    int index;
                    URL url = dirs.nextElement();
                    String protocol = url.getProtocol();
                    if ("file".equals(protocol)) {
                        index = url.getPath().indexOf("/classes/");
                        if (index <= 0) continue;
                        rootpath = url.getPath().substring(0, index + 9);
                        url2 = new URL("file:" + rootpath);
                        if (retRoots.contains(url2)) continue;
                        retRoots.add(url2);
                        continue;
                    }
                    if (!"jar".equals(protocol) || (index = url.getPath().lastIndexOf(".jar!/")) <= 0) continue;
                    rootpath = url.getPath().substring(0, index + 6);
                    url2 = new URL("jar:" + rootpath);
                    if (retRoots.contains(url2)) continue;
                    retRoots.add(url2);
                }
            }
            catch (IOException e) {
                log.error("\u67e5\u6839\u8def\u5f84\u9519\u8bef", (Throwable)e);
            }
        }
        return retRoots;
    }

    public static File[] listFile(String dirpath, String pattern) {
        File dir = new File(dirpath);
        RegexFileFilter fileFilter = new RegexFileFilter(pattern);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        return files;
    }

    public static String doPostOrGet(String pathUrl, String data, String ... heads) {
        OutputStreamWriter out = null;
        BufferedReader br = null;
        String result = "";
        try {
            URL url = new URL(pathUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setReadTimeout(5000);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            if (ArrayUtils.isNotEmpty((Object[])heads)) {
                Map map = CollectionUtil.newMap(heads);
                for (Object key : map.keySet()) {
                    conn.setRequestProperty(String.valueOf(key), String.valueOf(map.get(key)));
                }
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new OutputStreamWriter(conn.getOutputStream(), "UTF-8");
            out.write(data);
            out.flush();
            InputStream is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String str = "";
            while ((str = br.readLine()) != null) {
                result = result + str;
            }
            System.out.println(result);
            is.close();
            conn.disconnect();
            String string = result;
            return string;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.project_undefined, e.getMessage());
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

