/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import net.wicp.tams.common.apiext.PwdUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkUtil {
    private static final Logger log = LoggerFactory.getLogger(FreemarkUtil.class);
    private static final FreemarkUtil inst = new FreemarkUtil();
    private Configuration cfg;
    private TemplateLoader[] curLoads;

    private FreemarkUtil() {
    }

    public static FreemarkUtil getInst() {
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        TemplateLoader[] defaultLoads = new TemplateLoader[]{stringLoader};
        inst.addLoads(defaultLoads);
        return inst;
    }

    public synchronized void addLoads(TemplateLoader ... templateLoader) {
        this.curLoads = (TemplateLoader[])ArrayUtils.addAll((Object[])this.curLoads, (Object[])templateLoader);
        this.cfg = new Configuration(Configuration.VERSION_2_3_23);
        this.cfg.setDefaultEncoding("utf-8");
        MultiTemplateLoader mtl = new MultiTemplateLoader(this.curLoads);
        this.cfg.setTemplateLoader((TemplateLoader)mtl);
    }

    public TemplateLoader getLoad(int index) {
        return this.getLoad().getTemplateLoader(index);
    }

    public StringTemplateLoader getLoadStr() {
        return (StringTemplateLoader)this.getLoad(0);
    }

    public MultiTemplateLoader getLoad() {
        return (MultiTemplateLoader)this.cfg.getTemplateLoader();
    }

    public String getTempStr(String name) {
        try {
            Object source = this.getLoad().findTemplateSource(name);
            Reader reader = this.getLoad().getReader(source, "utf-8");
            String dest = IOUtils.toString((Reader)reader);
            return dest;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6a21\u677f\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u6a21\u677f" + name + "\u9519\u8bef");
        }
    }

    public long getTempLastTime(String name) {
        try {
            Object source = this.getLoad().findTemplateSource(name);
            return this.getLoad().getLastModified(source);
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6a21\u677f\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u6a21\u677f" + name + "\u9519\u8bef");
        }
    }

    public Template getTemplate(String name, boolean retry) {
        Template template = null;
        try {
            template = this.cfg.getTemplate(name);
            return template;
        }
        catch (Exception e) {
            if (retry && template == null) {
                for (int i = 0; i < 20; ++i) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                        template = this.cfg.getTemplate(name);
                        return template;
                    }
                    catch (Exception exception) {
                        if (template != null) break;
                        continue;
                    }
                }
            }
            log.info("first hasnot template:{}", (Object)name);
            return null;
        }
    }

    public String doProcessByTemp(String tempStr, Object datamap) {
        String key = PwdUtil.MD5(tempStr);
        Template template = this.getTemplate(key, false);
        if (template == null) {
            this.getLoadStr().putTemplate(key, tempStr);
            template = this.getTemplate(key, true);
        }
        return this.doProcess(template, datamap);
    }

    public String doProcess(String name, Object dataModel) {
        Template template = this.getTemplate(name, false);
        return this.doProcess(template, dataModel);
    }

    public String doProcess(Template template, Object dataModel) {
        StringWriter out = new StringWriter();
        try {
            template.process(dataModel, (Writer)out);
            return out.toString();
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u9519\u8bef,\u6a21\u677f:" + template.getName(), (Throwable)e);
            throw new RuntimeException("\u5904\u7406\u9519\u8bef,\u6a21\u677f:" + template.getName());
        }
    }
}

