/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import net.wicp.tams.common.apiext.OSinfo;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.ICount;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.list.GrowthList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionUtil {
    private static final Logger log = LoggerFactory.getLogger(CollectionUtil.class);

    public static int indexOf(Object[][] oriDatas, Object[] curData, int start) {
        if (oriDatas == null || oriDatas.length == 0 || curData == null) {
            return -1;
        }
        for (int i = start; i < oriDatas.length; ++i) {
            Object[] oriData = oriDatas[i];
            if (oriData.length != curData.length) continue;
            boolean isEqual = true;
            for (int j = 0; j < oriData.length; ++j) {
                if (Objects.equals(oriData[j], curData[j])) continue;
                isEqual = false;
                break;
            }
            if (!isEqual) continue;
            return i;
        }
        return -1;
    }

    public static <T> String listJoin(Collection<T> fromList, String joinStr) {
        if (CollectionUtils.isEmpty(fromList)) {
            return null;
        }
        joinStr = StringUtils.isEmpty((CharSequence)joinStr) ? "," : joinStr;
        StringBuffer toList = new StringBuffer();
        Iterator<T> iterator = fromList.iterator();
        toList.append(String.valueOf(iterator.next()));
        while (iterator.hasNext()) {
            String string = String.valueOf(iterator.next());
            toList.append(joinStr);
            toList.append(string);
        }
        return toList.toString();
    }

    public static String arrayJoin(Object[] fromList, String joinStr) {
        if (ArrayUtils.isEmpty((Object[])fromList)) {
            return null;
        }
        List<Object> objlist = Arrays.asList(fromList);
        return CollectionUtil.listJoin(objlist, joinStr);
    }

    public static <T> T[] arrayMerge(Class<T[]> clazz, T[] a, T[] b) {
        if (ArrayUtils.isEmpty((Object[])a)) {
            return b;
        }
        if (ArrayUtils.isEmpty((Object[])b)) {
            return a;
        }
        T[] newArray = CollectionUtil.newArrayByArrayClass(clazz, a.length + b.length);
        System.arraycopy(a, 0, newArray, 0, a.length);
        System.arraycopy(b, 0, newArray, a.length, b.length);
        return newArray;
    }

    public static <T> T[] arrayAnd(Class<T[]> clazz, T[] a, T[] b) {
        if (ArrayUtils.isEmpty((Object[])a) || ArrayUtils.isEmpty((Object[])b)) {
            return CollectionUtil.newArrayByArrayClass(clazz, 0);
        }
        ArrayList<T> retlist = new ArrayList<T>();
        for (T t : a) {
            if (!ArrayUtils.contains((Object[])b, t)) continue;
            retlist.add(t);
        }
        return retlist.toArray(CollectionUtil.newArrayByArrayClass(clazz, retlist.size()));
    }

    public static <T> List<T> listAnd(Class<T> clazz, List<T> a, List<T> b, Comparator<T> comparator) {
        if (CollectionUtils.isEmpty(a) || CollectionUtils.isEmpty(b) || comparator == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> retlist = new ArrayList<T>();
        for (T add : b) {
            boolean eq = false;
            for (T base : a) {
                if (comparator.compare(base, add) != 0) continue;
                eq = true;
                break;
            }
            if (!eq) continue;
            retlist.add(add);
        }
        return retlist;
    }

    public static <T> List<T> listOr(Class<T> clazz, List<T> a, List<T> b, Comparator<T> comparator) {
        if (CollectionUtils.isEmpty(a)) {
            return b;
        }
        if (CollectionUtils.isEmpty(b)) {
            return a;
        }
        ArrayList<T> retlist = new ArrayList<T>();
        if (comparator == null) {
            retlist.addAll(a);
            retlist.addAll(b);
            return retlist;
        }
        retlist.addAll(a);
        for (T add : b) {
            boolean eq = false;
            for (T base : a) {
                if (comparator.compare(base, add) != 0) continue;
                eq = true;
                break;
            }
            if (eq) continue;
            retlist.add(add);
        }
        return retlist;
    }

    public static <T> T[] arrayOr(Class<T[]> clazz, T[] a, T[] b) {
        if (ArrayUtils.isEmpty((Object[])a) || ArrayUtils.isEmpty((Object[])b)) {
            return CollectionUtil.newArrayByArrayClass(clazz, 0);
        }
        ArrayList<T> retlist = new ArrayList<T>();
        for (T t : a) {
            retlist.add(t);
        }
        for (T t : b) {
            if (retlist.contains(t)) continue;
            retlist.add(t);
        }
        return retlist.toArray(CollectionUtil.newArrayByArrayClass(clazz, retlist.size()));
    }

    public static <T> T[] newArrayByArrayClass(Class<T[]> clazz, int length) {
        return (Object[])Array.newInstance(clazz.getComponentType(), length);
    }

    public static <T> List<List<T>> splitList(Class<T> clazz, List<T> inputList, int sumPerRow, ICount<T> countObj, boolean replenish) {
        ArrayList<List<T>> returnList = new ArrayList<List<T>>();
        if (CollectionUtils.isEmpty(inputList) || sumPerRow == 0) {
            return returnList;
        }
        int count = 0;
        ArrayList<T> addList = new ArrayList<T>();
        for (int i = 0; i < inputList.size(); ++i) {
            T newInstance;
            int j2;
            int curCount;
            T t = inputList.get(i);
            int n = curCount = countObj == null ? 1 : countObj.countObj(t);
            if (curCount + addList.size() > sumPerRow) {
                if (addList.size() > 0) {
                    if (replenish && count < sumPerRow) {
                        try {
                            for (j2 = 0; j2 < sumPerRow - count; ++j2) {
                                newInstance = clazz.newInstance();
                                addList.add(newInstance);
                            }
                        }
                        catch (Exception j2) {
                            // empty catch block
                        }
                    }
                    returnList.add(addList);
                    addList = new ArrayList();
                    count = 0;
                }
                addList.add(t);
                count += curCount;
            } else {
                addList.add(t);
                count += curCount;
            }
            if (count >= sumPerRow) {
                if (replenish && count < sumPerRow) {
                    try {
                        for (j2 = 0; j2 < sumPerRow - count; ++j2) {
                            newInstance = clazz.newInstance();
                            addList.add(newInstance);
                        }
                    }
                    catch (Exception j3) {
                        // empty catch block
                    }
                }
                returnList.add(addList);
                addList = new ArrayList();
                count = 0;
                continue;
            }
            if (i != inputList.size() - 1 || addList.size() <= 0) continue;
            if (replenish && count < sumPerRow) {
                try {
                    for (j2 = 0; j2 < sumPerRow - count; ++j2) {
                        newInstance = clazz.newInstance();
                        addList.add(newInstance);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            returnList.add(addList);
        }
        return returnList;
    }

    public static <T> List<List<T>> splitList(Class<T> clazz, List<T> inputList, int sumPerRow, boolean replenish) {
        return CollectionUtil.splitList(clazz, inputList, sumPerRow, null, replenish);
    }

    public static <T> List<List<T>> splitList(Class<T> clazz, List<T> inputList, int sumPerRow) {
        return CollectionUtil.splitList(clazz, inputList, sumPerRow, null, false);
    }

    public static <T> List<List<T>> splitListN(Class<T> clazz, List<T> inputList, int listnum) {
        if (CollectionUtils.isEmpty(inputList) || listnum == 0) {
            return null;
        }
        int tempint = inputList.size() / listnum;
        if (tempint == 0) {
            ArrayList<List<T>> returnList = new ArrayList<List<T>>();
            returnList.add(inputList);
            return returnList;
        }
        List<List<T>> retlist = CollectionUtil.splitList(clazz, inputList.subList(0, tempint * listnum), tempint);
        int j = 0;
        for (int i = 0; i < inputList.size() % listnum; ++i) {
            retlist.get(j++).add(inputList.get(tempint * listnum + i));
        }
        return retlist;
    }

    public static List<?> getColFromObj(List<?> fromList, String colName) {
        ArrayList<Object> retList = new ArrayList<Object>();
        if (CollectionUtils.isEmpty(fromList)) {
            return retList;
        }
        for (Object object : fromList) {
            Object result = null;
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                Map tempObjMap = (Map)object;
                result = tempObjMap.get(colName);
            } else {
                result = MVEL.eval((String)colName, object);
            }
            retList.add(result);
        }
        return retList;
    }

    public static <T> List<String> getColValStrFromObj(List<T> fromList, String colName) {
        ArrayList<String> retList = new ArrayList<String>();
        if (CollectionUtils.isEmpty(fromList)) {
            return retList;
        }
        for (T object : fromList) {
            String result = null;
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                Map tempObjMap = (Map)object;
                result = String.valueOf(tempObjMap.get(colName));
            } else {
                result = String.valueOf(MVEL.eval((String)colName, object));
            }
            retList.add(result);
        }
        return retList;
    }

    public static <T> Set<T> getColSetFromObj(List<?> fromList, String colName) {
        HashSet<Object> retset = new HashSet<Object>();
        if (CollectionUtils.isEmpty(fromList)) {
            return retset;
        }
        for (Object object : fromList) {
            Object result = null;
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                Map tempObjMap = (Map)object;
                result = tempObjMap.get(colName);
            } else {
                result = MVEL.eval((String)colName, object);
            }
            retset.add(result);
        }
        return retset;
    }

    public static Collection selectFilter(Collection inputCollection, Predicate predicate) {
        Collection retCollection = CollectionUtils.select((Collection)inputCollection, (Predicate)predicate);
        CollectionUtils.filter((Collection)inputCollection, (Predicate)predicate);
        return retCollection;
    }

    public static void distinctFilter(Collection collection) {
        HashSet temps = new HashSet();
        temps.addAll(collection);
        collection.clear();
        collection.addAll(temps);
    }

    public static void filterNull(Map orimap, int includeBlack) {
        if (orimap == null) {
            return;
        }
        ArrayList removes = new ArrayList();
        for (Object key : orimap.keySet()) {
            Object value = orimap.get(key);
            boolean needRemove = false;
            switch (includeBlack) {
                case 1: {
                    needRemove = value == null;
                    break;
                }
                case 2: {
                    needRemove = StringUtils.isEmpty((CharSequence)String.valueOf(value));
                    break;
                }
                case 3: {
                    needRemove = StringUtil.isNull(false, value);
                    break;
                }
                case 4: {
                    needRemove = StringUtil.isNull(true, value);
                    break;
                }
            }
            if (!needRemove) continue;
            removes.add(key);
        }
        for (Object key : removes) {
            orimap.remove(key);
        }
    }

    public static List filter(List oriList, final String colName, String include, String exclude) {
        ArrayList retAry = new ArrayList();
        if (CollectionUtils.isEmpty((Collection)oriList)) {
            return retAry;
        }
        if (StringUtils.isNotBlank((CharSequence)include)) {
            String[] iAry = include.split(",");
            block2: for (int i = 0; i < iAry.length; ++i) {
                String includeValue = iAry[i];
                for (Object eleObj : oriList) {
                    try {
                        Object tempObj;
                        if (ReflectAssist.isInterface(eleObj.getClass(), "java.util.Map")) {
                            tempObj = (Map)eleObj;
                            if (!includeValue.equalsIgnoreCase(String.valueOf(tempObj.get(colName)))) continue;
                            retAry.add(eleObj);
                            continue block2;
                        }
                        tempObj = PropertyUtils.getProperty(eleObj, (String)colName);
                        if (!includeValue.equalsIgnoreCase(String.valueOf(tempObj))) continue;
                        retAry.add(eleObj);
                        continue block2;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)exclude)) {
            final String[] eAry = exclude.split(",");
            retAry = CollectionUtils.isEmpty(retAry) ? oriList : retAry;
            CollectionUtils.filter(retAry, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    try {
                        Map tempObj;
                        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map") ? ArrayUtils.contains((Object[])eAry, (Object)String.valueOf((tempObj = (Map)object).get(colName))) : ArrayUtils.contains((Object[])eAry, (Object)(tempObj = PropertyUtils.getProperty((Object)object, (String)colName)))) {
                            return false;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
            });
        }
        retAry = CollectionUtils.isEmpty(retAry) ? oriList : retAry;
        return retAry;
    }

    public static List<Integer> asList(int[] oriAry) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (ArrayUtils.isNotEmpty((int[])oriAry)) {
            for (int integer : oriAry) {
                ret.add(integer);
            }
        }
        return ret;
    }

    public static List<Integer> asList(String[] oriAry) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (ArrayUtils.isNotEmpty((Object[])oriAry)) {
            for (String ele : oriAry) {
                ret.add(Integer.parseInt(ele));
            }
        }
        return ret;
    }

    public static List<String> asList(List<?> oriList) {
        if (oriList == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Object object : oriList) {
            ret.add(String.valueOf(object));
        }
        return ret;
    }

    public static Map<String, String> getPropsByKeypre(Properties prop, String keyOriPre, String keyTargetPre, boolean delPre) {
        if (prop == null || prop.size() == 0 || StringUtil.isNull(keyOriPre)) {
            return new HashMap<String, String>();
        }
        Properties tempProp = (Properties)prop.clone();
        Set<Object> propKeys = tempProp.keySet();
        HashMap<String, String> retMap = new HashMap<String, String>();
        String tempStr = String.format("%s.", keyOriPre.endsWith(".") ? keyOriPre.substring(0, keyOriPre.length() - 1) : keyOriPre);
        for (Object object : propKeys) {
            String key = String.valueOf(object);
            if (!key.startsWith(tempStr)) continue;
            retMap.put(delPre ? key.substring(tempStr.length()) : key, String.valueOf(tempProp.get(key)));
        }
        if (StringUtil.isNotNull(keyTargetPre)) {
            String tempStr2 = String.format("%s.", keyTargetPre.endsWith(".") ? keyTargetPre.substring(0, keyOriPre.length() - 1) : keyTargetPre);
            for (Object object : propKeys) {
                String key = String.valueOf(object);
                if (!key.startsWith(tempStr2)) continue;
                retMap.put(delPre ? key.substring(tempStr2.length()) : key, String.valueOf(tempProp.get(key)));
            }
        }
        return retMap;
    }

    public static Map<String, String> getPropsByKeypre(Properties prop, String keyOriPre, boolean delPre) {
        return CollectionUtil.getPropsByKeypre(prop, keyOriPre, null, delPre);
    }

    public static Properties getPropsSubByKeypre(Properties prop, String keyPre, boolean delPre) {
        return CollectionUtil.convMapToProperties(CollectionUtil.getPropsByKeypre(prop, keyPre, delPre));
    }

    public static Properties convMapToProperties(Map map) {
        Properties properties = new Properties();
        if (MapUtils.isEmpty((Map)map)) {
            return properties;
        }
        for (Object ele : map.keySet()) {
            properties.put(ele, map.get(ele));
        }
        return properties;
    }

    public static Map convertMapForKey(Map map) {
        HashMap retmap = new HashMap();
        for (Object key : map.keySet()) {
            String keyTrue = StringUtil.convertStr(String.valueOf(key));
            retmap.put(keyTrue, map.get(key));
        }
        return retmap;
    }

    public static Map newMap(Object ... input) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (ArrayUtils.isEmpty((Object[])input)) {
            return ret;
        }
        for (int i = 0; i < input.length / 2; ++i) {
            Object key = input[2 * i];
            Object value = 2 * i + 1 < input.length ? input[2 * i + 1] : null;
            ret.put(key, value);
        }
        return ret;
    }

    public static Map<String, String> newMapStr(String ... input) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (ArrayUtils.isEmpty((Object[])input)) {
            return ret;
        }
        for (int i = 0; i < input.length / 2; ++i) {
            String key = input[2 * i];
            String value = 2 * i + 1 < input.length ? input[2 * i + 1] : null;
            ret.put(key, value);
        }
        return ret;
    }

    public static <T> String toPropString(Map<String, T> datamap, int retract, String splitStr) {
        if (MapUtils.isEmpty(datamap)) {
            return "";
        }
        String prenull = "";
        for (int i = 0; i < (retract < 0 ? 0 : retract); ++i) {
            prenull = prenull + " ";
        }
        StringBuffer buff = new StringBuffer();
        String formatestr = "%s%s=%s" + splitStr;
        Set<String> keySet = datamap.keySet();
        Object[] keyAry = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyAry);
        for (Object key : keyAry) {
            buff.append(String.format(formatestr, prenull, key, StringUtil.trimSpace(String.valueOf(datamap.get(key)))));
        }
        int lastDelChartNum = OSinfo.isWindows() ? splitStr.length() : ("%n".equals(splitStr) ? 0 : splitStr.length());
        return buff.subSequence(0, buff.length() - lastDelChartNum).toString();
    }

    public static <T> String toPropStringLn(Map<String, T> datamap, int retract) {
        return CollectionUtil.toPropString(datamap, retract, "%n");
    }

    public static <T> String toPropString(Map<String, T> datamap, String splitStr) {
        return CollectionUtil.toPropString(datamap, 0, StringUtil.hasNull(splitStr, ","));
    }

    public static Map<String, Object> flattenedMapToMultilayerMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> rootResult = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            CollectionUtil.buildMultilayerMap(rootResult, key, entry.getValue());
        }
        return rootResult;
    }

    public static Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result.put("document", object);
            return result;
        }
        Map map = (Map)object;
        for (Map.Entry entry : map.entrySet()) {
            Object key;
            Object value = entry.getValue();
            if (value instanceof Map) {
                value = CollectionUtil.asMap(value);
            }
            if ((key = entry.getKey()) instanceof CharSequence) {
                result.put(key.toString(), value);
                continue;
            }
            result.put("[" + key.toString() + "]", value);
        }
        return result;
    }

    public static <T1, T2> MutableTriple<List<T2>, List<T1>, List<T2>> packageComparison(List<T1> oldList, List<T2> newList, String comPareColName, String idColName) {
        String cloValue;
        if (CollectionUtils.isEmpty(oldList)) {
            return MutableTriple.of(null, null, newList);
        }
        if (CollectionUtils.isEmpty(newList)) {
            return MutableTriple.of(null, oldList, null);
        }
        ArrayList<Object> deleteList = new ArrayList<Object>();
        ArrayList<T2> updateList = new ArrayList<T2>();
        ArrayList<T2> addList = new ArrayList<T2>();
        List<String> oldKeyList = CollectionUtil.getColValStrFromObj(oldList, comPareColName);
        List<String> newKeyList = CollectionUtil.getColValStrFromObj(newList, comPareColName);
        for (T2 newEle : newList) {
            try {
                cloValue = BeanUtils.getProperty(newEle, (String)comPareColName);
                if (oldKeyList.contains(cloValue)) {
                    updateList.add(newEle);
                    try {
                        Object idvalue = null;
                        for (T1 t1 : oldList) {
                            String comPareColValue = BeanUtils.getProperty(t1, (String)comPareColName);
                            if (!StringUtil.isNotNull(cloValue) || !StringUtil.isNotNull(comPareColValue) || !cloValue.equals(comPareColValue)) continue;
                            idvalue = PropertyUtils.getProperty(t1, (String)idColName);
                            break;
                        }
                        if (!StringUtil.isNotNull(idvalue)) continue;
                        PropertyUtils.setProperty(newEle, (String)idColName, idvalue);
                    }
                    catch (Exception e) {
                        log.error("\u9519\u8bef\u8bbe\u7f6eid,\u53ef\u80fd\u63a5\u4e0b\u6765\u8981\u901a\u8fc7id\u8fdb\u884c\u4fee\u6539", (Throwable)e);
                    }
                    continue;
                }
                addList.add(newEle);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u6bd4\u8f83\u65f6\u9519\u8bef.", (Throwable)e);
            }
        }
        for (Object oldEle : oldList) {
            try {
                cloValue = BeanUtils.getProperty((Object)oldEle, (String)comPareColName);
                if (newKeyList.contains(cloValue)) continue;
                deleteList.add(oldEle);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.error("\u6bd4\u8f83\u65f6\u9519\u8bef.", (Throwable)e);
            }
        }
        return MutableTriple.of(updateList, deleteList, addList);
    }

    public static Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        CollectionUtil.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String key = entry.getKey();
            if (!StringUtils.isBlank((CharSequence)path)) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if ((value = entry.getValue()) instanceof String) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                Map map = (Map)value;
                CollectionUtil.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    CollectionUtil.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }

    private static void buildMultilayerMap(Map<String, Object> parent, String path, Object value) {
        String[] keys = StringUtils.split((String)path, (String)".");
        String key = keys[0];
        if (key.endsWith("]")) {
            String listKey = key.substring(0, key.indexOf("["));
            String listPath = path.substring(key.indexOf("["));
            List<Object> chlid = CollectionUtil.bulidChlidList(parent, listKey);
            CollectionUtil.buildMultilayerList(chlid, listPath, value);
        } else if (keys.length == 1) {
            parent.put(key, CollectionUtil.stringToObj(value.toString()));
        } else {
            String newpath = path.substring(path.indexOf(".") + 1);
            Map<String, Object> chlid = CollectionUtil.bulidChlidMap(parent, key);
            CollectionUtil.buildMultilayerMap(chlid, newpath, value);
        }
    }

    private static List<Object> bulidChlidList(Map<String, Object> parent, String key) {
        if (parent.containsKey(key)) {
            return (List)parent.get(key);
        }
        GrowthList chlid = new GrowthList(16);
        parent.put(key, chlid);
        return chlid;
    }

    private static Object stringToObj(String obj) {
        Object result = null;
        result = obj.equals("true") || obj.equals("false") ? Boolean.valueOf(obj) : (StringUtil.isBigDecimal(obj) ? (obj.indexOf(".") == -1 ? (Number)Long.valueOf(obj.toString()) : (Number)Double.valueOf(obj.toString())) : obj);
        return result;
    }

    private static void buildMultilayerList(List<Object> parent, String path, Object value) {
        String[] keys = StringUtils.split((String)path, (String)".");
        String key = keys[0];
        int index = Integer.valueOf(key.replace("[", "").replace("]", ""));
        if (keys.length == 1) {
            parent.add(index, CollectionUtil.stringToObj(value.toString()));
        } else {
            String newpath = path.substring(path.indexOf(".") + 1);
            Map<String, Object> chlid = CollectionUtil.bulidChlidMap(parent, index);
            CollectionUtil.buildMultilayerMap(chlid, newpath, value);
        }
    }

    private static Map<String, Object> bulidChlidMap(Map<String, Object> parent, String key) {
        if (parent.containsKey(key)) {
            return (Map)parent.get(key);
        }
        LinkedHashMap<String, Object> chlid = new LinkedHashMap<String, Object>(16);
        parent.put(key, chlid);
        return chlid;
    }

    private static Map<String, Object> bulidChlidMap(List<Object> parent, int index) {
        LinkedHashMap chlid = null;
        try {
            Object obj = parent.get(index);
            if (null != obj) {
                chlid = (LinkedHashMap)obj;
            }
        }
        catch (Exception e) {
            log.warn("get list error");
        }
        if (null == chlid) {
            chlid = new LinkedHashMap(16);
            parent.add(index, chlid);
        }
        return chlid;
    }
}

