/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum StrPattern {
    char_normal("^[a-zA-Z0-9_\u4e00-\u9fa5]+$"),
    char_zh("[\u4e00-\u9fa5]"),
    row_blank("\\n\\s*\\r"),
    email("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*"),
    identity("\\d{15}|\\d{18}"),
    date("^[0-9]{4}\\-[0-9]{1,2}\\-[0-9]{1,2}"),
    date2("^[0-9]{4}[0-9]{2}[0-9]{2}"),
    date_time("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))( )(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))"),
    date_time2("^([0-9]{4})((0([1-9]{1}))|(1[0-2]))(([0-2]([0-9]{1}))|(3[0|1]))(([0-1]([0-9]{1}))|(2[0-4]))([0-5]([0-9]{1}))([0-5]([0-9]{1}))"),
    date_time_SSS("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))( )(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(.)([0-9]{1,3})"),
    date_time_SSS2("^([0-9]{4})((0([1-9]{1}))|(1[0-2]))(([0-2]([0-9]{1}))|(3[0|1]))(([0-1]([0-9]{1}))|(2[0-4]))([0-5]([0-9]{1}))([0-5]([0-9]{1}))([0-9]{1,3})"),
    date_time_t1("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))"),
    date_time_t2("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(Z)"),
    date_time_t3("^([0-9]{4})(-)((0([1-9]{1}))|(1[0-2]))(-)(([0-2]([0-9]{1}))|(3[0|1]))(T)(([0-1]([0-9]{1}))|(2[0-4]))(:)([0-5]([0-9]{1}))(:)([0-5]([0-9]{1}))(CST)"),
    mobile_phone("^(13[0-9]|15[0|3|6|7|8|9]|18[6|8|9])\\d{8}$"),
    number_float("^(-?\\d+)(\\.\\d+)?$"),
    number_float_positive("^\\d+(\\.\\d+)?$"),
    number_integer("^-?\\d+$"),
    number_integer_positive("^\\d+$"),
    db_split("^\\w+_[0-9]{2}$"),
    tb_split("^\\w+_[0-9]{4}$"),
    split_pattern("\\s*[,]+\\s*");

    private String code;

    private StrPattern(String code) {
        this.code = code;
    }

    public boolean checkStrFormat(String str) {
        return StrPattern.checkStrFormat(this.code, str);
    }

    public Pattern compile() {
        Pattern pattern = Pattern.compile(this.code);
        return pattern;
    }

    public static boolean checkStrFormat(String patternStr, String str) {
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(str);
        boolean bool = matcher.matches();
        return bool;
    }
}

