/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import net.wicp.tams.common.apiext.SshAssist;
import net.wicp.tams.common.apiext.StringUtil;

public enum DbType {
    mysql("jdbc:mysql://%s:%s", "%s/%s", "zeroDateTimeBehavior=convertToNull&useUnicode=true&characterEncoding=UTF-8&autoReconnect=true&failOverReadOnly=false&verifyServerCertificate=false&useSSL=false"),
    sqlserver("jdbc:sqlserver://%s:%s", "%s;DatabaseName=%s", "");

    private final String formatestr;
    private final String formatedbstr;
    private final String defaultparam;

    public String getDefaultparam() {
        return this.defaultparam;
    }

    public String getFormatedbstr() {
        return this.formatedbstr;
    }

    public String getFormatestr() {
        return this.formatestr;
    }

    public String geturl(String sshLocalhostprot, String host, int port, String defaultdb, String urlparam) {
        String url;
        String temp = this.getFormatestr();
        if (StringUtil.isNotNull(sshLocalhostprot)) {
            SshAssist.ssh(Integer.parseInt(sshLocalhostprot), host, port);
            url = String.format(temp, "localhost", sshLocalhostprot);
        } else {
            url = String.format(temp, host, port);
        }
        if (StringUtil.isNotNull(defaultdb)) {
            url = String.format(this.getFormatedbstr(), url, defaultdb);
        }
        url = StringUtil.isNotNull(urlparam) ? url + "?" + urlparam : url + (StringUtil.isNull(this.getDefaultparam()) ? "" : "?" + StringUtil.hasNull(this.getDefaultparam()));
        return url;
    }

    public String geturl(String host, int port) {
        return this.geturl(null, host, port, null, null);
    }

    public String geturl(String host, int port, String defaultdb) {
        return this.geturl(null, host, port, defaultdb, null);
    }

    public String geturl(String host, int port, String defaultdb, String urlparam) {
        return this.geturl(null, host, port, defaultdb, urlparam);
    }

    private DbType(String formatestr, String formatedbstr, String defaultparam) {
        this.formatestr = formatestr;
        this.formatedbstr = formatedbstr;
        this.defaultparam = defaultparam;
    }
}

