/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common;

import com.alibaba.fastjson.JSONObject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.wicp.tams.common.apiext.ClassLoaderPlugin;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Plugin
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Plugin.class);
    private final ClassLoaderPlugin load;
    private final String parentClassName;
    private final Map<String, Class<?>> allClassmap = new HashMap();
    private final List<String> excludes = new ArrayList<String>();
    private final List<String> includes = new ArrayList<String>();

    public Plugin(String dirpath, String parentClassName, ClassLoader parent, int maxLevel) {
        Validate.notBlank((CharSequence)dirpath, (String)"\u63d2\u4ef6\u6240\u5728\u7684\u8def\u5f84\u5fc5\u987b\u4f20\u3000", (Object[])new Object[0]);
        this.load = new ClassLoaderPlugin(dirpath, parent, maxLevel);
        this.parentClassName = parentClassName;
    }

    @Override
    public void close() {
        this.load.close();
        this.allClassmap.clear();
        this.excludes.clear();
        this.includes.clear();
    }

    public Plugin(String dirpath, String parentClassName, ClassLoader parent, List<String> includes, List<String> excludes, int maxLevel) {
        this(dirpath, parentClassName, parent, maxLevel);
        if (CollectionUtils.isNotEmpty(includes)) {
            this.includes.addAll(includes);
        }
        if (CollectionUtils.isNotEmpty(excludes)) {
            this.excludes.addAll(excludes);
        }
    }

    public ClassLoaderPlugin getLoad() {
        return this.load;
    }

    public Class<?> loadSingle() {
        try {
            Map<String, Class<?>> classes = this.loadClasses();
            if (MapUtils.isEmpty(classes) || classes.size() > 1) {
                log.error(" {} \u5b58\u5728\uff12\u4e2a\u5b9e\u73b0\u7c7b,\u8bf7\u68c0\u67e5\u4ee3\u7801", (Object)this.parentClassName);
                throw new IllegalArgumentException("recivers error");
            }
            Class<?> calssz = classes.values().iterator().next();
            return calssz;
        }
        catch (Exception e) {
            log.info("load receive is error", (Throwable)e);
            throw new RuntimeException("load receive is error");
        }
    }

    public Class<?> loadSingleByClassName(String className) {
        Map<String, Class<?>> classes = this.loadClasses();
        if (classes.containsKey(className)) {
            return classes.get(className);
        }
        try {
            Class<?> curClass = this.load.loadClass(className);
            Class<?> parentClass = this.load.loadClass(this.parentClassName);
            if (parentClass.isInterface() && ReflectAssist.isInterface(curClass, this.parentClassName) || !parentClass.isInterface() && parentClass.isAssignableFrom(curClass)) {
                this.allClassmap.put(className, curClass);
                return curClass;
            }
        }
        catch (Exception e) {
            log.error("\u7c7b" + className + "\u6ca1\u6709\u627e\u5230", (Throwable)e);
        }
        return null;
    }

    private synchronized Map<String, Class<?>> loadClasses() {
        if (MapUtils.isNotEmpty(this.allClassmap)) {
            return this.allClassmap;
        }
        try {
            Set<String> subs = IOUtil.findSubClassByJars(this.parentClassName, 5, this.load.getJars(), this.load.getPool());
            if (CollectionUtils.isNotEmpty(this.excludes)) {
                CollectionUtils.filter(subs, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return !Plugin.this.excludes.contains(object);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(this.includes)) {
                CollectionUtils.filter(subs, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        return Plugin.this.includes.contains(object);
                    }
                });
            }
            HashMap retmap = new HashMap();
            for (String sub : subs) {
                Class<?> calssz = this.load.loadClass(sub);
                retmap.put(sub, calssz);
            }
            this.allClassmap.putAll(retmap);
            return retmap;
        }
        catch (ClassNotFoundException e) {
            log.info("the recicer is error", (Throwable)e);
            throw new RuntimeException("have no recicer");
        }
        catch (Exception e) {
            log.info("load receive is error", (Throwable)e);
            throw new RuntimeException("load receive is error");
        }
    }

    public Object newObject(Map<String, String> params) {
        try {
            return this.loadSingle().getConstructor(Map.class).newInstance(params);
        }
        catch (Exception e) {
            log.error("\u521b\u5efaobject\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object newObject(JSONObject params) {
        try {
            return this.loadSingle().getConstructor(JSONObject.class).newInstance(params);
        }
        catch (Exception e) {
            log.error("\u521b\u5efaobject\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public Object newObject() {
        try {
            return this.loadSingle().newInstance();
        }
        catch (Exception e) {
            log.error("\u521b\u5efaobject\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

