/**   
 * @Title: ExceptAll.java
 * @Package rjzjh.tech.common.Exception
 * @Description: TODO(用一句话描述该文件做什么)
 * @author 周俊辉  
 * @date 2010-10-29 下午01:26:42
 * @version V1.0   
 */
package net.wicp.tams.common.exception;

import org.mvel2.templates.TemplateRuntime;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.impl.convertvalue.obj.ConvertValueExcept;

/***
 * 自定义异常编码与其解释（测试用）
 * 
 * @author andy.zhou
 *
 */
public enum ExceptAll implements IExcept {
	// 系统通用型错误(包括Java相关错误) 在 1000-1999
	no("没有异常", 1000, 200),

	project_undefined("未定义异常", 1001, 500),

	project_user("自定义异常", 1002, 500),

	Project_default("系统错误", 1003, 500),

	project_noservice("错误的服务，没有定义的服务", 1004, 503),

	project_clienterror("客户端连接错误", 1005, 400),

	project_streamclose("流关闭错误", 1006, 500),

	project_nonull("不允许为空值", 1007, 500),

	project_overflow("数据值超出许可范围", 1008, 500),

	project_overarry("数据元素越界", 1009, 500),

	project_formatnofit("格式不匹配", 1010, 500),

	project_datenofitformate("时间格式不对", 1011, 500),

	project_serviceerror("服务错误", 1012, 500),

	project_runshell("运行shell/cmd命令失败", 1013, 500),

	project_timeout("超时", 1014, 504),

	project_nosupportos("不支持的操作系统", 1015, 500),

	project_haveerrors("集合操作有失败", 1016, 500),

	project_nosupport("不支持的实现", 1017, 500),

	project_other("其它错误", 1999, 501),

	// 参数错误 2000-2099
	param_error("参数错误", 2000, 400),

	Param_dynaerror("动态参数错误", 2001, new IDynaMsg() {
		@Override
		public String packMsg(String msg, Object ctx) {
			String retstr = (String) TemplateRuntime.eval(msg, ctx);
			return retstr;
		}
	}),

	Param_typenofit("参数类型不匹配", 2002, 500),

	Param_lengthover("参数长度越界", 2003, 500),

	param_notfit("请求参数不合法", 2004, 400),

	// 联接错误 2100－2129
	conn_nocontrol("输入参数没有控制信息", 2100, 400),

	conn_nochannel("没有渠道信息", 2101, 400),

	conn_nobean("没有业务Bean", 2102, 400),

	// 授权错误 2130－2159
	auth_no_rightful("权鉴不通过", 2130, 401),

	auth_no_login("没有登陆", 2131, 401),

	auth_proxy_setting("代理设置失败", 2132, 401),

	// 2160-2199
	mybatis_notable("没有表", 2160, 400),

	// 2200-2299
	duckula_nodata("没有满足条件的数据", 2200, 400),

	duckula_es_formate("转为es要求的格式错误", 2201, 400),

	duckula_es_query("查询失败", 2202, 400),

	duckula_es_refresh("强制刷新失败", 2203, 400),

	duckula_es_flush("强制flush失败", 2203, 400),

	duckula_es_batch("批量插入失败", 2204, 400),

	// 2300-2399
	jdbc_conn_fail("获取连接失败", 2300, 400),

	jdbc_query_primary("查询数据库主键失败", 2301, 400),

	jdbc_exec_fail("jdbc执行失败", 2302, 400),

	// 2400-2499
	ssh_close_pool("ssh池关闭失败", 2400, 400),

	ssh_auth_fail("ssh登陆失败", 2401, 400),

	ssh_session_open("ssh session 打开失败", 2402, 400),

	ssh_session_command("执行命令失败", 2403, 400),

	ssh_pool_config("配置ssh池失败", 2404, 400),

	ssh_pool_conn("从池里拿连接失败", 2405, 400),

	ssh_client_create("创建SCP客户端失败", 2406, 400),

	// 2500-2599 k8s异常
	k8s_api_other("k8s的api未定义错误", 2500, 400),

	k8s_deploy_conflict("部署k8s资源冲突", 2501, 400),
	
	k8s_api_notfind("k8s的资源不存在", 2500, 404),

	;

	// 其它 2600~~~

	private String desc;
	private int value;
	private int httpCode;
	private int httpCodeSub;

	private IDynaMsg dynaMsg = null;

	/*
	 * private ExceptAll(String desc, int value) { this.desc = desc; this.value =
	 * value; }
	 */

	private ExceptAll(String desc, int value, int httpCode) {
		this.desc = desc;
		this.value = value;
		this.httpCode = httpCode;
	}

	private ExceptAll(String desc, int value, int httpCode, int httpCodeSub) {
		this.desc = desc;
		this.value = value;
		this.httpCode = httpCode;
		this.httpCodeSub = httpCodeSub;
	}

	private ExceptAll(String desc, int value, IDynaMsg dynaMsg) {
		this.desc = desc;
		this.value = value;
		this.dynaMsg = dynaMsg;
	}

	@Override
	public String getDesc() {
		return this.desc;
	}

	@Override
	public int getErrorValue() {
		return this.value;
	}

	@Override
	public String getErrorCode() {
		return this.name();
	}

	@Override
	public String getErrMsg(Object errBean) {
		ConvertValueExcept cv = new ConvertValueExcept(Conf.getCurLocale());
		return packmsg(cv.getStr(this), errBean);
	}

	@Override
	public String getErrMsg() {
		return getErrMsg(null);
	}

	public String getHttp() {
		if (httpCode == 0 && httpCodeSub == 0) {
			return "200";// 未定义http编码
		}
		if (httpCodeSub == 0) {
			return Integer.toString(httpCode);
		}
		return String.format("%s.%s", httpCode, httpCodeSub);
	}

	private String packmsg(String msg, Object ctx) {
		if (dynaMsg != null && ctx != null) {
			msg = dynaMsg.packMsg(msg, ctx);
		}
		return msg;
	}

	public int getHttpCode() {
		return httpCode;
	}

	public void setHttpCode(int httpCode) {
		this.httpCode = httpCode;
	}

	public int getHttpCodeSub() {
		return httpCodeSub;
	}

	public void setHttpCodeSub(int httpCodeSub) {
		this.httpCodeSub = httpCodeSub;
	}

	/**
	 * 通过http得到httpstatus
	 * 
	 * @param http http编码
	 * @return http状态
	 */
	public static int getHttp(String http) {
		if (StringUtil.isNull(http)) {
			return 200;
		} else {
			return Integer.parseInt(http.split("\\.")[0]);
		}
	}

	public static int getHttp(IExcept error) {
		return getHttp(error.getHttp());
	}

}
