package net.wicp.tams.common.beans;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import lombok.Builder;
import lombok.Data;
import net.wicp.tams.common.apiext.StringUtil;

/**
 * 主机
 * 
 * @author 偏锋书生
 *
 */
@Data
@Builder
public class Host implements Comparable<Host> {
	public final static String preVar = "host";

	private String hostIp;
	private int port;
	private String userName;
	private String password;
	private String[] hostnames;

	// db.tb
	// value为：col逗号分隔

	public Host() {
	}

	public Host(String hostIp, int port, String userName, String password, String[] hostnames) {
		super();
		this.hostIp = hostIp;
		this.port = port;
		this.userName = userName;
		this.password = password;
		this.hostnames = hostnames;
	}

	public static Host fromParts(String hostIp, int port) {
		return Host.builder().hostIp(hostIp).port(port).build();
	}

	/****
	 * 把json转为Host，这样就可以写到主机的/etc/hosts文件中。
	 * eg:[{'ip':'192.168.123.23','hostnames':'kafka01,kafka001'}]
	 * 
	 * @param jsonAryStr
	 * @return
	 */
	public static List<Host> jsonToHosts(String jsonAryStr) {
		List<Host> retlist = new ArrayList<Host>();
		if (StringUtil.isNull(jsonAryStr)) {
			return retlist;
		}
		JSONArray parseArray = JSONArray.parseArray(jsonAryStr);
		for (int i = 0; i < parseArray.size(); i++) {
			JSONObject json = parseArray.getJSONObject(i);
			Host temp = new Host();
			temp.setHostIp(json.getString("ip"));
			String[] hostnames = json.getString("hostnames").split(",");
			temp.setHostnames(hostnames);
			retlist.add(temp);
		}
		return retlist;
	}

	/***
	 * 把主机按规则写入/etc/hosts
	 * 
	 * @param hostnames
	 * @return
	 */
	public static String getHostStr(List<Host> hostnames) {
		StringBuffer buff = new StringBuffer();
		for (Host host : hostnames) {
			for (String name : host.getHostnames()) {
				buff.append(String.format("\n%s     %s", host.getHostIp(), name));
			}
		}
		return buff.toString();
	}

	public Host(String hostIp, int port) {
		this(hostIp, port, null, null, null);
	}

	@Override
	public boolean equals(Object obj) {
		Host temp = (Host) obj;
		if (this.hostIp.equals(temp.getHostIp()) && this.port == temp.getPort()) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return hostIp.hashCode() * 37 + port;
	}

	@Override
	public int compareTo(Host o) {
		String[] ips1 = this.hostIp.split(".");
		String[] ips2 = o.getHostIp().split(".");
		for (int i = 0; i < 4; i++) {
			int si1 = Integer.parseInt(ips1[i]);
			int si2 = Integer.parseInt(ips2[i]);
			if (si1 != si2) {
				return si1 - si2;
			}
		}
		return this.port - o.getPort();
	}

}
