package net.wicp.tams.common.apiext.json;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.templates.TemplateRuntime;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.serializerconfig.DoubleSerializerConfig;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.callback.impl.convertvalue.ConvertValueEnum;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.param.RespInfo;
import net.wicp.tams.common.exception.param.Response;

/***
 * JSON对象的扩展
 * 
 * @author andy.zhou
 *
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
@Slf4j
public abstract class JSONUtil {
	// js里面需要处理的特殊字符集，不能把"转为\"，会把外面的"也弄没了
	public static final String[][] specialChar_globle = new String[][] { { "\\\\", "\\\\\\\\" },
			{ "\"null\"", "\"\"" } };
	// public static final String[][] specialChar_value = new String[][] {{ "\"",
	// "\\\\\""}};

	/**
	 * 设置bean值，支持级联
	 * 
	 * @param clazz
	 * @param packParams
	 * @return
	 */
	public static <T> T getBeanFromJson(Class<T> clazz, JSONObject packParams) {
		try {
			T retobj = clazz.newInstance();
			if (packParams.size() == 0) {
				return retobj;
			}
			for (String key : packParams.keySet()) {
				StringUtil.packObj(retobj, key, packParams.getString(key));
			}
			return retobj;
		} catch (Exception e) {
			throw new IllegalAccessError("request转为业务对象时异常" + e.getMessage());
		}
	}

	public static JSONObject getJsonFromUrlStr(String url) {
		JSONObject retobj = new JSONObject();
		if (StringUtil.isNull(url)) {
			return retobj;
		}
		String[] params = url.split("&");
		for (String param : params) {
			String[] temAry = param.split("=");
			if (temAry.length > 1) {
				retobj.put(temAry[0], temAry[1]);
			} else {
				retobj.put(temAry[0], "");
			}
		}
		return retobj;
	}

	/**
	 * 合并JSon
	 * 
	 * @param main 要合并的主json对象
	 * @param add  要合并的附加json对象
	 * @return JSONObject 合并后的json对象
	 */
	public static JSONObject mergeJSON(JSONObject main, JSONObject add) {
		mergeJSON(main, add, false);
		return main;
	}

	/**
	 * 
	 * @param res1
	 * @param res2
	 * @param fast true:不會主次，false:res1為主，即為返回對象
	 * @return
	 */
	public static JSONObject mergeJSON(JSONObject res1, JSONObject res2, boolean fast) {
		JSONObject addJSON = fast ? (res1.keySet().size() < res2.keySet().size() ? res1 : res2) : res2;
		JSONObject mainJSON = fast ? (res1.keySet().size() < res2.keySet().size() ? res2 : res1) : res1;
		for (Iterator iterator = addJSON.keySet().iterator(); iterator.hasNext();) {
			String key = (String) iterator.next();
			if (mainJSON.containsKey(key)) {
				try {
					if (mainJSON.getJSONObject(key).size() > 0 && addJSON.getJSONObject(key).size() > 0) {
						mergeJSON(mainJSON.getJSONObject(key), addJSON.getJSONObject(key), fast);
					}
				} catch (Exception e) {
					mainJSON.put(key, addJSON.get(key));
				}
			} else {
				mainJSON.put(key, addJSON.get(key));
			}
		}
		return mainJSON;
	}

	/**
	 * 把JSONObject对象转为list，里面的每个元素为String[2]
	 * 
	 * @param jsonObject 要合并的json对象1
	 * @return List 转换后列表
	 */
	public static List<String[]> getValues(JSONObject jsonObject) {
		List<String[]> resultList = new ArrayList<String[]>();// 因为是有序的，不能用map
		String key;
		for (Iterator keys = jsonObject.keySet().iterator(); keys.hasNext(); resultList
				.add(new String[] { key, String.valueOf(jsonObject.get(key)) }))
			key = (String) keys.next();
		return resultList;
	}

	/***
	 * 把Map转为json格式的的json数据，全部为String输出 <br>
	 * 结果为：{"itemCode":"returnCheck","itemName":"待退货检查"}
	 * 
	 * @param fromMap 需要转的map
	 * @param convert 转换规则，可以为null
	 * @param keys    需要转的key值，如果不填则为全部 要取的标题，支持别名。 <br>
	 *                如：new String[]{""itemCode,itemCode","itemName_zh,itemName""}
	 *                <br>
	 *                itemName_zh为是取值的列名,itemName要显示的列名
	 * @return json格式字符串
	 */

	public static String getJsonForMap(Map<String, Object> fromMap, IConvertValue[] convert, String... keys) {
		if (fromMap == null || fromMap.size() == 0) {
			return null;
		}
		keys = ArrayUtils.isNotEmpty(keys) ? keys : (String[]) fromMap.keySet().toArray();
		StringBuffer buff = new StringBuffer("{");
		for (int i = 0; i < keys.length; i++) {
			String key = keys[i];
			String[] keyAry = key.split(",");
			String valCol = StringUtil.trimSpace(keyAry[0]);
			String showCol = StringUtil.trimSpace(keyAry[keyAry.length - 1]);
			Object value = StringUtil.isNull(valCol) ? fromMap : fromMap.get(valCol);
			// boolean isall=StringUtil.isNull(valCol)?true:false;//是传整个对象
			String valueTrue = "";
			if (convert != null && convert.length > i && convert[i] != null) {
				IConvertValue convertTrue = convert[i];
				valueTrue = value == null ? "" : convertTrue.getStr(value);
			} else {
				valueTrue = StringUtil.isNull(valCol) ? "" : String.valueOf(value);
			}
			if (i != 0) {
				buff.append(",");
			}
			buff.append("\"" + showCol + "\":\"" + StringUtil.hasNull(valueTrue) + "\"");

		}
		buff.append("}");
		return buff.toString();
	}

	public static String getJsonForMap(Map<String, Object> fromMap, String... keys) {
		return getJsonForMap(fromMap, null, keys);
	}

	/***
	 * 把map转为json，key支持 a.b 会转为 a对象的b字段
	 * 
	 * @param fromMap
	 * @return
	 */
	public static JSONObject getJsonForMapFlat(Map<String, Object> fromMap) {
		JSONObject retobj = new JSONObject();
		if (MapUtils.isEmpty(fromMap)) {
			return retobj;
		}
		for (String key : fromMap.keySet()) {
			int spiltIndex = key.indexOf(".");
			String firstkey = spiltIndex == -1 ? key : key.substring(0, spiltIndex);
			if (spiltIndex == -1) {
				retobj.put(firstkey, fromMap.get(firstkey));
			} else {
				JSONObject temp = new JSONObject();
				packJson(temp, key, fromMap.get(key));
				mergeJSON(retobj, temp, false);
			}
		}
		return retobj;
	}

	private static void packJson(JSONObject retobj, String key, Object value) {
		int spiltIndex = key.indexOf(".");
		if (spiltIndex == -1) {
			retobj.put(key, value);
		} else {
			String firstkey = key.substring(0, spiltIndex);
			JSONObject temp = retobj.containsKey(firstkey) ? retobj.getJSONObject(firstkey) : new JSONObject();
			retobj.put(firstkey, temp);
			String keyNext = key.substring(spiltIndex + 1);
			packJson(temp, keyNext, value);
		}
	}

	/**
	 * 把map转为string
	 * 
	 * @param fromMap 要转的map
	 * @return 转后的json
	 */
	public static String getJsonForMap(Map fromMap) {
		String str = JSON.toJSONString(fromMap, SerializerFeature.DisableCircularReferenceDetect);
		return str;
	}

	/****
	 * 返回格式 [{"itemCode":"checkNoPass","itemName":"质检不通过"},<br>
	 * { "itemCode":"checkPass","itemName":"质检通过"}]
	 * 
	 * @param fromList 要取的源数据,支持Map和Object对象
	 * @param converts 要转换的规则，可以为空，与title要一一对应
	 * @param titles   要取的标题，支持别名，<br>
	 *                 如：new String[]{""itemCode,itemCode","itemName_zh,itemName""}
	 *                 <br>
	 *                 itemName_zh为是取值的列名,itemName要显示的列名
	 * 
	 * @return json格式字符串
	 */
	public static String getJsonForList(List<?> fromList, IConvertValue<String>[] converts, String... titles) {
		if (CollectionUtils.isEmpty(fromList) || ArrayUtils.isEmpty(titles)) {
			return "[]";
		}
		StringBuffer buff = new StringBuffer("[");
		for (Object object : fromList) {
			if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
				String singJoson = getJsonForMap((Map) object, converts, titles);
				buff.append(singJoson + ",");
			} else {
				StringBuffer jsonTempStr = new StringBuffer("@{'{");
				for (int i = 0; i < titles.length; i++) {
					String[] titleAry = titles[i].split(",");
					String valCol = StringUtil.trimSpace(titleAry[0]);
					String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
					if (StringUtil.isNull(valCol)) {
						jsonTempStr.append("\"" + showCol + "\":\"\"");
					} else {
						jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
					}
					if (i != titles.length - 1) {
						jsonTempStr.append(",");
					}
				}
				jsonTempStr.append("}'}");
				// 通过规则转换字符
				String tempStr = String.valueOf(TemplateRuntime.eval(jsonTempStr.toString(), object));
				if (ArrayUtils.isNotEmpty(converts)) {
					JSONObject jsObj = JSONObject.parseObject(tempStr);
					for (int i = 0; i < converts.length; i++) {
						IConvertValue convert = converts[i];
						String colName = i < titles.length ? titles[i] : null;
						if (convert != null && StringUtils.isNotBlank(colName)) {
							int index = colName.indexOf(",");
							String key = "";
							// String oriKey = "";
							if (index >= 0) {
								key = colName.substring(index + 1);
								// oriKey = colName.substring(0, index);
							} else {
								key = colName;
								// oriKey = colName;
							}
							String value = index == 0 ? convert.getStr(object) : convert.getStr(jsObj.getString(key));
							jsObj.put(key, value);
						}
					}
					tempStr = jsObj.toString();
				}
				for (int i = 0; i < specialChar_globle.length; i++) {
					String[] tempAry = specialChar_globle[i];
					tempStr = tempStr.replaceAll(tempAry[0], tempAry[1]);
				}
				buff.append(tempStr + ",");
			}
		}
		buff.delete(buff.length() - 1, buff.length());// 去除最后一个“,”
		buff.append("]");
		return buff.toString();
	}

	public static String getJsonForList(List<?> fromList, String... titles) {
		return getJsonForList(fromList, new IConvertValue[] {}, titles);
	}

	/***
	 * 用toString做为text和value
	 * 
	 * @param fromList 要转换的数据
	 * @return 转换后的json
	 */
	public static String getJsonForListSimple(List<?> fromList) {
		if (CollectionUtils.isEmpty(fromList)) {
			return "[]";
		}
		JSONArray array = new JSONArray();
		for (Object object : fromList) {
			String v = String.valueOf(object);
			array.add(JSONObject.parse(String.format("{\"text\":\"%s\",\"value\":\"%s\"}", v, v)));
		}
		return array.toJSONString();
	}

	/****
	 * 支持Map, Map &lt; String, IConvertValue &gt; key为title 如果是标题有别名方式：aaa,bbb <br>
	 * 则以别名主识别IConvertValue
	 * 
	 * @param fromList    要取的源数据,支持Map和Object对象
	 * @param convertsMap 转换器Map
	 * @param titles      标题
	 * @return json格式字符串
	 */
	public static String getJsonForList(List<?> fromList, Map<String, IConvertValue<String>> convertsMap,
			String... titles) {
		IConvertValue[] convert = null;
		if (convertsMap != null && CollectionUtils.isNotEmpty(convertsMap.keySet())) {
			convert = new IConvertValue[titles.length];
			for (String title : convertsMap.keySet()) {
				int index = -1;
				for (int i = 0; i < titles.length; i++) {
					String eleTitle = titles[i];
					if (StringUtils.isNotBlank(eleTitle)) {
						String[] tempTitleAry = eleTitle.split(",");
						String trueKey = tempTitleAry.length > 1 ? tempTitleAry[1] : tempTitleAry[0];
						if (title.equalsIgnoreCase(trueKey)) {
							index = i;
							break;
						}
					}
				}
				// int index = ArrayUtils.indexOf(titles, title);
				if (index >= 0) {
					convert[index] = convertsMap.get(title);
				}
			}
		}
		return getJsonForList(fromList, convert, titles);
	}

	/****
	 * 别名
	 * 
	 * @param fromList    要取的源数据,支持Map和Object对象
	 * @param aliasTitles 标题的别名
	 * @param convertsMap 要取的源数据,支持Map和Object对象
	 * @return json格式字符串
	 */
	public static String getJsonForListAlias(List<?> fromList, String[] aliasTitles,
			Map<String, IConvertValue<String>> convertsMap) {
		if (CollectionUtils.isEmpty(fromList)) {
			return "[]";
		}
		Object object = fromList.get(0);
		String[] titles = null;
		if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
			Map temp = (Map) object;
			titles = new String[temp.size()];
			int i = 0;
			for (Object keyObj : temp.keySet()) {
				titles[i++] = String.valueOf(keyObj);
			}
		} else {
			List<String> fields = ReflectAssist.findGetField(object.getClass());
			titles = fields.toArray(new String[fields.size()]);
		}
		if (aliasTitles != null && aliasTitles.length > 0) {
			titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles);
		}
		return getJsonForList(fromList, convertsMap, titles);
	}

	public static String getJsonForListAlias(List<?> fromList) {
		return getJsonForListAlias(fromList, null, null);
	}

	/***
	 * 格式化字符串，可以去除空格 和 换行符等\n
	 * 
	 * @param jsonstr 原始字符串
	 * @return 格式化后字符串
	 */
	public static String formateJson(String jsonstr) {
		try {
			JSONObject obj = JSONObject.parseObject(jsonstr);
			return obj.toJSONString();
		} catch (Exception e) {
			return StringUtil.trimSpace(jsonstr);
		}
	}

	/***
	 * 打包参数
	 * 
	 * @param params 要处理的参数
	 * @return 打包后的json对象
	 */
	public static JSONObject packParams(Object... params) {
		JSONObject ret = new JSONObject();
		if (ArrayUtils.isEmpty(params) || params.length < 2) {
			return ret;
		}
		for (int i = 0; i < params.length / 2; i++) {
			Object key = params[2 * i];
			Object value = (2 * i + 1) < params.length ? params[2 * i + 1] : null;
			ret.put(String.valueOf(key), value);
		}
		return ret;
	}

	/***
	 * 打包为数组
	 * 
	 * @param arys 要打包的数据
	 * @return 打包后的Json数据
	 */
	public static JSONArray packAry(Object... arys) {
		JSONArray ret = new JSONArray();
		if (ArrayUtils.isEmpty(arys)) {
			return ret;
		}
		for (Object ary : arys) {
			ret.add(ary);
		}
		return ret;
	}

	/**
	 * 打包为数组
	 * 
	 * @param arys 要打包的数据
	 * @return 打包后的Json数据
	 */
	public static JSONArray packAry(String... arys) {
		JSONArray ret = new JSONArray();
		if (ArrayUtils.isEmpty(arys)) {
			return ret;
		}
		for (Object ary : arys) {
			ret.add(ary);
		}
		return ret;
	}

	/***
	 * 结果返回json信息
	 * 
	 * @param result 要打包的数据
	 * @return 打包后的Json
	 */
	public static JSONObject setResult(Result result) {
		JSONObject retjson = new JSONObject();
		if (result.isSuc()) {
			retjson.put(Response.errorValue, 1000);
			retjson.put(Response.errorDesc, "OK");
			retjson.put(Response.errorCode, "no");
			retjson.put(Response.http, "200");
		} else {
			IExcept iExcept = result.getExcept();
			retjson.put(Response.errorValue, iExcept.getErrorValue());
			retjson.put(Response.errorDesc, iExcept.getErrMsg());
			retjson.put(Response.errorCode, iExcept.getErrorCode());
			retjson.put(Response.http, iExcept.getHttp());
		}
		return retjson;
	}

	/***
	 * 转换返回的结果
	 */
	public static ResponseBean convertResponBean(JSONObject json) {
		ResponseBean retobj = new ResponseBean();
		retobj.setErrMsg(json.getString(Response.errMsg));
		json.remove(Response.errMsg);
		retobj.setErrorCode(json.getString(Response.errorCode));
		json.remove(Response.errorCode);
		retobj.setErrorDesc(json.getString(Response.errorDesc));
		json.remove(Response.errorDesc);
		retobj.setErrorValue(json.getString(Response.errorValue));
		json.remove(Response.errorValue);
		retobj.setHttp(json.getString(Response.http));
		json.remove(Response.http);
		ResponseInfoBean responseInfoBean = new ResponseInfoBean();
		JSONObject oriObj = json.getJSONObject(RespInfo._self);
		responseInfoBean.setMsgId(oriObj.getString(RespInfo.msgId));
		responseInfoBean.setMsgIdResp(oriObj.getString(RespInfo.msgIdResp));
		responseInfoBean.setReceiptApplication(oriObj.getString(RespInfo.receiptApplication));
		responseInfoBean.setReceiptSystem(oriObj.getString(RespInfo.receiptSystem));
		retobj.setRespInfo(responseInfoBean);
		json.remove(RespInfo._self);
		retobj.setBusiJson(json);
		return retobj;
	}

	/***
	 * double做特殊处理
	 * 
	 * @param object
	 * @return
	 */
	public static String toJSONStringForDouble(Object object) {
		SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
		tamsSerializeConfig.put(Double.class, new DoubleSerializerConfig(new DecimalFormat("0.00")));
		return JSONObject.toJSONString(object, tamsSerializeConfig);
	}

	public static Map<String, Object> jsonToMap(JSONObject json, String pre) {
		Map<String, Object> retmap = new HashMap<>();
		if (json == null) {
			return retmap;
		}
		String prestr = StringUtil.trimSpace(StringUtil.hasNull(pre, ""));
		for (String key : json.keySet()) {
			String keytrue = key.startsWith(prestr) ? key : prestr + key;
			retmap.put(keytrue, json.get(key));
		}
		return retmap;
	}

	public static Map<String, Object> jsonToMap(JSONObject json) {
		return jsonToMap(json, null);
	}

	public static JSONObject getJsonForObject(Object object) {
		return getJsonForObject(object, null, null, null);
	}

	// 拿到对象的json
	public static JSONObject getJsonForObject(Object object, IConvertValue<String>[] converts, String[] titles,
			String[] aliasTitles) {
		if (ArrayUtils.isEmpty(titles)) {
			List<String> fields = ReflectAssist.findGetField(object.getClass());
			titles = fields.toArray(new String[fields.size()]);
		}

		if (aliasTitles != null && aliasTitles.length > 0) {
			titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles);
		}
		String singJoson = null;
		if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
			singJoson = getJsonForMap((Map) object, converts, titles);
		} else {
			StringBuffer jsonTempStr = new StringBuffer("@{'{");
			for (int i = 0; i < titles.length; i++) {
				String[] titleAry = titles[i].split(",");
				String valCol = StringUtil.trimSpace(titleAry[0]);
				String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
				if (StringUtil.isNull(valCol)) {
					jsonTempStr.append("\"" + showCol + "\":\"\"");
				} else {
					jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
				}
				if (i != titles.length - 1) {
					jsonTempStr.append(",");
				}
			}
			jsonTempStr.append("}'}");
			// 通过规则转换字符
			singJoson = String.valueOf(TemplateRuntime.eval(jsonTempStr.toString(), object));
			for (int i = 0; i < specialChar_globle.length; i++) {
				String[] tempAry = specialChar_globle[i];
				singJoson = singJoson.replaceAll(tempAry[0], tempAry[1]);
			}
		}
		JSONObject jsObj = JSONObject.parseObject(singJoson);
		if (ArrayUtils.isNotEmpty(converts)) {
			for (int i = 0; i < converts.length; i++) {
				IConvertValue convert = converts[i];
				String colName = i < titles.length ? titles[i] : null;
				if (convert != null && StringUtils.isNotBlank(colName)) {
					int index = colName.indexOf(",");
					String key = "";
					// String oriKey = "";
					if (index >= 0) {
						key = colName.substring(index + 1);
						// oriKey = colName.substring(0, index);
					} else {
						key = colName;
						// oriKey = colName;
					}
					String value = index == 0 ? convert.getStr(object) : convert.getStr(jsObj.getString(key));
					jsObj.put(key, value);
				}
			}
		}
		return jsObj;
	}

	public static JSONArray getJsonArrayFromEnum(String enumClass, String lan, final String[] includes,
			final String[] removes) {
		Class cls = null;
		try {
			cls = (Class<Enum>) Class.forName(enumClass);
		} catch (ClassNotFoundException e) {
			log.error("类加载错误");
			return null;
		}
		Object[] objs = cls.getEnumConstants();
		if (ArrayUtils.isEmpty(objs)) {
			return JSONArray.parseArray("[]");
		} else {
			List<Object> list = Arrays.asList(objs);
			// 包括项
			if (ArrayUtils.isNotEmpty(includes)) {
				list = (List<Object>) CollectionUtils.select(list, new Predicate() {
					@Override
					public boolean evaluate(Object object) {
						Enum temobj = (Enum) object;
						return ArrayUtils.contains(includes, temobj.name());
					}
				});
			}
			// 排除项
			if (ArrayUtils.isNotEmpty(removes)) {
				CollectionUtils.filter(list, new Predicate() {
					@Override
					public boolean evaluate(Object object) {
						Enum temobj = (Enum) object;
						return !ArrayUtils.contains(removes, temobj.name());
					}
				});

			}
			String filedName = StringUtil.isNull(lan) ? "desc" : String.format("desc_%s", lan);
			IConvertValue<String> cv = new ConvertValueEnum(list.toArray(), lan);
			String curData = JSONUtil.getJsonForList(list, new IConvertValue[] { null, cv }, "name,",
					filedName + ",text");
			return JSONArray.parseArray(curData);
		}
	}

	public static JSONArray getJsonArrayFromEnum(String enumClass) {
		return getJsonArrayFromEnum(enumClass, null, null, null);
	}

	// TODO 后续加上https://blog.csdn.net/u012916291/article/details/70742044
	public static final String[][] specialChar_value_json = new String[][] { { "\"", "\\\\\"" } };

	/**
	 * 转换特别字符,这样json就可以格式化成功
	 * 
	 * @param oriStr
	 * @return
	 */
	public static String convertJsonValue(String oriStr) {
		String retStr = oriStr;
		for (String[] specialChar : specialChar_value_json) {
			retStr = retStr.replace(specialChar[0], specialChar[1]);
		}
		return retStr;
	}

}
