package net.wicp.tams.common.apiext;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class FreemarkUtil {
	private final static FreemarkUtil inst = new FreemarkUtil();

	private FreemarkUtil() {
	}

	public static FreemarkUtil getInst() {
		// 默认添加一个StringLoader
		StringTemplateLoader stringLoader = new StringTemplateLoader();
		TemplateLoader[] defaultLoads = new TemplateLoader[] { stringLoader };
		inst.addLoads(defaultLoads);
		return inst;
	}

	private Configuration cfg;
	private TemplateLoader[] curLoads;

	public synchronized void addLoads(TemplateLoader... templateLoader) {
		curLoads = ArrayUtils.addAll(curLoads, templateLoader);
		cfg = new Configuration(Configuration.VERSION_2_3_23);
		cfg.setDefaultEncoding("utf-8");
		MultiTemplateLoader mtl = new MultiTemplateLoader(curLoads);
		cfg.setTemplateLoader(mtl);
	}

	public TemplateLoader getLoad(int index) {
		return getLoad().getTemplateLoader(index);
	}

	public StringTemplateLoader getLoadStr() {
		return (StringTemplateLoader) getLoad(0);
	}

	public MultiTemplateLoader getLoad() {
		return (MultiTemplateLoader) cfg.getTemplateLoader();
	}

	public String getTempStr(String name) {
		try {
			Object source = getLoad().findTemplateSource(name);
			Reader reader = getLoad().getReader(source, "utf-8");
			String dest = IOUtils.toString(reader);
			return dest;
		} catch (Exception e) {
			log.error("获取模板错误", e);
			throw new RuntimeException("获取模板" + name + "错误");
		}
	}

	public long getTempLastTime(String name) {
		Object source;
		try {
			source = getLoad().findTemplateSource(name);
			return getLoad().getLastModified(source);
		} catch (IOException e) {
			log.error("获取模板错误", e);
			throw new RuntimeException("获取模板" + name + "错误");
		}
	}

	/***
	 * 由于放入template需要一些时间，不能立马拿到，可能需要一些重试 测试需要5S左右拿到模板
	 * 
	 * @param name
	 * @param retry
	 * @return
	 */
	@SuppressWarnings("static-access")
	public Template getTemplate(String name, boolean retry) {
		Template template = null;
		try {
			template = cfg.getTemplate(name);
			return template;
		} catch (Exception e) {
			if (retry && template == null) {
				for (int i = 0; i < 20; i++) {
					try {
						Thread.currentThread().sleep(500);
						template = cfg.getTemplate(name);
						return template;
					} catch (Exception e2) {
					}
					if (template != null) {
						break;
					}
				}
			}
			log.info("first hasnot template:{}", name);
			return null;
		}
	}

	/***
	 * 通过数据处理模板
	 * 
	 * @param tempStr 模板内容
	 * @param datamap 代入数据
	 * @return
	 */
	public String doProcessByTemp(String tempStr, Object datamap) {
		String key = PwdUtil.MD5(tempStr);
		Template template = getTemplate(key, false);
		if (template == null) {
			getLoadStr().putTemplate(key, tempStr);
			template = getTemplate(key, true);
		}
		return doProcess(template, datamap);
	}

	/***
	 * 
	 * @param name
	 * @param dataModel
	 * @return
	 */
	public String doProcess(String name, Object dataModel) {
		Template template = getTemplate(name, false);
		return doProcess(template, dataModel);
	}

	public String doProcess(Template template, Object dataModel) {
		// Template template = getTemplate(name, false);
		StringWriter out = new StringWriter();
		try {
			template.process(dataModel, out);
			return out.toString();
		} catch (Exception e) {
			log.error("处理错误,模板:" + template.getName(), e);
			throw new RuntimeException("处理错误,模板:" + template.getName());
		}
	}

}
