/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.constant;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TarUtil;
import net.wicp.tams.common.callback.IRemote;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PathType {
    web("web\u6839\u76ee\u5f55", true),
    clp("classpath\u6839\u76ee\u5f55", true),
    rel("\u76f8\u5bf9\u4e8eclass\u7684\u8def\u5f84", true),
    abs("\u7edd\u5bf9\u8def\u5f84", true),
    env("\u73af\u5883\u53d8\u91cf\u7684\u5730\u5740", true),
    s3("s3\u7f51\u7edc\u5b58\u50a8", false, "net.wicp.tams.common.aws.TamsRemoteImpl"),
    oss("oss\u5b58\u50a8", false);

    private final Logger log = LoggerFactory.getLogger(PathType.class);
    private final String desc;
    private final boolean isLocal;
    private final IRemote remote;

    public IRemote getRemote() {
        return this.remote;
    }

    private PathType(String desc, boolean isLocal, String remoteClass) {
        this.desc = desc;
        this.isLocal = isLocal;
        if (StringUtil.isNotNull(remoteClass)) {
            IRemote remote3 = null;
            try {
                remote3 = (IRemote)Class.forName(remoteClass).newInstance();
            }
            catch (Exception e) {
                this.log.warn("the class [{}] no find", (Object)remoteClass);
            }
            this.remote = remote3;
        } else {
            this.remote = null;
        }
    }

    private PathType(String desc, boolean isLocal) {
        this(desc, isLocal, null);
    }

    private static String getPath(String inputpath, String splitchar) {
        Object inputpathStr;
        if (StringUtil.isNull(inputpath)) {
            return "";
        }
        Object[] inputpathary = inputpath.split(splitchar = StringUtil.hasNull(splitchar, ":"));
        if (ArrayUtils.isEmpty((Object[])inputpathary)) {
            return "";
        }
        String PathTypeStr = inputpathary.length > 1 ? inputpathary[0] : "";
        PathType pathType = PathType.getByName(PathTypeStr);
        Object object = inputpathStr = inputpathary.length > 1 ? inputpathary[1] : inputpathary[0];
        if (pathType == abs) {
            inputpathStr = inputpath.replace("abs:", "");
        }
        inputpathStr = ((String)inputpathStr).replace("//", "/");
        if (!pathType.isLocal) {
            String dirName;
            if (pathType.getRemote() == null) {
                throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u7684\u5b9e\u73b0\u7c7b\uff0cs3\u5f15\u5165common-aws\u5305");
            }
            String path = IOUtil.mergeFolderAndFilePath(System.getProperty("user.home"), new String[]{".tams"});
            String lastDir = IOUtil.mergeFolderAndFilePath(path, new String[]{dirName = ((String)inputpathStr).substring(((String)inputpathStr).lastIndexOf("/") + 1).replace(".tar", "")});
            File lastFile = new File(lastDir);
            if (lastFile.exists()) {
                return lastDir;
            }
            try {
                InputStream findStream = pathType.getRemote().findStream((String)inputpathStr);
                TarUtil.decompress(findStream, path);
                return IOUtil.mergeFolderAndFilePath(path, new String[]{dirName});
            }
            catch (Exception e) {
                throw new RuntimeException("download the remote file error", e);
            }
        }
        Object retstr = inputpathStr;
        switch (pathType) {
            case web: {
                URL classpathurl = Thread.currentThread().getContextClassLoader().getResource("");
                File file = new File(classpathurl.getPath());
                String webrootstr = file.getParentFile().getParentFile().getPath();
                retstr = IOUtil.mergeFolderAndFilePath(webrootstr, new String[]{inputpathStr});
                break;
            }
            case clp: {
                URL classpath = Thread.currentThread().getContextClassLoader().getResource("");
                retstr = IOUtil.mergeFolderAndFilePath(classpath.getPath(), new String[]{inputpathStr});
                break;
            }
            case rel: {
                URL classpathrel = Thread.currentThread().getContextClassLoader().getResource(".");
                retstr = IOUtil.mergeFolderAndFilePath(classpathrel.getPath(), new String[]{inputpathStr});
                break;
            }
            case abs: {
                retstr = inputpathStr;
                break;
            }
            case env: {
                String envpath = System.getenv((String)inputpathStr);
                if (inputpathary.length == 2) {
                    retstr = envpath;
                    break;
                }
                retstr = IOUtil.mergeFolderAndFilePath(envpath, new String[]{inputpathary[2]});
                break;
            }
        }
        return retstr;
    }

    public static String getPath(String inputpath) {
        return PathType.getPath(inputpath, ":");
    }

    public static PathType getByName(String inputpath) {
        if (StringUtil.isNull(inputpath)) {
            return clp;
        }
        Object[] inputpathary = inputpath.split(":");
        if (ArrayUtils.isEmpty((Object[])inputpathary)) {
            return clp;
        }
        Object PathTypeStr = inputpathary[0];
        for (PathType ele : PathType.values()) {
            if (!((String)PathTypeStr).equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return clp;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isLocal() {
        return this.isLocal;
    }
}

