/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.serializerconfig.DoubleSerializerConfig;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.exception.IExcept;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.templates.TemplateRuntime;

public abstract class JSONUtil {
    public static final String[][] specialChar = new String[][]{{"\\\\", "\\\\\\\\"}, {"\"null\"", "\"\""}};

    public static <T> T getBeanFromJson(Class<T> clazz, JSONObject packParams) {
        try {
            T retobj = clazz.newInstance();
            if (packParams.size() == 0) {
                return retobj;
            }
            for (String key : packParams.keySet()) {
                StringUtil.packObj(retobj, key, packParams.getString(key));
            }
            return retobj;
        }
        catch (Exception e) {
            throw new IllegalAccessError("request\u8f6c\u4e3a\u4e1a\u52a1\u5bf9\u8c61\u65f6\u5f02\u5e38" + e.getMessage());
        }
    }

    public static JSONObject getJsonFromUrlStr(String url) {
        String[] params;
        JSONObject retobj = new JSONObject();
        if (StringUtil.isNull(url)) {
            return retobj;
        }
        for (String param : params = url.split("&")) {
            String[] temAry = param.split("=");
            if (temAry.length > 1) {
                retobj.put(temAry[0], (Object)temAry[1]);
                continue;
            }
            retobj.put(temAry[0], (Object)"");
        }
        return retobj;
    }

    public static JSONObject mergeJSON(JSONObject main, JSONObject add) {
        JSONUtil.mergeJSON(main, add, false);
        return main;
    }

    public static JSONObject mergeJSON(JSONObject res1, JSONObject res2, boolean fast) {
        JSONObject addJSON;
        JSONObject jSONObject = fast ? (res1.keySet().size() < res2.keySet().size() ? res1 : res2) : (addJSON = res2);
        JSONObject mainJSON = fast ? (res1.keySet().size() < res2.keySet().size() ? res2 : res1) : res1;
        for (String key : addJSON.keySet()) {
            if (mainJSON.containsKey((Object)key)) {
                try {
                    if (mainJSON.getJSONObject(key).size() <= 0 || addJSON.getJSONObject(key).size() <= 0) continue;
                    JSONUtil.mergeJSON(mainJSON.getJSONObject(key), addJSON.getJSONObject(key), fast);
                }
                catch (Exception e) {
                    mainJSON.put(key, addJSON.get((Object)key));
                }
                continue;
            }
            mainJSON.put(key, addJSON.get((Object)key));
        }
        return mainJSON;
    }

    public static List<String[]> getValues(JSONObject jsonObject) {
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        for (String key : jsonObject.keySet()) {
            resultList.add(new String[]{key, String.valueOf(jsonObject.get((Object)key))});
        }
        return resultList;
    }

    public static String getJsonForMap(Map<String, Object> fromMap, IConvertValue[] convert, String ... keys) {
        if (fromMap == null || fromMap.size() == 0) {
            return null;
        }
        keys = ArrayUtils.isNotEmpty((Object[])keys) ? keys : (String[])fromMap.keySet().toArray();
        StringBuffer buff = new StringBuffer("{");
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String[] keyAry = key.split(",");
            String valCol = StringUtil.trimSpace(keyAry[0]);
            String showCol = StringUtil.trimSpace(keyAry[keyAry.length - 1]);
            Map<String, Object> value = StringUtil.isNull(valCol) ? fromMap : fromMap.get(valCol);
            String valueTrue = "";
            if (convert != null && convert.length > i && convert[i] != null) {
                IConvertValue convertTrue = convert[i];
                valueTrue = value == null ? "" : convertTrue.getStr(value);
            } else {
                String string = valueTrue = StringUtil.isNull(valCol) ? "" : String.valueOf(value);
            }
            if (i != 0) {
                buff.append(",");
            }
            buff.append("\"" + showCol + "\":\"" + StringUtil.hasNull(valueTrue) + "\"");
        }
        buff.append("}");
        return buff.toString();
    }

    public static String getJsonForMap(Map<String, Object> fromMap, String ... keys) {
        return JSONUtil.getJsonForMap(fromMap, null, keys);
    }

    public static JSONObject getJsonForMapFlat(Map<String, Object> fromMap) {
        JSONObject retobj = new JSONObject();
        if (MapUtils.isEmpty(fromMap)) {
            return retobj;
        }
        for (String key : fromMap.keySet()) {
            String firstkey;
            int spiltIndex = key.indexOf(".");
            String string = firstkey = spiltIndex == -1 ? key : key.substring(0, spiltIndex);
            if (spiltIndex == -1) {
                retobj.put(firstkey, fromMap.get(firstkey));
                continue;
            }
            JSONObject temp = new JSONObject();
            JSONUtil.packJson(temp, key, fromMap.get(key));
            JSONUtil.mergeJSON(retobj, temp, false);
        }
        return retobj;
    }

    private static void packJson(JSONObject retobj, String key, Object value) {
        int spiltIndex = key.indexOf(".");
        if (spiltIndex == -1) {
            retobj.put(key, value);
        } else {
            String firstkey = key.substring(0, spiltIndex);
            JSONObject temp = retobj.containsKey((Object)firstkey) ? retobj.getJSONObject(firstkey) : new JSONObject();
            retobj.put(firstkey, (Object)temp);
            String keyNext = key.substring(spiltIndex + 1);
            JSONUtil.packJson(temp, keyNext, value);
        }
    }

    public static String getJsonForMap(Map fromMap) {
        String str = JSON.toJSONString((Object)fromMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        return str;
    }

    public static String getJsonForList(List<?> fromList, IConvertValue<String>[] converts, String ... titles) {
        if (CollectionUtils.isEmpty(fromList) || ArrayUtils.isEmpty((Object[])titles)) {
            return "[]";
        }
        StringBuffer buff = new StringBuffer("[");
        for (Object object : fromList) {
            if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
                String singJoson = JSONUtil.getJsonForMap((Map<String, Object>)((Map)object), converts, titles);
                buff.append(singJoson + ",");
                continue;
            }
            StringBuffer jsonTempStr = new StringBuffer("@{'{");
            for (int i = 0; i < titles.length; ++i) {
                String[] titleAry = titles[i].split(",");
                String valCol = StringUtil.trimSpace(titleAry[0]);
                String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
                if (StringUtil.isNull(valCol)) {
                    jsonTempStr.append("\"" + showCol + "\":\"\"");
                } else {
                    jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
                }
                if (i == titles.length - 1) continue;
                jsonTempStr.append(",");
            }
            jsonTempStr.append("}'}");
            String tempStr = String.valueOf(TemplateRuntime.eval((String)jsonTempStr.toString(), object));
            if (ArrayUtils.isNotEmpty((Object[])converts)) {
                JSONObject jsObj = JSONObject.parseObject((String)tempStr);
                for (int i = 0; i < converts.length; ++i) {
                    String colName;
                    IConvertValue<String> convert = converts[i];
                    String string = colName = i < titles.length ? titles[i] : null;
                    if (convert == null || !StringUtils.isNotBlank((CharSequence)colName)) continue;
                    int index = colName.indexOf(",");
                    String key = "";
                    key = index >= 0 ? colName.substring(index + 1) : colName;
                    String value = index == 0 ? convert.getStr((String)object) : convert.getStr(jsObj.getString(key));
                    jsObj.put(key, (Object)value);
                }
                tempStr = jsObj.toString();
            }
            for (int i = 0; i < specialChar.length; ++i) {
                String[] tempAry = specialChar[i];
                tempStr = tempStr.replaceAll(tempAry[0], tempAry[1]);
            }
            buff.append(tempStr + ",");
        }
        buff.delete(buff.length() - 1, buff.length());
        buff.append("]");
        return buff.toString();
    }

    public static String getJsonForList(List<?> fromList, String ... titles) {
        return JSONUtil.getJsonForList(fromList, new IConvertValue[0], titles);
    }

    public static String getJsonForListSimple(List<?> fromList) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        JSONArray array = new JSONArray();
        for (Object object : fromList) {
            String v = String.valueOf(object);
            array.add(JSONObject.parse((String)String.format("{\"text\":\"%s\",\"value\":\"%s\"}", v, v)));
        }
        return array.toJSONString();
    }

    public static String getJsonForList(List<?> fromList, Map<String, IConvertValue<String>> convertsMap, String ... titles) {
        IConvertValue[] convert = null;
        if (convertsMap != null && CollectionUtils.isNotEmpty(convertsMap.keySet())) {
            convert = new IConvertValue[titles.length];
            for (String title : convertsMap.keySet()) {
                int index = -1;
                for (int i = 0; i < titles.length; ++i) {
                    String trueKey;
                    String eleTitle = titles[i];
                    if (!StringUtils.isNotBlank((CharSequence)eleTitle)) continue;
                    String[] tempTitleAry = eleTitle.split(",");
                    String string = trueKey = tempTitleAry.length > 1 ? tempTitleAry[1] : tempTitleAry[0];
                    if (!title.equalsIgnoreCase(trueKey)) continue;
                    index = i;
                    break;
                }
                if (index < 0) continue;
                convert[index] = convertsMap.get(title);
            }
        }
        return JSONUtil.getJsonForList(fromList, convert, titles);
    }

    public static String getJsonForListAlias(List<?> fromList, String[] aliasTitles, Map<String, IConvertValue<String>> convertsMap) {
        if (CollectionUtils.isEmpty(fromList)) {
            return "[]";
        }
        Object object = fromList.get(0);
        String[] titles = null;
        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
            Map temp = (Map)object;
            titles = new String[temp.size()];
            int i = 0;
            for (Object keyObj : temp.keySet()) {
                titles[i++] = String.valueOf(keyObj);
            }
        } else {
            List<String> fields = ReflectAssist.findGetField(object.getClass());
            titles = fields.toArray(new String[fields.size()]);
        }
        if (aliasTitles != null && aliasTitles.length > 0) {
            titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles);
        }
        return JSONUtil.getJsonForList(fromList, convertsMap, titles);
    }

    public static String getJsonForListAlias(List<?> fromList) {
        return JSONUtil.getJsonForListAlias(fromList, null, null);
    }

    public static String formateJson(String jsonstr) {
        try {
            JSONObject obj = JSONObject.parseObject((String)jsonstr);
            return obj.toJSONString();
        }
        catch (Exception e) {
            return StringUtil.trimSpace(jsonstr);
        }
    }

    public static JSONObject packParams(Object ... params) {
        JSONObject ret = new JSONObject();
        if (ArrayUtils.isEmpty((Object[])params) || params.length < 2) {
            return ret;
        }
        for (int i = 0; i < params.length / 2; ++i) {
            Object key = params[2 * i];
            Object value = 2 * i + 1 < params.length ? params[2 * i + 1] : null;
            ret.put(String.valueOf(key), value);
        }
        return ret;
    }

    public static JSONArray packAry(Object ... arys) {
        JSONArray ret = new JSONArray();
        if (ArrayUtils.isEmpty((Object[])arys)) {
            return ret;
        }
        for (Object ary : arys) {
            ret.add(ary);
        }
        return ret;
    }

    public static JSONArray packAry(String ... arys) {
        JSONArray ret = new JSONArray();
        if (ArrayUtils.isEmpty((Object[])arys)) {
            return ret;
        }
        for (String ary : arys) {
            ret.add((Object)ary);
        }
        return ret;
    }

    public static JSONObject setResult(Result result) {
        JSONObject retjson = new JSONObject();
        if (result.isSuc()) {
            retjson.put("errorValue", (Object)1000);
            retjson.put("errorDesc", (Object)"OK");
            retjson.put("errorCode", (Object)"no");
            retjson.put("http", (Object)"200");
        } else {
            IExcept iExcept = result.getExcept();
            retjson.put("errorValue", (Object)iExcept.getErrorValue());
            retjson.put("errorDesc", (Object)iExcept.getErrMsg());
            retjson.put("errorCode", (Object)iExcept.getErrorCode());
            retjson.put("http", (Object)iExcept.getHttp());
        }
        return retjson;
    }

    public static String toJSONStringForDouble(Object object) {
        SerializeConfig tamsSerializeConfig = SerializeConfig.getGlobalInstance();
        tamsSerializeConfig.put(Double.class, (ObjectSerializer)new DoubleSerializerConfig(new DecimalFormat("0.00")));
        return JSONObject.toJSONString((Object)object, (SerializeConfig)tamsSerializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Map<String, Object> jsonToMap(JSONObject json) {
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        if (json == null) {
            return retmap;
        }
        for (String key : json.keySet()) {
            retmap.put(key, json.get((Object)key));
        }
        return retmap;
    }

    public static JSONObject getJsonForObject(Object object) {
        return JSONUtil.getJsonForObject(object, null, null, null);
    }

    public static JSONObject getJsonForObject(Object object, IConvertValue<String>[] converts, String[] titles, String[] aliasTitles) {
        int i;
        if (ArrayUtils.isEmpty((Object[])titles)) {
            List<String> fields = ReflectAssist.findGetField(object.getClass());
            titles = fields.toArray(new String[fields.size()]);
        }
        if (aliasTitles != null && aliasTitles.length > 0) {
            titles = CollectionUtil.arrayMerge(String[].class, titles, aliasTitles);
        }
        String singJoson = null;
        if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
            singJoson = JSONUtil.getJsonForMap((Map<String, Object>)((Map)object), converts, titles);
        } else {
            StringBuffer jsonTempStr = new StringBuffer("@{'{");
            for (i = 0; i < titles.length; ++i) {
                String[] titleAry = titles[i].split(",");
                String valCol = StringUtil.trimSpace(titleAry[0]);
                String showCol = StringUtil.trimSpace(titleAry[titleAry.length - 1]);
                if (StringUtil.isNull(valCol)) {
                    jsonTempStr.append("\"" + showCol + "\":\"\"");
                } else {
                    jsonTempStr.append("\"" + showCol + "\":\"'+" + valCol + "+'\"");
                }
                if (i == titles.length - 1) continue;
                jsonTempStr.append(",");
            }
            jsonTempStr.append("}'}");
            singJoson = String.valueOf(TemplateRuntime.eval((String)jsonTempStr.toString(), (Object)object));
            for (i = 0; i < specialChar.length; ++i) {
                String[] tempAry = specialChar[i];
                singJoson = singJoson.replaceAll(tempAry[0], tempAry[1]);
            }
        }
        JSONObject jsObj = JSONObject.parseObject((String)singJoson);
        if (ArrayUtils.isNotEmpty((Object[])converts)) {
            for (i = 0; i < converts.length; ++i) {
                String colName;
                IConvertValue<String> convert = converts[i];
                String string = colName = i < titles.length ? titles[i] : null;
                if (convert == null || !StringUtils.isNotBlank((CharSequence)colName)) continue;
                int index = colName.indexOf(",");
                String key = "";
                key = index >= 0 ? colName.substring(index + 1) : colName;
                String value = index == 0 ? convert.getStr((String)object) : convert.getStr(jsObj.getString(key));
                jsObj.put(key, (Object)value);
            }
        }
        return jsObj;
    }
}

