/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext.jdbc;

import com.google.protobuf.ProtocolStringList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcData;
import net.wicp.tams.common.apiext.jdbc.JdbcDatas;
import net.wicp.tams.common.apiext.jdbc.OptType;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.constant.dbType.BinlogType;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MySqlAssit {
    private static final Logger log = LoggerFactory.getLogger(MySqlAssit.class);

    public static String getColsForQuery(String[] cols) {
        String colsstr = "`" + CollectionUtil.arrayJoin(cols, "`,`") + "`";
        return colsstr;
    }

    public static List<String[]> getAllTables(Connection conn) {
        return MySqlAssit.getAllTables(conn, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getAllTables(Connection conn, String dbPattern, String tbPattern) {
        String sql = "select  TABLE_SCHEMA,TABLE_NAME from information_schema.tables where 1=1";
        ResultSet rs = JdbcAssit.querySql(conn, sql);
        ArrayList<String[]> retlist = new ArrayList<String[]>();
        try {
            while (rs.next()) {
                boolean isChecked;
                if (StringUtil.isNotNull(dbPattern) && !(isChecked = StrPattern.checkStrFormat(dbPattern, rs.getString("TABLE_SCHEMA"))) || StringUtil.isNotNull(tbPattern) && !(isChecked = StrPattern.checkStrFormat(tbPattern, rs.getString("TABLE_NAME")))) continue;
                retlist.add(new String[]{rs.getString("TABLE_SCHEMA"), rs.getString("TABLE_NAME")});
            }
        }
        catch (Exception e) {
            log.error("find tables error", (Throwable)e);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return retlist;
    }

    public static Result dataUpset(Connection conn, String db, String tb, Object[][] datas, String[] cols, BinlogType[] typeAry, boolean batch) {
        Object[][] priDatas = new Object[datas.length][];
        try {
            Object[] tempAry = new String[cols.length];
            for (int i = 0; i < tempAry.length; ++i) {
                tempAry[i] = "?";
            }
            String sql = String.format("replace into %s.%s (%s) values (%s)", db, tb, MySqlAssit.getColsForQuery(cols), CollectionUtil.arrayJoin(tempAry, ","));
            PreparedStatement stmt = conn.prepareStatement(sql);
            if (batch) {
                conn.setAutoCommit(false);
                stmt.clearBatch();
                for (int i = 0; i < datas.length; ++i) {
                    int indexOf;
                    if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                    JdbcAssit.setPreParam(stmt, typeAry, datas[i]);
                    stmt.addBatch();
                }
                stmt.executeBatch();
                conn.commit();
            } else {
                conn.setAutoCommit(true);
                for (int i = 0; i < datas.length; ++i) {
                    int indexOf;
                    if (i < datas.length - 1 && (indexOf = CollectionUtil.indexOf(priDatas, priDatas[i], i + 1)) >= 0) continue;
                    JdbcAssit.setPreParam(stmt, typeAry, datas[i]);
                    stmt.execute();
                }
            }
            stmt.close();
            return Result.getSuc();
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63d2\u5165\u5931\u8d25", (Throwable)e);
            return new Result(ExceptAll.jdbc_exec_fail);
        }
    }

    public static Result dataUpset(Connection conn, JdbcDatas datas, boolean batch) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getColsCount()];
            for (int j = 0; j < datas.getColsCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getCols(j));
                if (value == null) {
                    datasInput[i][j] = value;
                    continue;
                }
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getCols(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                datasInput[i][j] = value2;
            }
        }
        Map<String, String> typeMap = datas.getTypeMap();
        ProtocolStringList colsList = datas.getColsList();
        BinlogType[] typeAry = new BinlogType[colsList.size()];
        for (int i = 0; i < typeAry.length; ++i) {
            typeAry[i] = BinlogType.valueOf(typeMap.get(colsList.get(i)));
        }
        return MySqlAssit.dataUpset(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getColsList().toArray((Object[])new String[datas.getColsList().size()]), typeAry, batch);
    }

    public static Result dataDelete(Connection conn, String db, String tb, Object[][] datas, String[] keys) {
        if (ArrayUtils.isEmpty((Object[])keys)) {
            keys = MySqlAssit.getPrimary(conn, db, tb);
        }
        if (!ArrayUtils.isEmpty((Object[])keys)) {
            StringBuilder builder = new StringBuilder(String.format("delete from %s.%s where 1=1", db, tb));
            for (String key : keys) {
                builder.append(String.format(" and %s=?", key));
            }
            try {
                conn.setAutoCommit(false);
                PreparedStatement stmtDel = conn.prepareStatement(builder.toString());
                for (int i = 0; i < datas.length; ++i) {
                    JdbcAssit.setPreParam(stmtDel, null, datas[i]);
                    stmtDel.addBatch();
                }
                stmtDel.executeBatch();
                conn.commit();
                stmtDel.close();
                return Result.getSuc();
            }
            catch (SQLException e) {
                log.error("\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25", (Throwable)e);
                return new Result(new ProjectException((IExcept)ExceptAll.jdbc_exec_fail, "\u901a\u8fc7\u4e3b\u952e\u5220\u9664\u5931\u8d25"));
            }
        }
        throw new ProjectExceptionRuntime(ExceptAll.jdbc_exec_fail);
    }

    public static Result dataDelete(Connection conn, JdbcDatas datas) {
        List<JdbcData> datasList = datas.getDatasList();
        Object[][] datasInput = new Object[datasList.size()][];
        for (int i = 0; i < datasList.size(); ++i) {
            JdbcData jdbcData = datasList.get(i);
            datasInput[i] = new Object[datas.getKeysCount()];
            for (int j = 0; j < datas.getKeysCount(); ++j) {
                String value = jdbcData.getValueMap().get(datas.getKeys(j));
                BinlogType binlogType = BinlogType.valueOf(datas.getTypeMap().get(datas.getKeys(j)));
                Object value2 = BinlogType.getValue(binlogType, value);
                datasInput[i][j] = value2;
            }
        }
        return MySqlAssit.dataDelete(conn, datas.getDb(), datas.getTb(), datasInput, (String[])datas.getKeysList().toArray((Object[])new String[datas.getKeysCount()]));
    }

    public static Result dataChange(Connection conn, JdbcDatas datas) {
        if (datas.getOptType() == OptType.delete) {
            return MySqlAssit.dataDelete(conn, datas);
        }
        return MySqlAssit.dataUpset(conn, datas, false);
    }

    public static String[] getPrimary(Connection conn, String db, String tb) {
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = conn.prepareStatement("SELECT k.column_name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING (constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=? AND t.table_name=?");
            JdbcAssit.setPreParam(preparedStatement, null, new Object[]{db, tb});
            ResultSet rs2 = preparedStatement.executeQuery();
            if (!rs2.next()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            ArrayList<String> retlist = new ArrayList<String>();
            retlist.add(rs2.getString(1));
            while (rs2.next()) {
                retlist.add(rs2.getString(1));
            }
            String[] stringArray = retlist.toArray(new String[retlist.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            log.error("\u67e5\u4e3b\u952e\u5931\u8d25");
            throw new ProjectExceptionRuntime(ExceptAll.jdbc_query_primary);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception e2) {
                log.error("\u5173\u95edpreparedStatement\u5931\u8d25", (Throwable)e2);
            }
        }
    }

    public static String[][] getCols(Connection conn, String db, String tb, YesOrNo isRds) {
        try {
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type   from  information_schema.columns  where  table_schema=? and table_name=? order by ORDINAL_POSITION");
            ArrayList<String> ret = new ArrayList<String>();
            ArrayList<String> retType = new ArrayList<String>();
            JdbcAssit.setPreParam(prepCols, null, new Object[]{db, tb});
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
                retType.add(rs.getString(2));
            }
            rs.close();
            if (CollectionUtils.isEmpty(ret)) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u6570\u636e\u4e3a\u5e93\u5b58\u5728\u5e93\u540d\uff1a[" + db + "],\u8868\u540d\uff1a[" + tb + "]");
            }
            if (YesOrNo.yes == isRds && ArrayUtils.isEmpty((Object[])MySqlAssit.getPrimary(conn, db, tb))) {
                ret.add("_rowkey_");
                retType.add("varchar");
            }
            String[][] retAry = new String[2][ret.size()];
            retAry[0] = ret.toArray(new String[ret.size()]);
            retAry[1] = retType.toArray(new String[retType.size()]);
            return retAry;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
    }

    public static List<Triple<String, String, String>> getColsNew(Connection conn, String db, String tb, YesOrNo isRds) {
        try {
            Triple data;
            PreparedStatement prepCols = conn.prepareStatement("select   column_name,data_type,column_type   from  information_schema.columns  where  table_schema=? and table_name=? order by ORDINAL_POSITION");
            ArrayList<Triple<String, String, String>> retlist = new ArrayList<Triple<String, String, String>>();
            JdbcAssit.setPreParam(prepCols, null, new Object[]{db, tb});
            ResultSet rs = prepCols.executeQuery();
            while (rs.next()) {
                data = Triple.of((Object)rs.getString(1), (Object)rs.getString(2), (Object)rs.getString(3));
                retlist.add((Triple<String, String, String>)data);
            }
            rs.close();
            if (CollectionUtils.isEmpty(retlist)) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u6570\u636e\u4e3a\u5e93\u5b58\u5728\u5e93\u540d\uff1a[" + db + "],\u8868\u540d\uff1a[" + tb + "]");
            }
            if (YesOrNo.yes == isRds && ArrayUtils.isEmpty((Object[])MySqlAssit.getPrimary(conn, db, tb))) {
                data = Triple.of((Object)"_rowkey_", (Object)"varchar", (Object)"varchar(255)");
                retlist.add((Triple<String, String, String>)data);
            }
            return retlist;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6cols\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6cols\u9519\u8bef");
        }
    }
}

