/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.apiext;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.NotFoundException;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TamsURLClassLoader;
import net.wicp.tams.common.constant.PathType;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderPlugin {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderPlugin.class);
    private TamsURLClassLoader classLoader;
    private final int maxLevel;
    private ClassPool pool = ClassPool.getDefault();
    private Set<String> jars = new HashSet<String>();

    public TamsURLClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<String> getJars() {
        return this.jars;
    }

    public ClassPool getPool() {
        return this.pool;
    }

    public void close() {
        try {
            if (this.classLoader != null) {
                this.classLoader.close();
            }
        }
        catch (IOException e) {
            log.error("\u5173\u95edclassLoader\u5931\u8d25", (Throwable)e);
        }
        finally {
            this.classLoader = null;
        }
    }

    public ClassLoaderPlugin(String jarfileDir, ClassLoader parent, int maxLevel) {
        this(new File(jarfileDir), parent, maxLevel);
        Validate.validState((boolean)new File(jarfileDir).exists(), (String)("classLoader\u63d2\u4ef6\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728:" + jarfileDir), (Object[])new Object[0]);
    }

    public static ClassLoader pluginClassLoader(String pluginDir, ClassLoader parent, int maxLevel) {
        ClassLoader retLoad = parent;
        if (StringUtil.isNull(pluginDir)) {
            log.error("\u63d2\u4ef6\u76ee\u5f55\u4e3a\u7a7a\u503c\uff0c\u4f7f\u7528\u7236\u7684classload");
            return parent;
        }
        String pathValue = PathType.getPath(pluginDir);
        if (StringUtil.isNull(pathValue)) {
            return parent;
        }
        ClassLoaderPlugin retLoadplugin = new ClassLoaderPlugin(pathValue, parent, 1);
        retLoad = retLoadplugin.getClassLoader();
        return retLoad;
    }

    public static ClassLoader pluginClassLoader(String pluginDir) {
        return ClassLoaderPlugin.pluginClassLoader(pluginDir, Thread.currentThread().getContextClassLoader(), 1);
    }

    public ClassLoaderPlugin(File jarfileDir) {
        this(jarfileDir, null, 1);
    }

    public ClassLoaderPlugin(File jarfileDir, ClassLoader parent, int maxLevel) {
        this.maxLevel = maxLevel;
        this.classLoader = this.createClassLoader(jarfileDir, parent);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }

    public void addToClassLoader(String baseDir, FileFilter filter) {
        File base = new File(baseDir);
        if (base != null && base.exists() && base.isDirectory()) {
            File[] files = base.listFiles(filter);
            if (files == null || files.length == 0) {
                log.warn("No files added to classloader from lib: " + baseDir + " (resolved as: " + base.getAbsolutePath() + ").");
            } else {
                this.classLoader = this.replaceClassLoader(this.classLoader, base, filter);
            }
        } else {
            log.warn("Can't find (or read) directory to add to classloader: " + baseDir + " (resolved as: " + base.getAbsolutePath() + ").");
        }
    }

    public void addToClassLoader(String baseDir) {
        this.addToClassLoader(baseDir, (FileFilter)new SuffixFileFilter(".jar"));
    }

    private TamsURLClassLoader createClassLoader(File libDir, ClassLoader parent) {
        if (null == parent) {
            parent = Thread.currentThread().getContextClassLoader();
        }
        return this.replaceClassLoader(new TamsURLClassLoader(new URL[0], parent), libDir, (FileFilter)new SuffixFileFilter(".jar"));
    }

    private void findElements(List<URL> inputURLs, File[] bases, FileFilter filter, int curlever) {
        if (curlever >= this.maxLevel) {
            return;
        }
        if (ArrayUtils.isEmpty((Object[])bases)) {
            return;
        }
        ArrayList<File> nextDirs = new ArrayList<File>();
        for (File base : bases) {
            if (null == base || !base.canRead() || !base.isDirectory()) continue;
            File[] files = base.listFiles(filter);
            if (null != files && files.length > 0) {
                for (int j = 0; j < files.length; ++j) {
                    try {
                        URL element = files[j].toURI().normalize().toURL();
                        inputURLs.add(element);
                        this.jars.add(files[j].getPath());
                        log.info("Adding '{}' to classloader", (Object)element.toString());
                        this.pool.appendClassPath(files[j].getPath());
                        log.info("Adding '{}' to pool", (Object)element.toString());
                        continue;
                    }
                    catch (MalformedURLException e) {
                        log.error("load jar file error", (Throwable)e);
                        throw new RuntimeException("load jar file error ");
                    }
                    catch (NotFoundException e) {
                        log.error("add jar to pool error", (Throwable)e);
                        throw new RuntimeException("pool addpath error ");
                    }
                }
            }
            if (curlever >= this.maxLevel - 1) continue;
            File[] listFiles = base.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            });
            nextDirs.addAll(Arrays.asList(listFiles));
        }
        this.findElements(inputURLs, nextDirs.toArray(new File[nextDirs.size()]), filter, ++curlever);
    }

    private TamsURLClassLoader replaceClassLoader(TamsURLClassLoader oldLoader, File base, FileFilter filter) {
        if (null != base && base.canRead() && base.isDirectory()) {
            ArrayList<URL> inputURLs = new ArrayList<URL>();
            for (URL url : oldLoader.getURLs()) {
                inputURLs.add(url);
            }
            this.findElements(inputURLs, new File[]{base}, filter, 0);
            if (inputURLs.size() == 0) {
                log.error("replaceClassLoader base dir:{} is empty", (Object)base.getAbsolutePath());
                return new TamsURLClassLoader(inputURLs.toArray(new URL[inputURLs.size()]), oldLoader.getParent());
            }
            ClassLoader oldParent = oldLoader.getParent();
            try {
                oldLoader.close();
            }
            catch (IOException e) {
                log.error("close classload error ", (Throwable)e);
            }
            return new TamsURLClassLoader(inputURLs.toArray(new URL[inputURLs.size()]), oldParent);
        }
        return new TamsURLClassLoader(new URL[0], oldLoader.getParent());
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }
}

