package net.wicp.tams.common.apiext;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mvel2.MVEL;

/**
 * 集合的简便操作方法
 * 
 * @author 偏锋书生
 *
 */
@SuppressWarnings({ "rawtypes", "unchecked" })
public abstract class CollectionUtil {
	public static int indexOf(Object[][] oriDatas, Object[] curData, int start) {
		if (oriDatas == null || oriDatas.length == 0 || curData == null) {
			return -1;
		}
		for (int i = start; i < oriDatas.length; i++) {
			Object[] oriData = oriDatas[i];
			if (oriData.length != curData.length) {
				continue;
			}
			boolean isEqual = true;
			for (int j = 0; j < oriData.length; j++) {
				if (!Objects.equals(oriData[j], curData[j])) {
					isEqual = false;
					break;
				}
			}
			if (isEqual) {
				return i;
			}
		}
		return -1;
	}

	/**
	 * 把List通过分隔符进行分隔
	 * 
	 * @param fromList 要连接的List
	 * @param joinStr  连接的字符串
	 * @return String 连接后字符串
	 */

	public static String listJoin(List<?> fromList, String joinStr) {
		if (CollectionUtils.isEmpty(fromList))
			return null;
		joinStr = StringUtils.isEmpty(joinStr) ? "," : joinStr;
		StringBuffer toList = new StringBuffer();
		Iterator iterator = fromList.iterator();
		toList.append(String.valueOf(iterator.next()));
		while (iterator.hasNext()) {
			String string = String.valueOf(iterator.next());
			toList.append(joinStr);
			toList.append(string);
		}
		return toList.toString();
	}

	/**
	 * 把Array通过分隔符进行分隔
	 * 
	 * @param fromList 要连接的数组
	 * @param joinStr  连接的字符串
	 * @return 连接后的字符串
	 */

	public static String arrayJoin(Object[] fromList, String joinStr) {
		if (ArrayUtils.isEmpty(fromList))
			return null;
		List<?> objlist = Arrays.asList(fromList);
		return listJoin(objlist, joinStr);
	}

	/****
	 * 数组的合并<br>
	 * eg: CollectionUtil.arrayMerge(String[].class, ary1,ary2)
	 * 
	 * @param clazz 数组类型
	 * @param a     合并数组一
	 * @param b     合并数组二
	 * 
	 * @param <T>   数组里元素类型
	 * @return 全并后的数组
	 */

	public static <T> T[] arrayMerge(Class<T[]> clazz, T[] a, T[] b) {
		if (ArrayUtils.isEmpty(a)) {
			return b;
		}
		if (ArrayUtils.isEmpty(b)) {
			return a;
		}
		T[] newArray = newArrayByArrayClass(clazz, a.length + b.length);
		System.arraycopy(a, 0, newArray, 0, a.length);
		System.arraycopy(b, 0, newArray, a.length, b.length);
		return newArray;
	}

	/***
	 * 取交集
	 * 
	 * @param clazz
	 * @param a
	 * @param b
	 * @return
	 */
	public static <T> T[] arrayAnd(Class<T[]> clazz, T[] a, T[] b) {
		if (ArrayUtils.isEmpty(a) || ArrayUtils.isEmpty(b)) {
			return newArrayByArrayClass(clazz, 0);
		}
		List<T> retlist = new ArrayList<>();
		for (T t : a) {
			if (ArrayUtils.contains(b, t)) {
				retlist.add(t);
			}
		}
		return retlist.toArray(newArrayByArrayClass(clazz, retlist.size()));
	}

	/**
	 * 取并集
	 * 
	 * @param clazz
	 * @param a
	 * @param b
	 * @return
	 */
	public static <T> T[] arrayOr(Class<T[]> clazz, T[] a, T[] b) {
		if (ArrayUtils.isEmpty(a) || ArrayUtils.isEmpty(b)) {
			return newArrayByArrayClass(clazz, 0);
		}
		List<T> retlist = new ArrayList<>();
		for (T t : a) {
			retlist.add(t);

		}
		for (T t : b) {
			if (!retlist.contains(t)) {
				retlist.add(t);
			}
		}
		return retlist.toArray(newArrayByArrayClass(clazz, retlist.size()));
	}

	/***
	 * 通过类型创建数组
	 * 
	 * @param clazz  类型
	 * @param length 数组长度
	 * 
	 * @param <T>    数组里元素类型
	 * @return 数组实例对象
	 */
	public static <T> T[] newArrayByArrayClass(Class<T[]> clazz, int length) {
		return (T[]) Array.newInstance(clazz.getComponentType(), length);
	}

	/**
	 * 把list分成sumPerRow一组
	 * 
	 * @param inputList 要分隔的List
	 * @param sumPerRow 第个List的个数
	 * @param <T>       List元素类型
	 * @return 二维List
	 */
	public static <T> List<List<T>> splitList(List<T> inputList, int sumPerRow) {
		if (CollectionUtils.isEmpty(inputList) || sumPerRow == 0) {
			return null;
		}
		List<List<T>> returnList = new ArrayList<List<T>>();
		List<T> addList = new ArrayList<T>();
		for (int i = 0; i < inputList.size(); i++) {
			if (i >= sumPerRow && i % sumPerRow == 0) {
				returnList.add(addList);
				addList = new ArrayList<T>();
			}
			addList.add(inputList.get(i));
		}
		returnList.add(addList);
		return returnList;
	}

	/***
	 * 把list分成listnum个list
	 * 
	 * @param inputList 输入的原始list
	 * @param listnum   每几个元素为一组进行分隔
	 * @param <T>       List元素类型
	 * @return 二维List
	 */
	public static <T> List<List<T>> splitListN(List<T> inputList, int listnum) {
		if (CollectionUtils.isEmpty(inputList) || listnum == 0) {
			return null;
		}
		int tempint = inputList.size() / listnum;
		if (tempint == 0) {
			List<List<T>> returnList = new ArrayList<List<T>>();
			returnList.add(inputList);
			return returnList;
		}
		List<List<T>> retlist = splitList(inputList.subList(0, tempint * listnum), tempint);
		int j = 0;
		for (int i = 0; i < inputList.size() % listnum; i++) {
			retlist.get(j++).add(inputList.get(tempint * listnum + i));
		}
		return retlist;
	}

	/**
	 * 通过List得到对象的单个列值
	 * 
	 * @param fromList 要操作的数据源
	 * @param colName  要提取的列名
	 * @return List 提取预定列的List
	 */
	public static List<?> getColFromObj(List<?> fromList, String colName) {
		List<Object> retList = new ArrayList<Object>();
		if (CollectionUtils.isEmpty(fromList)) {
			return retList;
		}
		for (Object object : fromList) {
			Object result = null;
			if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
				Map tempObjMap = (Map) object;
				result = tempObjMap.get(colName);
			} else {
				result = MVEL.eval(colName, object);
			}
			retList.add(result);
		}
		return retList;
	}

	/**
	 * @param inputCollection 要操作的字符
	 * @param predicate       规则
	 * @return 返回符合条件的集合并把这个集合从inputCollection删除（即inputCollection只剩余不合条件的数据）
	 */
	public static Collection selectFilter(Collection inputCollection, Predicate predicate) {
		Collection retCollection = (Collection) CollectionUtils.select(inputCollection, predicate);
		CollectionUtils.filter(inputCollection, predicate);
		return retCollection;
	}

	/***
	 * 把集合去重
	 * 
	 * @param collection 要操作的集合
	 */
	public static void distinctFilter(Collection collection) {
		Set<?> temps = new HashSet<>();
		temps.addAll(collection);
		collection.clear();
		collection.addAll(temps);
	}

	/***
	 * 过滤空值
	 * 
	 * @param includeBlack 空格模式 1：null 2：null和"" 3：null和"" 和 " " 4：3and"null"
	 * 
	 * @param orimap       要处理的map
	 */
	public static void filterNull(Map orimap, int includeBlack) {
		if (orimap == null) {
			return;
		}
		List<Object> removes = new ArrayList<>();
		for (Object key : orimap.keySet()) {
			Object value = orimap.get(key);
			boolean needRemove = false;
			switch (includeBlack) {
			case 1:
				needRemove = value == null ? true : false;
				break;
			case 2:
				needRemove = StringUtils.isEmpty(String.valueOf(value));
				break;
			case 3:
				needRemove = StringUtil.isNull(false, value);
				break;
			case 4:
				needRemove = StringUtil.isNull(true, value);
				break;
			default:
				break;
			}
			if (needRemove) {
				removes.add(key);
			}
		}
		for (Object key : removes) {
			orimap.remove(key);
		}
	}

	/*****
	 * 过滤原始的 List
	 * 
	 * @param oriList 原对象列表
	 * @param colName 对象列名
	 * @param include 允许的值
	 * @param exclude 排除的值
	 * @return 过滤后的list
	 */

	public static List filter(List oriList, final String colName, String include, String exclude) {
		List retAry = new ArrayList();
		if (CollectionUtils.isEmpty(oriList)) {
			return retAry;
		}
		if (StringUtils.isNotBlank(include)) {
			String[] iAry = include.split(",");
			for (int i = 0; i < iAry.length; i++) {
				String includeValue = iAry[i];
				for (Object eleObj : oriList) {
					try {
						if (ReflectAssist.isInterface(eleObj.getClass(), "java.util.Map")) {
							Map tempObj = (Map) eleObj;
							if (includeValue.equalsIgnoreCase(String.valueOf(tempObj.get(colName)))) {
								retAry.add(eleObj);
								break;// 退出本层循环
							}
						} else {
							Object tempObj = PropertyUtils.getProperty(eleObj, colName);
							if (includeValue.equalsIgnoreCase(String.valueOf(tempObj))) {
								retAry.add(eleObj);
								break;// 退出本层循环
							}
						}
					} catch (Exception e) {
						// TODO: handle exception
					}
				}
			}
		}

		if (StringUtils.isNotBlank(exclude)) {
			final String[] eAry = exclude.split(",");
			retAry = CollectionUtils.isEmpty(retAry) ? oriList : retAry;
			CollectionUtils.filter(retAry, new Predicate() {
				@Override
				public boolean evaluate(Object object) {
					try {
						if (ReflectAssist.isInterface(object.getClass(), "java.util.Map")) {
							Map tempObj = (Map) object;
							if (ArrayUtils.contains(eAry, String.valueOf(tempObj.get(colName)))) {
								return false;
							}
						} else {
							Object tempObj = PropertyUtils.getProperty(object, colName);
							if (ArrayUtils.contains(eAry, tempObj)) {
								return false;
							}
						}
					} catch (Exception e) {
						// TODO: handle exception
					}
					return true;
				}
			});
		}

		retAry = CollectionUtils.isEmpty(retAry) ? oriList : retAry;
		return retAry;

	}

	/***
	 * int数组转为List,因为Arrays.asList只支持对象的数组转成List
	 * 
	 * @param oriAry 源数组
	 * @return List 转换后的list
	 */
	public static List<Integer> asList(int[] oriAry) {
		List<Integer> ret = new ArrayList<Integer>();
		if (org.apache.commons.lang3.ArrayUtils.isNotEmpty(oriAry)) {
			for (int integer : oriAry) {
				ret.add(integer);
			}
		}
		return ret;
	}

	/***
	 * 把string数据转成整形List
	 * 
	 * @param oriAry 源数组
	 * @return List 转换后的list
	 */
	public static List<Integer> asList(String[] oriAry) {
		List<Integer> ret = new ArrayList<Integer>();
		if (org.apache.commons.lang3.ArrayUtils.isNotEmpty(oriAry)) {
			for (String ele : oriAry) {
				ret.add(Integer.parseInt(ele));
			}
		}
		return ret;
	}

	/***
	 * 把任意数组转成List
	 * 
	 * @param oriList 源数组
	 * @return List 转换后的list
	 */
	public static List<String> asList(List<?> oriList) {
		if (oriList == null) {
			return null;
		}
		List<String> ret = new ArrayList<String>();
		for (Object object : oriList) {
			ret.add(String.valueOf(object));
		}
		return ret;
	}

	/****
	 * 得到Properties中key以 keyPre+"." 开头的所有属性的集合
	 * 
	 * @param prop         源属性
	 * @param keyOriPre    开始值
	 * @param keyTargetPre 替换值
	 * @return 满足条件的属性集合
	 */
	public static Map<String, String> getPropsByKeypre(Properties prop, String keyOriPre, String keyTargetPre,
			boolean delPre) {
		if (prop == null || prop.size() == 0 || StringUtil.isNull(keyOriPre)) {
			return new HashMap<>();
		}
		// 20200512 处理多线程情况下：java.util.ConcurrentModificationException 问题
		Properties tempProp = (Properties) prop.clone();
		Set<Object> propKeys = tempProp.keySet();
		Map<String, String> retMap = new HashMap<String, String>();
		String tempStr = String.format("%s.",
				keyOriPre.endsWith(".") ? keyOriPre.substring(0, keyOriPre.length() - 1) : keyOriPre);

		for (Object object : propKeys) {
			String key = String.valueOf(object);
			if (key.startsWith(tempStr)) {
				// 不能用replaceFirst，只能用substring，防止出现rm-bp1505575w78f52d3(jdbc)事件。
				retMap.put(delPre ? key.substring(tempStr.length()) : key, String.valueOf(tempProp.get(key)));// 不能用prop.getProperty
																												// 会导致int取不了值
			}
		}
		if (StringUtil.isNotNull(keyTargetPre)) {
			String tempStr2 = String.format("%s.",
					keyTargetPre.endsWith(".") ? keyTargetPre.substring(0, keyOriPre.length() - 1) : keyTargetPre);
			for (Object object : propKeys) {
				String key = String.valueOf(object);
				if (key.startsWith(tempStr2)) {
					// 不能用replaceFirst，只能用substring，防止出现rm-bp1505575w78f52d3(jdbc)事件。
					retMap.put(delPre ? key.substring(tempStr2.length()) : key, String.valueOf(tempProp.get(key)));// 不能用prop.getProperty
																													// 会导致int取不了值
				}
			}
		}

		return retMap;
	}

	public static Map<String, String> getPropsByKeypre(Properties prop, String keyOriPre, boolean delPre) {
		return getPropsByKeypre(prop, keyOriPre,null,delPre);
	}

	public static Properties getPropsSubByKeypre(Properties prop, String keyPre, boolean delPre) {
		return convMapToProperties(getPropsByKeypre(prop, keyPre, delPre));
	}

	public static Properties convMapToProperties(Map map) {
		Properties properties = new Properties();
		if (MapUtils.isEmpty(map)) {
			return properties;
		} else {
			for (Object ele : map.keySet()) {
				properties.put(ele, map.get(ele));
			}
			return properties;
		}
	}

	/***
	 * 通过有序的数组快整创建map
	 * 
	 * @param input 参数，单数为key 双数为value
	 * @return 创建的map
	 */
	public static Map newMap(Object... input) {
		Map ret = new HashMap<>();
		if (ArrayUtils.isEmpty(input)) {
			return ret;
		}
		for (int i = 0; i < input.length / 2; i++) {
			Object key = input[2 * i];
			Object value = (2 * i + 1) < input.length ? input[2 * i + 1] : null;
			ret.put(key, value);
		}
		return ret;
	}

}
