/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.thread;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.CallbackUpdate;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.thread.rejected.RejectedExecutionForLog;
import org.apache.commons.lang3.StringUtils;

public class ThreadPool {
    private static final Map<String, ExecutorService> executorServiceMap = new HashMap<String, ExecutorService>();
    private static Properties newProperties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ExecutorService getThreadPoolByName(String poolname, Properties properties) {
        if (StringUtils.isEmpty((CharSequence)poolname)) {
            throw new IllegalArgumentException("\u9700\u8981\u4f20\u5165\u7ebf\u7a0b\u6c60\u540d\u79f0");
        }
        Map<String, ExecutorService> map = executorServiceMap;
        synchronized (map) {
            if (executorServiceMap.containsKey(poolname)) {
                return executorServiceMap.get(poolname);
            }
            String preStr = "common.apiext.thread.pool." + poolname + ".";
            String coreSize = properties.getProperty(preStr + "coreSize");
            String maxSize = properties.getProperty(preStr + "maxSize");
            String queueSize = properties.getProperty(preStr + "queueSize");
            String keepAliveTime = properties.getProperty(preStr + "keepAliveTime");
            String unit = properties.getProperty(preStr + "unit");
            if (StringUtils.isEmpty((CharSequence)coreSize) || StringUtils.isEmpty((CharSequence)maxSize) || StringUtils.isEmpty((CharSequence)queueSize)) {
                throw new IllegalArgumentException("\u6c60\u6838\u5fc3\u6570\u3001\u6700\u5927\u6570\u3001\u961f\u5217\u6570\u5fc5\u987b\u5b9a\u4e49");
            }
            int coreSizeInt = Integer.parseInt(coreSize);
            int maxSizeInt = Integer.parseInt(maxSize);
            int queueSizeInt = Integer.parseInt(queueSize);
            int keepAliveTimeInt = StringUtils.isEmpty((CharSequence)keepAliveTime) ? 10 : Integer.parseInt(keepAliveTime);
            TimeUnit unitT = StringUtils.isEmpty((CharSequence)unit) ? TimeUnit.SECONDS : ThreadPool.getTimeUnit(unit);
            ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(queueSizeInt);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(coreSizeInt, maxSizeInt, (long)keepAliveTimeInt, unitT, queue, new RejectedExecutionForLog());
            executor.allowCoreThreadTimeOut(true);
            executorServiceMap.put(poolname, executor);
            return executor;
        }
    }

    public static void shutdown() {
        for (String poolname : executorServiceMap.keySet()) {
            executorServiceMap.get(poolname).shutdown();
        }
        executorServiceMap.clear();
    }

    public static Map<String, ExecutorService> getExecutorservicemap() {
        return executorServiceMap;
    }

    public static final ExecutorService getDefaultPool() {
        if (newProperties == null) {
            newProperties = Conf.copyProperties();
        }
        return ThreadPool.getThreadPoolByName("default", newProperties);
    }

    private static TimeUnit getTimeUnit(String TimeUnitStr) {
        if (StringUtils.isEmpty((CharSequence)TimeUnitStr)) {
            return null;
        }
        for (TimeUnit timeUnit : TimeUnit.values()) {
            if (!timeUnit.name().equals(TimeUnitStr)) continue;
            return timeUnit;
        }
        return null;
    }

    static {
        Conf.addCallBack(new CallbackUpdate(){

            @Override
            public void doReshConf(Properties oldProperties, Properties newProperties) {
                newProperties = newProperties;
                ThreadPool.shutdown();
            }
        }, "common.apiext.thread.pool.");
    }
}

